/*
                              Editor Structure
 */

#ifndef EDITOR_H
#define EDITOR_H

#include <sys/types.h>
#include <gtk/gtk.h>

#include "v3dtex.h"
#include "v3dmodel.h"
#include "primpalette.h"
#include "view.h"
#include "texbrowser.h"
#include "clrsel.h"
#include "vmaundo.h"
#include "vmastatusbar.h"
#include "vpiinternal.h"
#include "config.h"

#ifndef gbool
# define gbool	guchar
#endif


/*
 *	Editor render menu item reference to plug-in structure,
 *	references a plug-in with a menu item. This is updated in
 *	EditorRenderMenuRegenerate().
 */
typedef struct {

	GtkWidget *w, *fw;
	vma_plugin_struct *plugin_ptr;

} vma_editor_render_mi_struct;


/*
 *      Input dialog for editor, various types of input will modify
 *      the widgets in the values_vbox, the values_vbox can be
 *      destroyed and set NULL to easilly destroy child widgets.
 */
typedef struct {

        gbool initialized;
        gbool map_state;
	gpointer editor_ptr;

	GtkAccelGroup *accelgrp;

        GtkWidget       *toplevel,
                        *values_vbox_parent,	/* Parent for values_vbox. */
                        *values_vbox,   /* Container widget holding client
					 * created widgets, can be NULL.
                                         */
                        *help_vbox,
			*help_icon_fixed,
			*help_icon_pm,
			*help_label,
			*btn_hbox;

        GtkWidget *ok_btn, *ok_btn_label;
        GtkWidget *apply_btn, *apply_btn_label;
        GtkWidget *cancel_btn, *cancel_btn_label;
        GtkWidget *help_btn, *help_btn_label;

	/* List of client created widgets. */
	GtkWidget **client_widget;
	gint total_client_widgets;

	gpointer client_data;
	/* OK and cancel function callbacks, inputs;
	 * editor_input_dialog, client_data.
	 */
	void (*func_ok_cb)(void *, void *);
        void (*func_apply_cb)(void *, void *);
	void (*func_cancel_cb)(void *, void *);

} ma_editor_idialog_struct;


/*
 *	Text dialog (for editing model primitives that contain text
 *	like comment primitives):
 */
typedef struct {

	gbool text_operating;	/* Applying or fetching text. */
	gbool pulled_out;	/* TRUE if `pulled out'. */
	gbool has_changes;
	gpointer editor_ptr;	/* Pointer back to editor structure. */
	GtkWidget *toplevel;	/* Pull out's parenting hbox. */

	/* Widgets on tool bar. */
	GtkWidget	*find_combo,
			*replace_combo,
			*case_sensitive_check,

			*revert_btn,
			*cut_btn,
			*copy_btn,
			*paste_btn;

	/* Text widget. */
	GtkWidget	*text;

	/* Last `pushed in' size of editor's text_dialog_toplevel.
	 * Used in editortdialogcb.c
	 */
	gint last_width, last_height;

        /* Cursors. */
        GdkCursor       *text_cur;

	gint model_num;		/* Can be -1. */
	gint primitive_num;	/* Can be -1 if model is type
				 * V3D_MODEL_TYPE_OTHER_DATA.
				 */

} ma_editor_tdialog_struct;

/*
 *	VMA Editor structure:
 */
typedef struct {

	gbool initialized;	/* TRUE if intiallied. */
	gbool map_state;	/* TRUE if shown (mapped). */
	gbool processing;
	gbool has_changes;	/* TRUE if has changes. */
	gbool write_protect;	/* TRUE if write protect is on. */

	GtkWidget	*toplevel,
			*menu_bar,
			*general_tool_ribbon,
			*primitives_tool_ribbon,
			*search_tool_ribbon;

	/* Docking ports for menu_bar, general_tool_ribbon,
	 * primitives_tool_ribbon, and search_tool_ribbon.
	 */
	GtkWidget	*menu_bar_dock,
			*general_tool_ribbon_dock,
			*primitives_tool_ribbon_dock,
			*search_tool_ribbon_dock;

	/* General tool ribbon buttons. */
	GtkWidget	*new_btn, *open_btn, *save_btn, *save_as_btn,
			*export_btn, *import_btn, *print_btn, *undo_btn, *redo_btn,
			*color_btn, *lighting_btn, *textures_btn;



	/* Primitive tool ribbon buttons. */
	GtkWidget	*model_header_btn,
			*model_create_btn, *model_delete_btn,
			*model_properties_btn,
			*primitive_delete_btn,
			*primitive_flip_winding_btn,
			*primitive_unitlize_normal_btn,
			*primitive_translate_btn,
			*primitive_rotate_btn,
			*primitive_scale_btn,
			*primitive_mirror_btn,
			*primitive_add_vertex_btn,
			*primitive_remove_vertex_btn,
			*primitive_light_btn,
			*primitive_light_num_spin,
                        *primitive_scratchpad_btn;
	/* Menu mapped by primitive_light_btn. */
	GtkWidget	*primitive_light_btn_menu,
			*primitive_light_btn_enabled_micheck,
			*primitive_light_btn_move_to_cursor_mi,
			*primitive_light_btn_properties_mi;
        /* Menu mapped by primitive_scratchpad_btn. */
        GtkWidget       *primitive_scratchpad_btn_menu,
                        *primitive_scratchpad_btn_insert_mi,
                        *primitive_scratchpad_btn_append_mi,
                        *primitive_scratchpad_btn_edit_mi;

	/* Primitives palette on primitives tool ribbon. */
	vma_primitives_palette_struct *prim_palette;


	/* Parent vbox for models list, values list, and views. */
	GtkWidget	*lists_and_views_toplevel;

	/* Parent vbox for the text dialog's pull out. */
	GtkWidget	*text_dialog_toplevel;

	/* Parenting panels for models list, values list, and views.
	 * Each panel is really a vbox.
	 */
	GtkWidget	*panel[3];

	GtkWidget	*models_toplevel,	/* And primitives toplevel. */
			*models_list,
			*primitives_list;

	GtkWidget	*values_toplevel,
			*values_list,
			*values_label[VMA_PRIMITIVES_MAX_VALUES],
			*values_text[VMA_PRIMITIVES_MAX_VALUES],
			*values_browse_btn[VMA_PRIMITIVES_MAX_VALUES],
			*values_apply_btn;

	/* Main vbox parent for a view widget in its maximized state. */
	GtkWidget	*view_maximized_toplevel;

	/* Holds each view_restored_toplevel vbox, this widget needs
	 * to be unmapped when a widget is maximized.
	 */
	GtkWidget       *view_restored_panel;

	/* Vbox parents for view widgets in their restored state. */
	GtkWidget	*view_restored_toplevel[
	    VMA_MAX_2D_VIEWS_PER_EDITOR + VMA_MAX_3D_VIEWS_PER_EDITOR
	];

	vma_view2d_struct	*view2d[VMA_MAX_2D_VIEWS_PER_EDITOR];
	vma_view3d_struct	*view3d[VMA_MAX_3D_VIEWS_PER_EDITOR];

	/* View cursor position in view coordinates. */
	gdouble vcursor_x, vcursor_y, vcursor_z;

	/* Important menu items and headings. */
	GtkWidget	*new_mi, *open_mi, *save_mi, *save_as_mi,
			*backup_mi, *backup_settings_mi, *revert_mi,
			*export_mi, *import_mi, *print_mi, *close_mi, *exit_mi,

			*undo_mi, *undo_milabel,
			*redo_mi, *redo_milabel,
			*cut_mi, *copy_mi, *paste_mi,
			*clipboard_mi,
			*write_protect_enabled_mi,
			*write_protect_disabled_mi,
			*model_header_mi,	/* Edit model header. */
			*sync_memory_mi,
			*preferences_mi,

			*model_create_mi, *model_delete_mi,
			*model_show_micheck, *model_properties_mi,

			*primitive_mh,		/* Primitives menu heading. */
			*primitive_create_mi,
			*primitive_create_submenu,	/* Submenu. */
			*primitive_delete_mi,
			*primitive_flip_winding_mi,
			*primitive_unitlize_normal_mi,
			*primitive_translate_mi,
			*primitive_rotate_mi,
			*primitive_scale_mi,
			*primitive_mirror_mi,
                        *primitive_snap_mi,
			*primitive_add_vertex_mi,
			*primitive_remove_vertex_mi,
			*primitive_scratchpad_insert_mi,                        
			*primitive_scratchpad_append_mi,
			*primitive_scratchpad_edit_mi,

                        *surface_clrsel_mi,
			*surface_lighting_mi,
			*surface_texture_browser_mi,

			*render_menu,

			*window_vertex_mi,
			*window_clrsel_mi,
			*window_lights_mi,
			*window_texture_browser_mi,
			*window_scratchpad_mi,

                        *help_contents_mi, *help_tutorial_mi, *help_viewing_mi,
			*help_keyboard_mi, *help_v3d_format_mi, *help_plugins_mi,
			*help_tipofday_mi,
			*help_about_mi;

	/* Render menu menu items. */
	vma_editor_render_mi_struct **render_mi;
	gint total_render_mis;

	/* List pop up menus. */
	GtkWidget	*models_list_menu,
			*models_list_delete_mi,
			*models_list_show_micheck,
			*models_list_properties_mi,

			*primitives_list_menu,
			*primitives_list_create_submenu,
			*primitives_list_delete_mi,
			*primitives_list_cut_mi,
                        *primitives_list_copy_mi,
                        *primitives_list_paste_mi,
			*primitives_list_flip_winding_mi,
                        *primitives_list_translate_mi,
                        *primitives_list_rotate_mi,
			*primitives_list_scale_mi,
			*primitives_list_mirror_mi,
                        *primitives_list_snap_mi,
                        *primitives_list_add_vertex_mi,
                        *primitives_list_remove_vertex_mi,

			*values_list_menu,
			*values_list_undo_mi,
			*values_list_undo_milabel,
			*values_list_redo_mi,
			*values_list_redo_milabel,
                        *values_list_unitlize_normal_mi,
			*values_list_snap_mi,
			*values_list_add_vertex,
			*values_list_remove_vertex,
                        *values_list_scratchpad_insert_mi,
                        *values_list_scratchpad_append_mi,
                        *values_list_scratchpad_edit_mi;
 
	/* Cursors. */
	GdkCursor	*busy_cur;

	/* Vertex decimals (number of decimals representing a vertex value). */
	guint vertex_decimals, vertex_angle_decimals;


	/* Selected model. */
	gint selected_model_item;
	/* Selected primitive(s). */
	gint	*selected_primitive,
		total_selected_primitives;
	/* Selected values, each value index corresponds to a selected
	 * primitive. There cannot be multiple selected values on one
	 * primitive.
	 */
	gint	*selected_value,
		total_selected_values;

	/* Current loaded filename (can be NULL). */
	gchar *loaded_filename;

	/* Lights. */
	vma_light_struct light[VMA_LIGHTS_MAX];

	/* Textures. */
	v3d_texture_ref_struct **texture;
	gint total_textures;

	/* Input dialog for editor. */
	ma_editor_idialog_struct idialog;

	/* The structure that holds the text widget and its related
	 * widgets for comment text editing.
	 */
	ma_editor_tdialog_struct tdialog;

	/* Status bar. */
	vma_status_bar_struct *sb;


	/* Color selection dialog. */
	vma_clrsel_struct clrsel;

	/* Texture browser. */
	ma_texture_browser_struct texture_browser;


	/* Model header items. */
	void **mh_item;
	gint total_mh_items;

	/* Models. */
	v3d_model_struct **model;
	gint total_models;


	/* Pointer back to core structure. */
	gpointer core_ptr;

	/* Undo list. */
	void **undo;
	gint total_undos, max_undos;

	void **redo;
	gint total_redos, max_redos;

} ma_editor_struct;



extern guint EditorVertexPositionDecimals(void);
extern guint EditorVertexAngleDecimals(void);
extern gint EditorSelectedLightNumber(ma_editor_struct *editor);
extern gint EditorSelectedModelIndex(ma_editor_struct *editor);

extern void EditorSetBusy(ma_editor_struct *editor);
extern void EditorSetReady(ma_editor_struct *editor);

extern ma_editor_struct *EditorCreate(gpointer core_ptr);
extern void EditorUpdateAppearance(ma_editor_struct *editor);
extern void EditorUpdateMenus(ma_editor_struct *editor);
extern void EditorRenderMenuRegenerate(ma_editor_struct *editor);
extern void EditorSyncData(ma_editor_struct *editor);
extern void EditorReset(ma_editor_struct *editor, gbool unmap);
extern void EditorDelete(ma_editor_struct *editor);

extern void EditorMap(ma_editor_struct *editor);
extern void EditorUnmap(ma_editor_struct *editor);



#endif	/* EDITOR_H */
