/*******************************************************************************
*                                                                              *
*                                   Viewmol                                    *
*                                                                              *
*                               M I L L E R . C                                *
*                                                                              *
*                 Copyright (c) Joerg-R. Hill, December 2000                   *
*                                                                              *
********************************************************************************
*
* $Id: miller.c,v 1.1 2000/12/10 15:11:39 jrh Exp $
* $Log: miller.c,v $
* Revision 1.1  2000/12/10 15:11:39  jrh
* Initial revision
*
*
*/
#include<math.h>
#include<stdio.h>
#include<string.h>
#include "viewmol.h"

void millerPlane(void);

extern void fractionalToCartesian(double, double, double, double, double, double, int, int, int);
extern double bondLength(struct MOLECULE *, int, int);
extern double bondAngle(struct MOLECULE *, int, int, int);
extern void *expmem(void *, size_t, size_t);

extern struct WINDOW windows[];
extern struct MOLECULE *molecules;
extern struct ELEMENT *elements;
extern int ne;

/* need to delete added atoms once Miller plane display has been disabled */
void millerPlane(void)
{
  struct MOLECULE *mol;
  struct ELEMENT *mp=NULL;
  double a, b, c, alpha, beta, gamma;
  double sx=0.0, sy=0.0, sz=0.0;
  int n;
  register int i, j, k;

  if (windows[VIEWER].set < 0)
    mol=&molecules[0];
  else
    mol=&molecules[windows[VIEWER].set];
  
  if (mol->existsUnitCell)
  {
    n=mol->na-mol->nmiller-8;
    a=bondLength(mol, n, n+1);
    b=bondLength(mol, n, n+2);
    c=bondLength(mol, n, n+3);
    alpha=bondAngle(mol, n+2, n, n+3);
    beta=bondAngle(mol, n+1, n, n+3);
    gamma=bondAngle(mol, n+1, n, n+2);
    for (i=0; i<ne; i++)
    {
      if (!strncmp(elements[i].symbol, "Mp", 2))
      {
        mp=&elements[i];
        break;
      }
    }
    n=mol->na;
    if (mol->nmiller == 0)
    {
      mol->atoms=(struct ATOM *)expmem((void *)mol->atoms, (size_t)(n+4),
                                       sizeof(struct ATOM));
    }
    else
    {
      n-=mol->nmiller;
      mol->na-=mol->nmiller;
    }

    for (i=0; i<3; i++)
    {
      if (mol->miller[i] != 0)
      {
        mol->atoms[n].x=0.0;
        mol->atoms[n].y=0.0;
        mol->atoms[n].z=0.0;
        mol->atoms[n].element=mp;
        strncpy(mol->atoms[n].name, "Mp", 8);
        switch (i)
        {
          case 0: mol->atoms[n].x=1.0/(double)(mol->miller[i]);
                  break;
          case 1: mol->atoms[n].y=1.0/(double)(mol->miller[i]);
                  break;
          case 2: mol->atoms[n].z=1.0/(double)(mol->miller[i]);
                  break;
        }
        n++;
      }
    }
    for (i=0; i<3; i++)
    {
      j=n;
      if (mol->miller[i] == 0)
      {
        for (k=n-1; k>=mol->na; k--)
        {
          mol->atoms[j].x=mol->atoms[k].x;
          mol->atoms[j].y=mol->atoms[k].y;
          mol->atoms[j].z=mol->atoms[k].z;
          mol->atoms[j].element=mp;
          strncpy(mol->atoms[j].name, "Mp", 8);
          switch (i)
          {
            case 0: mol->atoms[j].x+=1.0;
                    break;
            case 1: mol->atoms[j].y+=1.0;
                    break;
            case 2: mol->atoms[j].z+=1.0;
                    break;
          }
          j++;
        }
      }
      n=j;
    }
    for (i=n-1; i>=mol->na; i--)
    {
      if (mol->atoms[i].x < 0.0) sx=1.0;
      if (mol->atoms[i].y < 0.0) sy=1.0;
      if (mol->atoms[i].z < 0.0) sz=1.0;
    }
    for (i=n-1; i>=mol->na; i--)
    {
      mol->atoms[i].x+=sx;
      mol->atoms[i].y+=sy;
      mol->atoms[i].z+=sz;
    }
    mol->nmiller=n-mol->na;
    fractionalToCartesian(a, b, c, alpha, beta, gamma, FALSE, mol->na, n);
    j=mol->na-8;
    for (i=mol->na; i<n; i++)
    {
      mol->atoms[i].x+=mol->atoms[j].x;
      mol->atoms[i].y+=mol->atoms[j].y;
      mol->atoms[i].z+=mol->atoms[j].z;
/*    printf("%f %f %f\n", mol->atoms[i].x, mol->atoms[i].y, mol->atoms[i].z); */
    }
    mol->na=n;
    mol->atoms=(struct ATOM *)expmem((void *)mol->atoms, (size_t)mol->na,
                                     sizeof(struct ATOM));
  }
}
