/* -*- C++ -*-

  This file is part of ViPEC
  Copyright (C) 1991-2000 Johan Rossouw (jrossouw@alcatel.altech.co.za)

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef MICROSTRIPCALCWINDOW_H
#define MICROSTRIPCALCWINDOW_H

#include <Types.h>

#include <qdialog.h>

class QLineEdit;
class QVBoxLayout;

class MicroStripCalcWindow : public QDialog
{
  Q_OBJECT
public:
  MicroStripCalcWindow( QWidget* parent, const char * name=0 );
  virtual ~MicroStripCalcWindow();
  
private slots:
  void calcElectrical();
  void calcPhysical();
  
private:
  void errorMsg(QString msg);
  bool getSubstrateValues();
  TReal calcZo(TReal);
  TReal calcEf(TReal,TReal);
  TReal estimateW(TReal z, TReal er, TReal h);

private:
  TReal er_;
  TReal h_;
  TReal f_;
  TReal l_;
  TReal w_;
  TReal el_;
  TReal z_;

  QVBoxLayout* topLayout_;

  QLineEdit* erEdit_;
  QLineEdit* hEdit_;
  QLineEdit* fEdit_;
  QLineEdit* lEdit_;
  QLineEdit* wEdit_;
  QLineEdit* elEdit_;
  QLineEdit* zEdit_;

};


#endif
