#include <ToolButton.h>
#include <qtoolbar.h>

#include <iostream.h>

//-----------------------------------------------------------------
ToolButton::ToolButton(const QPixmap& pm, const QString& name, 
		       const QString& toolTip, QToolBar* parent)
  : QToolButton(parent, name),
    name_(name)
{
  setPixmap( pm );
  setTextLabel( toolTip, TRUE );
  connect ( this, SIGNAL ( clicked() ),
	    this, SLOT ( pressed() ) );
}

//-----------------------------------------------------------------
ToolButton::~ToolButton()
{
}

//-----------------------------------------------------------------
const QString& ToolButton::getName() const
{
  return name_;
}

//-----------------------------------------------------------------
void ToolButton::pressed()
{
  emit pressed( this );
}
