/* -*- C++ -*-

  This file is part of ViPEC
  Copyright (C) 1991-2000 Johan Rossouw (jrossouw@alcatel.altech.co.za)

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef EDITATTRIBUTESWINDOW_H
#define EDITATTRIBUTESWINDOW_H

#include <Component.h>

#include <qmap.h>
#include <qlabel.h>
#include <qdialog.h>
#include <qstring.h>

class QLineEdit;
class QVBoxLayout;
class QGridLayout;

class EditAttributesWindow : public QDialog
{
  Q_OBJECT;
public:
  EditAttributesWindow( QWidget* parent, const char * name=0 );
  virtual ~EditAttributesWindow();
  
  void setAttributeList( Component::AttributeList& list );
 
private slots:
  void ok();
  void cancel();

private:
  void destroyWidgets();

private:
  Component::AttributeList* attributeList_;
  QVBoxLayout* topLayout_;
  QGridLayout* gridLayout_;

  QList<QLabel> labelList_;
  QMap< QString, QLineEdit* > lineEditMap_;

};

#endif

