/* -*- C++ -*-
 
  This file is part of ViPEC
  Copyright (C) 1991-2000 Johan Rossouw (jrossouw@alcatel.altech.co.za)
 
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 
*/

#include <SignalGnd.h>

#include <Strings.h>

#include "../images/ground.xpm"

QPixmap* SignalGnd::pixmap_ = 0;

//-----------------------------------------------------------------
SignalGnd::SignalGnd( const QPoint& center )
    : Component( center )
{}

//-----------------------------------------------------------------
SignalGnd::~SignalGnd()
{}

//-----------------------------------------------------------------
const QString& SignalGnd::getCatagory() const
  {
    return Strings::PortCatagory;
  }

//-----------------------------------------------------------------
const QString& SignalGnd::getName() const
  {
    return Strings::SignalGndName;
  }

//-----------------------------------------------------------------
const QPixmap& SignalGnd::getPixmap() const
  {
    if (!pixmap_)
      {
        pixmap_ = new QPixmap(ground_xpm);
      }
    return *pixmap_;
  }

//-----------------------------------------------------------------
void SignalGnd::initComponent()
{
  boundingRect_ = QRect(-6, -8, 12, 16);
  addNode(0, -8, FALSE, TRUE);
}

//-----------------------------------------------------------------
void SignalGnd::drawSymbol(QPainter* p)
{
  p->moveTo(0,-8);
  p->lineTo(0,8);
  p->moveTo(-2,6);
  p->lineTo(2,6);
  p->moveTo(-4,4);
  p->lineTo(4,4);
  p->moveTo(-6,2);
  p->lineTo(6,2);
}

//-----------------------------------------------------------------
bool SignalGnd::initSweep()
{
  return FALSE;
}

//-----------------------------------------------------------------
void SignalGnd::addToAdmittanceMatrix( TReal, Matrix* )
{
}
