// Header for error type

/*

    This file is part of VIPS.
    
    VIPS is free software; you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

/*

    These files are distributed with VIPS - http://www.vips.ecs.soton.ac.uk

 */

#ifndef IM_VERROR_H
#define IM_VERROR_H

#include <string>
#include <iostream>

// Error type
class VError { 
	std::string note; 
public:
	VError( const char *str ) { note = str; };
	VError() {};
	virtual ~VError() {};

	// Print message and quit
	void perror( const char * );
	void perror();

	// Append some more text to the message
	VError &app( const char *txt );
	VError &app( const int i );

	// Extract string
	const std::string getError() { return( note ); };
	friend std::ostream &operator<<( 
		std::ostream &file, const VError &err );
};

// Two convenience functions
void verror( const char *str );
void verror();

#endif /*IM_VERROR_H*/
