/* @(#) Append image2 history to the end of image1 history. Don't copy the
 * @(#) first line, as this is supposed to hold non-history information.
 * @(#) Used for two-input functions that need to make sure the output image
 * @(#) has all of it's inputs history together (eg. im_tbmerge()).
 * @(#)
 * @(#) int 
 * @(#) im_append_Hist( image1, image2 )
 * @(#) IMAGE *image1, *image2;
 * @(#)
 * @(#) Returns 0 on success or -1 on fail.
 * @(#)
 *
 * Written on: 8/11/93 JC
 */

/*

    This file is part of VIPS.
    
    VIPS is free software; you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

/*

    These files are distributed with VIPS - http://www.vips.ecs.soton.ac.uk

 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif /*HAVE_CONFIG_H*/
#include <vips/intl.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <vips/vips.h>

#ifdef WITH_DMALLOC
#include <dmalloc.h>
#endif /*WITH_DMALLOC*/

int 
im_append_Hist( IMAGE *image1, IMAGE *image2 )
{	
	char *p, *out;
	int tot;

	/* Do trivial cases.
	 */
	if( !image2->Hist )
		/* No history to append. No action.
		 */
		return( 0 );
	if( !image1->Hist )
		/* No history on image1 - just copy image2 history over.
		 */
		return( im_cp_Hist( image1, image2 ) );

	/* Find the start of the 2nd line of image2->Hist, if there is one.
	 */
	if( !(p = strchr( image2->Hist, '\n' )) )
		p = image2->Hist;
	
	/* How much space do we need?
	 */
	tot = strlen( image1->Hist ) + strlen( p ) + 1;
	if( !(out = im_malloc( NULL, tot )) ) 
		return( -1 );

	/* Copy Hists over.
	 */
	strcpy( out, image1->Hist );
	strcat( out, p );

	/* Free old image1 history and install new history buffer.
	 */
	im_free( image1->Hist );
	image1->Hist = out;

	return( 0 );
}
