#ifndef __VLAD_H__

#include "config.h"

#define VLAD_MAX_BUFFER	256

#ifndef NULL
#define NULL 0
#endif

/* a single attribute */
struct attr {
	char *name;
	char *value;
	};

/* one entry (including subtrees) */
struct entry {
	struct entry	*parent;

	struct entry	*next;
	struct entry	*prev;

	char		*dn;
	char		*shortdn;

	struct attr	**attrs;
	unsigned int	attrs_timestamp;

	struct entry	*subentries_head;
	struct entry	*subentries_tail;
	unsigned int	subentries_timestamp;

	int		expanded;
	int		depth;
	};

/* command line options */
struct options {
	char		*host;
	long		port;
	char		*basedn;
	char		*binddn;
	char		*bindpw;
	};

/* prototypes */

/* attr.c */
extern struct attr *create_attr_struct(void);
extern void free_attr_struct(struct attr *);
extern void free_attr_set(struct attr **);

/* entry.c */
extern struct entry *create_entry_struct(void);
extern void free_entry_struct(struct entry *);
extern void free_entry_list(struct entry *);
extern struct entry *create_root_entry_struct(void);

/* core.c */
extern struct options opt;
extern char buffer[];

extern void set_title(char *, ...);
extern void clear_title(void);
extern void set_status(char *, ...);
extern void clear_status(void);

/* ldap.c */
extern int get_attrs(struct entry *, int);
extern int get_subtree(struct entry *, int);
extern int get_tree(struct entry *, int);

#define __VLAD_H__

#endif
