/*
 * Decompiled with CFR 0.152.
 */
package rdr;

import rdr.Exception;

public abstract class InStream {
    public static int maxStringLength = 65535;
    protected byte[] b;
    protected int ptr;
    protected int end;

    public final int check(int n, int n2) {
        if (this.ptr + n * n2 > this.end) {
            if (this.ptr + n > this.end) {
                return this.overrun(n, n2);
            }
            n2 = (this.end - this.ptr) / n;
        }
        return n2;
    }

    public final void check(int n) {
        if (this.ptr + n > this.end) {
            this.overrun(n, 1);
        }
    }

    public final int readS8() {
        this.check(1);
        return this.b[this.ptr++];
    }

    public final int readS16() {
        this.check(2);
        byte by = this.b[this.ptr++];
        int n = this.b[this.ptr++] & 0xFF;
        return by << 8 | n;
    }

    public final int readS32() {
        this.check(4);
        byte by = this.b[this.ptr++];
        int n = this.b[this.ptr++] & 0xFF;
        int n2 = this.b[this.ptr++] & 0xFF;
        int n3 = this.b[this.ptr++] & 0xFF;
        return by << 24 | n << 16 | n2 << 8 | n3;
    }

    public final int readU8() {
        return this.readS8() & 0xFF;
    }

    public final int readU16() {
        return this.readS16() & 0xFFFF;
    }

    public final int readU32() {
        return this.readS32() & 0xFFFFFFFF;
    }

    public final String readString() {
        int n = this.readU32();
        if (n > maxStringLength) {
            throw new Exception("InStream max string length exceeded");
        }
        char[] cArray = new char[n];
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2 + this.check(1, n - n2);
            while (n2 < n3) {
                cArray[n2++] = (char)this.b[this.ptr++];
            }
        }
        return new String(cArray);
    }

    public final void skip(int n) {
        while (n > 0) {
            int n2 = this.check(1, n);
            this.ptr += n2;
            n -= n2;
        }
    }

    public void readBytes(byte[] byArray, int n, int n2) {
        int n3 = n + n2;
        while (n < n3) {
            int n4 = this.check(1, n3 - n);
            System.arraycopy(this.b, this.ptr, byArray, n, n4);
            this.ptr += n4;
            n += n4;
        }
    }

    public final int readOpaque8() {
        return this.readU8();
    }

    public final int readOpaque16() {
        return this.readU16();
    }

    public final int readOpaque32() {
        return this.readU32();
    }

    public final int readOpaque24A() {
        this.check(3);
        byte by = this.b[this.ptr++];
        byte by2 = this.b[this.ptr++];
        byte by3 = this.b[this.ptr++];
        return by << 24 | by2 << 16 | by3 << 8;
    }

    public final int readOpaque24B() {
        this.check(3);
        byte by = this.b[this.ptr++];
        byte by2 = this.b[this.ptr++];
        byte by3 = this.b[this.ptr++];
        return by << 16 | by2 << 8 | by3;
    }

    public abstract int pos();

    public boolean bytesAvailable() {
        return this.end != this.ptr;
    }

    public final byte[] getbuf() {
        return this.b;
    }

    public final int getptr() {
        return this.ptr;
    }

    public final int getend() {
        return this.end;
    }

    public final void setptr(int n) {
        this.ptr = n;
    }

    protected abstract int overrun(int var1, int var2);

    protected InStream() {
    }
}

