/*
 * Decompiled with CFR 0.152.
 */
package vncviewer;

import java.awt.Button;
import java.awt.Event;
import java.awt.Panel;
import java.awt.TextArea;
import vncviewer.CConn;
import vncviewer.Dialog;

class ClipboardDialog
extends Dialog {
    CConn cc;
    String current;
    TextArea textArea;
    Button clearButton;
    Button sendButton;
    Button cancelButton;

    public void initDialog() {
        this.textArea.setText(this.current);
        this.textArea.selectAll();
    }

    public void serverCutText(String string) {
        this.current = string;
        this.textArea.setText(string);
        this.textArea.selectAll();
    }

    public void setSendingEnabled(boolean bl) {
        this.sendButton.setEnabled(bl);
    }

    public boolean action(Event event, Object object) {
        if (event.target == this.clearButton) {
            this.current = "";
            this.textArea.setText(this.current);
        } else if (event.target == this.sendButton) {
            this.ok = true;
            this.current = this.textArea.getText();
            this.cc.writeClientCutText(this.current);
            this.endDialog();
        } else if (event.target == this.cancelButton) {
            this.ok = false;
            this.endDialog();
        }
        return true;
    }

    public ClipboardDialog(CConn cConn) {
        super(false);
        this.cc = cConn;
        this.setTitle("VNC clipboard");
        this.textArea = new TextArea(5, 50);
        this.add("Center", this.textArea);
        Panel panel = new Panel();
        this.clearButton = new Button("Clear");
        panel.add(this.clearButton);
        this.sendButton = new Button("Send to VNC server");
        panel.add(this.sendButton);
        this.cancelButton = new Button("Cancel");
        panel.add(this.cancelButton);
        this.add("South", panel);
        this.pack();
    }
}

