
(**
   A senseless demo-programm for VisualOberon.
**)

MODULE XTest;

(*
    Demo for VisualOberon.
    Copyright (C) 1997  Tim Teulings (rael@edge.ping.de)

    This file is part of VisualOberon.

    VisualOberon is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    VisualOberon is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with VisualOberon. If not, write to the Free Software
    Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*)

IMPORT A   := VOArray,
       B   := VOButton,
       BO  := VOBool,
       CA  := VOColorArea,
       CY  := VOCycle,
       CL  := VOClock,
       D   := VODisplay,
       DS  := VODataStreamModel,
       E   := VOEvent,
       F   := VOFrame,
       FG  := VOFrameGroup,
       FU  := VOFuelGauge,
       G   := VOGUIObject,
       K   := VOKeyHandler,
       L   := VOLabel,
       LC  := VOLightChain,
       LED := VOLED,
(*       LF  := VOLLFor,*)
(*       LI  := VOLLInt,*)
       LM  := VOListModel,
       LS  := VOList,
       M   := VOMenu,
       MD  := VOMsgDialog,
       O   := VOObject,
       OZ  := VOOszil,
       P   := VOPanel,
       PA  := VOPane,
       PG  := VOPrefsGUI,
       PO  := VOPopup,
       PW  := VOPower,
       Q   := VOQuickHelp,
       R   := VORadio,
       S   := VOSpace,
       SC  := VOStringClock,
       SL  := VOSlider,
       ST  := VOString,
       STL := VOStatusLine,
       T   := VOText,
       TA  := VOTab,
       TB  := VOToolbar,
              VOUsePrefs,
       V   := VOValue,
       W   := VOWindow,
       WF  := VOWireFrame,
       WG  := VOWindowGroup,
       X   := VOImage,

(*              C,*)
              Err;

CONST
  quitId     = 100;
  settingsId = 101;
  aboutId    = 103;

TYPE
  Display*     = POINTER TO DisplayDesc;
  DisplayDesc* = RECORD (D.DisplayDesc)
                   popup     : PO.Popup;
                   lText     : T.Text;
                   status    : T.Text;
                   fuel      : FU.FuelGauge;
                   list      : LS.List;
                   listModel : LM.ListModel;
                   fTimeOut  : D.TimeOut;
                   oszil     : OZ.Oszil;
                   current   : V.IntModel;
                   stream    : DS.StreamLongModel;
                 END;

VAR
  d           : Display;
  w           : W.Window;

(*  dir         : LI.DIRPtr;
  dirEntry    : LI.direntPtr;
  dirName     : C.charPtr1d;*)

  anim        : WF.WireFrame;
  button      : B.Button;
  boolModel   : V.BoolModel;
  bool        : BO.Bool;
  clock       : CL.Clock;
  color       : CA.ColorArea;
  cycle       : CY.Cycle;
  intModel    : V.IntModel;
  keyHandler  : K.KeyHandler;
  label       : L.Label;
  led         : LED.LED;
  light       : LC.LightChain;
  list        : LS.List;
  listEntry   : LM.ListEntry;
  menu,
  sub         : M.Menu;
  pane1,
  pane2,
  pane3       : PA.Pane;
  strip       : M.MenuStrip;
  text        : T.Text;
  tool        : TB.Toolbar;
  horiz,
  panel       : P.Panel;
  power       : PW.Power;
  radio       : R.Radio;
  space       : S.Space;
  slider      : SL.Slider;
  stringClock : SC.StringClock;
  stringModel : V.StringModel;
  string      : ST.String;
  stl         : STL.StatusLine;
  tab         : TA.Tab;
  top         : P.Panel;
  frame       : FG.FrameGroup;
  wGroup      : WG.WindowGroup;

  msg2Exit    : D.Msg2Exit;

  i           : LONGINT;

  topPos      : V.IntModel;

  PROCEDURE (d : Display) Receive*(message : O.Message);

  BEGIN
    WITH
      message : B.PressedMsg DO
        d.status.SetText("Button pressed!");
        RETURN;
    | message : ST.EnteredMsg DO
        d.status.SetText("Text entered!");
        RETURN;
    | message : M.SelectedMsg DO
        d.status.SetText("Menuitem selected!");
        CASE message.id OF
          settingsId:
            PG.settings.SetParent(w);
            PG.settings.SetPosition(D.centerOnParent,D.centerOnParent);
            PG.settings.Open;
        | quitId:
            d.Exit;
        | aboutId:
            IF MD.Dialog(d,w,"About XTest",
                         "XTest  1997 Tim Teulings\n\nXTest is a demo for the VisualOberon package","_Ok#",MD.info)#NIL THEN END;
        ELSE
        END;
        RETURN;
    | message : LS.SelectedMsg DO
        RETURN;
    | message : CY.SelectedMsg DO
        d.status.SetText("Cycled to next entry!");
        RETURN;
    | message : D.TimeOutMsg DO
        IF message.timeOut=d.fTimeOut THEN
          d.current.SetLongint((d.current.GetLongint()+1) MOD 101);
          d.stream.SetValue((d.current.GetLongint()+1) MOD 101,0);
          d.fTimeOut:=d.AddTimeOut(0,100,d);
          RETURN;
        END;
    ELSE
    END;
    d.Receive^(message);
  END Receive;

  PROCEDURE MakeOKPopup(gadget : B.Button):PO.Popup;

  VAR
    array      : A.Array;
    button1,
    button2    : B.Button;
    open       : PO.Msg2Open;
    close      : PO.Msg2Close;
    popup      : PO.Popup;
    keyHandler : K.KeyHandler;

  BEGIN
    (* Make popupwindow *)

    NEW(keyHandler);
    keyHandler.Init;

    NEW(array);
    array.Init;
    array.Set(2,TRUE);
    array.SetFlags({G.horizontalFlex,G.verticalFlex});

      NEW(button1);
      button1.Init;
      button1.SetFlags({G.horizontalFlex,G.verticalFlex});
      button1.SetLabelText("Ok*",keyHandler);
      keyHandler.AddFocusObject(button1);
    array.Add(button1);

      NEW(button2);
      button2.Init;
      button2.SetFlags({G.horizontalFlex,G.verticalFlex});
      button2.SetLabelText("Cancel^",keyHandler);
      keyHandler.AddFocusObject(button2);
    array.Add(button2);

    NEW(popup);
    popup.Init;
    popup.AddKeyHandler(keyHandler);
    popup.SetDisplay(d);
    popup.SetTop(array,gadget);
    NEW(open);
    open.destination:=popup;
    gadget.AddHandler(open, B.pressedMsg);
    NEW(close);
    close.destination:=popup;
    button1.AddHandler(close, B.pressedMsg);
    NEW(close);
    close.destination:=popup;
    button2.AddHandler(close, B.pressedMsg);
    RETURN popup;
  END MakeOKPopup;

  PROCEDURE NewImageEntry*(file : ARRAY OF CHAR):LM.SimplEntry;

  VAR
    image : X.Image;

  BEGIN
    NEW(image);
    image.Init;
    image.SetAlignment(G.alignLeft,G.alignCenter);
    image.SetFilename(file);

    RETURN LM.NewSimplEntry(image);
  END NewImageEntry;

  PROCEDURE NewImage*(file : ARRAY OF CHAR):X.Image;

  VAR
    image : X.Image;

  BEGIN
    NEW(image);
    image.Init;
    image.SetAlignment(G.alignCenter,G.alignCenter);
    image.SetFilename(file);

    RETURN image;
  END NewImage;


BEGIN
  NEW(d);
  IF ~d.InitDisplay("XTest") THEN
    Err.String("Cannot init application!"); Err.Ln;
    HALT(1);
  END;

  NEW(keyHandler);
  keyHandler.Init;

  NEW(d.current);
  d.current.Init;
  d.current.SetLongint(0);

  NEW(d.stream);
  d.stream.Init;
  d.stream.SetNotificationMode(DS.notifyImplicit);
  d.stream.SetSize(1);

  NEW(top);
  top.Init;
  top.SetFlags({G.horizontalFlex,G.verticalFlex});
  top.Set(P.vertical);

    (* The submenues will be added later *)

    NEW(space);
    space.Init;
    space.Set(TRUE,S.normal);
  top.Add(space);

    NEW(tab);
    tab.Init;
    tab.SetFlags({G.horizontalFlex,G.verticalFlex});
    keyHandler.AddFocusObject(tab);

(*      NEW(frame);
      frame.Init;
      frame.SetFlags({G.horizontalFlex,G.verticalFlex});
      frame.SetFrame(F.groupFrame);
      frame.SetLabel(T.MakeLeftText("\esWelcome..."));*)

        NEW(light);
        light.Init;
        light.SetFlags({G.horizontalFlex});
        light.SetText("Welcome to VisualOberon!" );


(*    frame.Add(light);*)
      text:=T.MakeCenterText("Welcome");
    tab.AddTab(text,light(*frame*));

      NEW(frame);
      frame.Init;
      frame.SetFlags({G.horizontalFlex,G.verticalFlex});
      frame.SetFrame(F.groupFrame);
      frame.SetTextLabel("Text...");

        d.lText:=T.MakeLeftText("This is a\n\eamultiline\en text!\nCreated using the \ebVOText-class\en!\n\erRight alligned\n\ec\eucentered...\en\n...over two lines\n\elSpalte 1 \tSpalte 2 \tSpalte 3\neins \tzwei \tdrei\n\n\en\ew\euThis is a text in warning color!\en\n\nWe also support different fonts:\nThis f.e. is written with a \effixed font\ep!");
        d.lText.SetHelpObject(Q.InitHelp(d,T.MakeLeftText("The powerfull textimage\nof VisualOberon!"),d.lText));

      frame.Add(d.lText);
      text:=T.MakeCenterText("Text");
    tab.AddTab(text,frame);

      NEW(horiz);
      horiz.Init;
      horiz.Set(P.horizontal);
      horiz.SetFlags({G.horizontalFlex,G.verticalFlex});

        NEW(space);
        space.Init;
        space.Set(FALSE,S.normal);
        space.SetFlags({G.horizontalFlex});
      horiz.Add(space);

        NEW(label);
        label.Init;
        label.Set(TRUE);
        label.SetHelpObject(Q.InitHelp(d,T.MakeLeftText("Bool-gadgets!"),label));

          NEW(boolModel);
          boolModel.Init;
          boolModel.SetBoolean(TRUE);

          FOR i:=0 TO 4 DO
            NEW(bool);
            bool.Init;
            bool.SetModel(boolModel);
          label.AddTextLabel("CheckMark",bool);
            keyHandler.AddFocusObject(bool);
          END;

          NEW(led);
          led.Init;
          led.SetModel(boolModel);
          label.AddTextLabel("Power LED",led);

      horiz.Add(label);

        NEW(space);
        space.Init;
        space.Set(FALSE,S.normal);
        space.SetFlags({G.horizontalFlex});
      horiz.Add(space);

        NEW(label);
        label.Init;
        label.Set(TRUE);
        label.SetHelpObject(Q.InitHelp(d,T.MakeLeftText("Radiobuttons..."),label));

        NEW(intModel);
        intModel.Init;
        intModel.SetLongint(0);

        FOR i:=0 TO 4 DO
          NEW(radio);
          radio.Init;
          radio.SetModel(intModel,i);
          keyHandler.AddFocusObject(radio);
        label.AddTextLabel("Radiobutton",radio);
        END;
      horiz.Add(label);

        NEW(space);
        space.Init;
        space.Set(FALSE,S.normal);
        space.SetFlags({G.horizontalFlex});
      horiz.Add(space);

      text:=T.MakeCenterText("B&R");
    tab.AddTab(text,horiz);

      NEW(panel);
      panel.Init;
      panel.Set(P.vertical);
      panel.SetFlags({G.horizontalFlex,G.verticalFlex});

        NEW(topPos);
        topPos.Init;
        topPos.SetLongint(1997);

        NEW(slider);
        slider.Init;
        slider.Set(FALSE);
        slider.SetFlags({G.horizontalFlex});
        slider.SetRange(1,2997);
        slider.SetModel(topPos);
        keyHandler.AddFocusObject(slider);
      panel.Add(slider);

        NEW(space);
        space.Init;
        space.Set(TRUE,S.normal);
        space.SetFlags({G.verticalFlex});
      panel.Add(space);

        NEW(button);
        button.Init;
        button.SetLabelText("_Press me for \espopup\en!#",keyHandler);
        keyHandler.AddFocusObject(button);
        button.Forward(B.pressedMsg,d);
        button.SetHelpObject(Q.InitHelp(d,T.MakeLeftText("Press this button\nto get a little\npopup-menu!"),button));
        d.popup:=MakeOKPopup(button);
      panel.Add(button);

        NEW(space);
        space.Init;
        space.Set(TRUE,S.normal);
        space.SetFlags({G.verticalFlex});
      panel.Add(space);

        NEW(button);
        button.Init;
        button.SetText("I'm disabled!");
        button.Disable(TRUE);
        button.SetHelpObject(Q.InitHelp(d,T.MakeLeftText("This one is disabled!"),button));
        keyHandler.AddFocusObject(button);
      panel.Add(button);

        NEW(space);
        space.Init;
        space.Set(TRUE,S.normal);
        space.SetFlags({G.verticalFlex});
      panel.Add(space);

        NEW(intModel);
        intModel.Init;
        intModel.SetLongint(0);

        NEW(cycle);
        cycle.Init;
          text:=T.MakeCenterText("press me!");
        cycle.Add(text);
          text:=T.MakeCenterText("\esThank you :-)");
        cycle.Add(text);
        cycle.SetModel(intModel);
        cycle.SetHelpObject(Q.InitHelp(d,T.MakeLeftText("This is a cycle-gadget.\npress it to cycle\nthrough the different\nentries...!"),cycle));
        keyHandler.AddFocusObject(cycle);
        cycle.Forward(CY.selectedMsg,d);
      panel.Add(cycle);

        NEW(space);
        space.Init;
        space.Set(TRUE,S.normal);
        space.SetFlags({G.verticalFlex});
      panel.Add(space);

        NEW(d.oszil);
        d.oszil.Init;
        d.oszil.SetFlags({G.horizontalFlex,G.verticalFlex});
        d.oszil.SetRange(0,150);
        d.oszil.SetInterval(100,10);
        d.oszil.SetModel(d.stream);
      panel.Add(d.oszil);

        NEW(space);
        space.Init;
        space.Set(TRUE,S.normal);
        space.SetFlags({G.verticalFlex});
      panel.Add(space);

        NEW(d.fuel);
        d.fuel.Init;
        d.fuel.SetFlags({G.horizontalFlex});
        d.fuel.SetRange(0,100);
        d.fuel.SetModel(d.current);
      panel.Add(d.fuel);

        NEW(space);
        space.Init;
        space.Set(TRUE,S.normal);
        space.SetFlags({G.verticalFlex});
      panel.Add(space);

        NEW(stringModel);
        stringModel.Init;
        stringModel.SetString("VisualOberon is really, really, really, really, really fantastic!");

        NEW(string);
        string.Init;
        string.SetFlags({G.horizontalFlex});
        string.SetHelpObject(Q.InitHelp(d,T.MakeLeftText("A simple string-gadget!"),string));
        string.SetModel(stringModel);
        keyHandler.AddFocusObject(string);
        string.Forward(ST.enteredMsg,d);
      panel.Add(string);

        NEW(space);
        space.Init;
        space.Set(TRUE,S.normal);
        space.SetFlags({G.verticalFlex});
      panel.Add(space);

        NEW(stringModel);
        stringModel.Init;
        stringModel.SetString("Drop on me!");

        NEW(string);
        string.Init;
        string.SetFlags({G.horizontalFlex});
        string.SetHelpObject(Q.InitHelp(d,T.MakeLeftText("A simple string-gadget!"),string));
        string.SetModel(stringModel);
        keyHandler.AddFocusObject(string);
        string.Forward(ST.enteredMsg,d);
      panel.Add(string);

        NEW(space);
        space.Init;
        space.Set(TRUE,S.normal);
        space.SetFlags({G.verticalFlex});
      panel.Add(space);

      text:=T.MakeCenterText("Other");
    tab.AddTab(text,panel);

      NEW(horiz);
      horiz.Init;
      horiz.Set(P.horizontal);
      horiz.SetFlags({G.horizontalFlex,G.verticalFlex});

        NEW(d.listModel);
        d.listModel.Init;
        d.listModel.Append(LM.NewTextEntry("First entry"));
        d.listModel.Append(LM.NewTextEntry("Second entry"));
        d.listModel.Append(LM.NewTextEntry("Third entry"));
        d.listModel.Append(LM.NewTextEntry("Fourth entry"));
        d.listModel.Append(LM.NewTextEntry("Fifth entry"));
        d.listModel.Append(LM.NewTextEntry("Sixth entry"));
        d.listModel.Append(LM.NewTextEntry("Seventh entry"));
        d.listModel.Append(LM.NewTextEntry("Eight entry"));
        d.listModel.Append(LM.NewTextEntry("Ninth entry"));
        d.listModel.Append(LM.NewTextEntry("11. entry"));
        d.listModel.Append(LM.NewTextEntry("12. entry"));
        d.listModel.Append(LM.NewTextEntry("13. entry"));
        d.listModel.Append(LM.NewTextEntry("14. entry"));
        d.listModel.Append(LM.NewTextEntry("15. entry"));
        d.listModel.Append(LM.NewTextEntry("16. entry"));
        d.listModel.Append(LM.NewTextEntry("17. entry"));
        d.listModel.Append(LM.NewTextEntry("18. entry"));
        d.listModel.Append(LM.NewTextEntry("19. entry"));
        d.listModel.Append(LM.NewTextEntry("20. entry"));
        d.listModel.Append(LM.NewTextEntry("This is a very, very, very, very long entry :-)"));

        listEntry:=d.listModel.Get(5);
        listEntry.Select;

        NEW(d.list);
        d.list.Init;
        d.list.SetFlags({G.horizontalFlex,G.verticalFlex});
        d.list.UseScroller(TRUE);
        d.list.SetModel(d.listModel);
        d.list.SetHelpObject(Q.InitHelp(d,T.MakeLeftText("VisualOberon also supports\na simple list-gadget!"),d.list));
        keyHandler.AddFocusObject(d.list);
        d.list.Forward(LS.selectedMsg,d);
      horiz.Add(d.list);

      text:=T.MakeCenterText("List");
    tab.AddTab(text,horiz);

      NEW(horiz);
      horiz.Init;
      horiz.Set(P.horizontal);
      horiz.SetFlags({G.horizontalFlex,G.verticalFlex});

        NEW(d.listModel);
        d.listModel.Init;
        d.listModel.Append(NewImageEntry("xpm/new.xpm"));
        d.listModel.Append(NewImageEntry("xpm/open.xpm"));
        d.listModel.Append(NewImageEntry("xpm/save.xpm"));
        d.listModel.Append(NewImageEntry("xpm/redo.xpm"));
        d.listModel.Append(NewImageEntry("xpm/undo.xpm"));
        d.listModel.Append(NewImageEntry("xpm/first.xpm"));
        d.listModel.Append(NewImageEntry("xpm/left.xpm"));
        d.listModel.Append(NewImageEntry("xpm/current.xpm"));
        d.listModel.Append(NewImageEntry("xpm/right.xpm"));
        d.listModel.Append(NewImageEntry("xpm/last.xpm"));
        d.listModel.Append(NewImageEntry("xpm/cut.xpm"));
        d.listModel.Append(NewImageEntry("xpm/copy.xpm"));
        d.listModel.Append(NewImageEntry("xpm/paste.xpm"));
        d.listModel.Append(NewImageEntry("xpm/insert.xpm"));
        d.listModel.Append(NewImageEntry("xpm/export.xpm"));
        d.listModel.Append(NewImageEntry("xpm/help.xpm"));
        d.listModel.Append(NewImageEntry("xpm/mail.xpm"));
        d.listModel.Append(NewImageEntry("xpm/followmail.xpm"));
        d.listModel.Append(NewImageEntry("xpm/remail.xpm"));
        d.listModel.Append(NewImageEntry("xpm/news.xpm"));
        d.listModel.Append(NewImageEntry("xpm/renews.xpm"));
        d.listModel.Append(NewImageEntry("xpm/pgp.xpm"));
        d.listModel.Append(NewImageEntry("xpm/popup.xpm"));

        NEW(list);
        list.Init;
        list.SetReadOnly(TRUE);
        list.SetFlags({G.horizontalFlex,G.verticalFlex});
        list.SetModel(d.listModel);
        keyHandler.AddFocusObject(list);
        list.Forward(LS.selectedMsg,d);
      horiz.Add(list);

      text:=T.MakeCenterText("Image");
    tab.AddTab(text,horiz);

      NEW(clock);
      clock.Init;
      clock.SetFlags({G.horizontalFlex,G.verticalFlex});
      clock.ShowFrame(FALSE);
      clock.SetText("%H:%M:%S","%D.%m.%y");
      clock.SetHelpObject(Q.InitHelp(d,T.MakeLeftText("This is the VO-clock!"),clock));
      text:=T.MakeCenterText("Clock");
    tab.AddTab(text,clock);

      NEW(pane1);
      pane1.Init;
      pane1.SetFlags({G.horizontalFlex,G.verticalFlex});
      pane1.Set(PA.vertical);

        NEW(pane2);
        pane2.Init;
        pane2.SetFlags({G.horizontalFlex,G.verticalFlex});
        pane2.Set(PA.horizontal);

          NEW(anim);
          anim.Init;
          anim.SetFlags({G.horizontalFlex,G.verticalFlex});
          anim.SetViewer(0,0,-2000,-500);
(*        (* Front plane *)
        anim.AddLine(-25, 25,25, 25, 25,25);
        anim.AddLine( 25, 25,25, 25,-25,25);
        anim.AddLine( 25,-25,25,-25,-25,25);
        anim.AddLine(-25,-25,25,-25, 25,25);

        (* back plane *)
        anim.AddLine(-25, 25,-25, 25, 25,-25);
        anim.AddLine( 25, 25,-25, 25,-25,-25);
        anim.AddLine( 25,-25,-25,-25,-25,-25);
        anim.AddLine(-25,-25,-25,-25, 25,-25);

        (* connections between front and back *)
        anim.AddLine( 25, 25,25, 25, 25,-25);
        anim.AddLine(-25,-25,25,-25,-25,-25);
        anim.AddLine(-25, 25,25,-25, 25,-25);
        anim.AddLine( 25,-25,25, 25,-25,-25);*)

          (* outer O *)
          anim.AddLine( 50, 0,0, 50,50,0);
          anim.AddLine( 50,50,0,-50,50,0);
          anim.AddLine(-50, 0,0,-50,50,0);
          anim.AddLine( 50, 0,0,-50, 0,0);

          (* inner O *)
          anim.AddLine( 40,10,0, 40,40,0);
          anim.AddLine( 40,40,0,-40,40,0);
          anim.AddLine(-40,10,0,-40,40,0);
          anim.AddLine( 40,10,0,-40,10,0);

          (* V *)
          anim.AddLine( 50,  0,0,50, -25,0);
          anim.AddLine( 50,-25,0, 0, -25,0);

          anim.AddLine(-50,  0,0,50,-100,0);

          anim.AddLine( 50,-75,0,50,-100,0);
          anim.AddLine(  0,-25,0,50, -75,0);
        pane2.Add(anim);


          NEW(color);
          color.Init;
          color.SetFlags({G.horizontalFlex,G.verticalFlex});
          color.SetColor(D.halfShadowColor);
        pane2.Add(color);

      pane1.Add(pane2);

        NEW(pane3);
        pane3.Init;
        pane3.SetFlags({G.horizontalFlex,G.verticalFlex});
        pane3.Set(PA.horizontal);

          NEW(color);
          color.Init;
          color.SetFlags({G.horizontalFlex,G.verticalFlex});
          color.SetColor(D.halfShadowColor);
        pane3.Add(color);

          NEW(power);
          power.Init;
          power.SetFlags({G.horizontalFlex,G.verticalFlex});
        pane3.Add(power);

      pane1.Add(pane3);

      text:=T.MakeCenterText("Pane");
    tab.AddTab(text,pane1);

    NEW(strip);
    strip.Init;
    strip.Forward(M.selectedMsg,d);

    menu:=M.InitMenu(d);
        sub:=M.InitMenu(d);
          sub.AddTextItem("New","",0);
          sub.AddTextItemSC("Open...","a+o",1,E.altMask,"o",keyHandler);
          sub.AddTextItem("Save","a+s",2);
          sub.AddSeparator;
          sub.AddTextItemSC("\ew\ebQuit","a+q",quitId,E.altMask,"q",keyHandler);
      menu.AddTextSubMenu("File",sub);
      strip.AddTextStrip("File",sub);
        sub:=M.InitMenu(d);
          sub.AddTextItem("Cut","a+x",4);
          sub.AddTextItem("Copy","a+c",5);
          sub.AddTextItem("Paste","a+v",6);
      menu.AddTextSubMenu("Edit",sub);
      strip.AddTextStrip("Edit",sub);
        sub:=M.InitMenu(d);
          sub.AddTextItem("Find...","a+f",7);
          sub.AddTextItem("Find next","a+n",8);
          sub.AddSeparator;
          sub.AddTextItem("Replace...","a+r",9);
          sub.AddTextItem("Replace next","a+y",10);
          sub.AddSeparator;
          sub.AddTextItem("Goto","a+g",11);
      menu.AddTextSubMenu("Search",sub);
      strip.AddTextStrip("Search",sub);
        sub:=M.InitMenu(d);
          sub.AddTextItem("No extras currently :-)","",12);
      menu.AddTextSubMenu("Extras",sub);
      strip.AddTextStrip("Extras",sub);
        sub:=M.InitMenu(d);
          sub.AddTextItem("Help on item...","a+?",13);
          sub.AddTextItem("Tutorial","",14);
          sub.AddSeparator;
          sub.AddTextItemSC("\ebVO settings...","a+!",settingsId,E.altMask,"!",keyHandler);
          sub.AddSeparator;
          sub.AddTextItemSC("\ebAbout","",aboutId,{},'',keyHandler);
      menu.AddTextSubMenu("Help",sub);
      strip.AddTextStrip("Help",sub);
      menu.Forward(M.selectedMsg,d);
    tab.SetMenuObject(menu);
    tab.SetHelpObject(Q.InitHelp(d,T.MakeLeftText("This is a quick help\nfor this Tabgadget!"),tab));

  top.Add(tab);

  NEW(tool);
  tool.Init;
  tool.SetFlags({G.horizontalFlex});
  tool.SetEqualSize(TRUE);

    NEW(button);
    button.Init;
    button.SetFlags({G.horizontalFlex});
    button.SetType(B.toolBar);
    button.SetImage(NewImage("xpm/new.xpm"));
    button.SetHelpObject(Q.InitHelp(d,T.MakeLeftText("Tooltip"),button));
  tool.Add(button);
    NEW(button);
    button.Init;
    button.SetFlags({G.horizontalFlex});
    button.SetType(B.toolBar);
    button.SetImage(NewImage("xpm/open.xpm"));
    button.SetHelpObject(Q.InitHelp(d,T.MakeLeftText("Tooltip"),button));
  tool.Add(button);
    NEW(button);
    button.Init;
    button.SetFlags({G.horizontalFlex});
    button.SetType(B.toolBar);
    button.SetImage(NewImage("xpm/save.xpm"));
    button.SetHelpObject(Q.InitHelp(d,T.MakeLeftText("Tooltip"),button));
  tool.Add(button);
    NEW(button);
    button.Init;
    button.SetFlags({G.horizontalFlex});
    button.SetType(B.toolBar);
    button.SetImage(NewImage("xpm/help.xpm"));
    button.SetHelpObject(Q.InitHelp(d,T.MakeLeftText("Tooltip"),button));
  tool.Add(button);

  NEW(stl);
  stl.Init;
  stl.SetFlags({G.horizontalFlex});

    NEW(d.status);
    d.status.Init;
    d.status.SetFlags({G.verticalFlex,G.horizontalFlex});
    d.status.SetText("Ok.");
  stl.Add(d.status);

    NEW(stringClock);
    stringClock.Init;
    stringClock.SetFlags({G.verticalFlex});
  stl.Add(stringClock);

  NEW(wGroup);
  wGroup.Init;
  wGroup.Set(strip,top,TRUE);
  wGroup.SetToolbar(tool);
  wGroup.SetStatusLine(stl);

  NEW(w);
  w.Init;
  w.SetDisplay(d);
  w.SetTop(wGroup);
  w.SetTitle("XTest");
  w.AddKeyHandler(keyHandler);
  NEW(msg2Exit);
  msg2Exit.destination:=d;
  w.AddHandler(msg2Exit,W.closeMsg);
  w.Open;
  d.fTimeOut:=d.AddTimeOut(0,100,d);

  d.Handler;

  w.Delete;

(*  dir:=LI.opendir(".");
  IF dir#NIL THEN
    dirEntry:=LI.readdir(dir);
    WHILE dirEntry#NIL DO
      dirName:=LF.GetDirName(dirEntry);
      i:=0;
      WHILE dirName[i]#0X DO
        Err.Char(dirName[i]);
        INC(i);
      END;
      Err.Ln;
      dirEntry:=LI.readdir(dir);
    END;
  ELSE
    Err.String("Cannot open directory");
  END;*)

  d.Deinit;

END XTest.