/*
   File     : guimisc.c
   Author   : Philippe Dax
   Creation : 04/12/98
*/

#include "global.h"
#include "zv.h"		/* RenderClose */
#include "stat.h"	/* statNetwork */
#include "net.h"
#include "world.h"
#include "wobject.h"
#include "ifc.h"
#include "guimisc.h"


/* Local variables */
static int inquit;


/* quit VREng */
void QuitVreng(int i)
{  
  if (inquit) {
    trace(DBG_FORCE, "quit: inquit=%d sig=%d", inquit, i);
    if (inquit > 3)
      exit(i);
    else {
      inquit++;
      exit(i);
    }
  }
  inquit++;

#ifndef VRENGD
  /* Close modules */

  //ifcKillChildren();
  RenderClose();
  quitWMgt();
  statNetwork();
#endif /* !VRENGD */

  /* quit if i!=0 (to eventually call Xerrors) */
  if (i) exit(i);
}

static
void quitSig(int sig)
{
  fprintf(stderr, "Got signal %d, aborting VREng.\n", sig);
  QuitVreng(sig);
}

#ifndef WIN32
static
void reapchild(int sig)
{
  my_wait();
}
#endif /* !WIN32 */

void initSignals(void)
{
#ifndef WIN32
  signal(SIGILL, quitSig);
  signal(SIGTRAP, quitSig);
  signal(SIGFPE, quitSig);
  signal(SIGBUS, quitSig);
  signal(SIGSEGV, quitSig);
  signal(SIGCHLD, reapchild);
#endif /* !WIN32 */
}
