/* ==================================================== ======== ======= *
 *
 *  ubnavig.cc : Ubit Navigator for the VREng GUI
 *
 *  VREng / Ubit Project [Elc::001]
 *  Author: Eric Lecolinet
 *  Date:   7 Nov 01
 *
 *  Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *  Please refer to the Ubit GUI Toolkit Home Page for details.
 *
 *  (C) 1999-2001 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 */

#ifndef VRENGD

#undef MS

#include <ubit.hh>
#include <theme.hh>
#include <unat.hh>

#include "global.h"
#include "net.h"
#include "zv.h"
#include "wobject.h"		/* WObject */
#include "world.h"
#include "keys.h"
#include "move.h"		/* Move */
#include "user.h"		/* FOVY* */

#include "helpers.h"

#include "gui.h"
#include "guiImpl.hh"
#include "widgets.hh"
#include "vnc.h"		// methodes de VNC

const float MOUSE_LINEAR_ACCEL  = 0.055;
const float MOUSE_ANGULAR_ACCEL = 0.0045;

static ObjInfo objinfo[BUTTONSNUMBER + 6];

/* ==================================================== ======== ======= */
/* ==================================================== ======== ======= */

void GuiWidgets::redirectToVnc(class Vnc* _vnc) {
  vnc = _vnc;
}

// Movements
class Mvt {
  int minuskey, pluskey, fun;
  float accel;
public:
  static Mvt xtrans, ytrans, ztrans, zrot;

  Mvt(int minuskey, int pluskey, int fun, float accel);
  void move(int);
  void stop(); // = move(0)
};

Mvt::Mvt(int _minuskey, int _pluskey, int _fun, float _accel) {
  minuskey = _minuskey;
  pluskey  = _pluskey;
  fun      = _fun;
  accel    = _accel;
}

void Mvt::stop() {
  move(0);
}

void Mvt::move(int speed) {
  struct timeval t;
  gettimeofday(&t, NULL);

  if (speed == 0.0) {
    changeKey(pluskey, FALSE, t.tv_sec, t.tv_usec);
    changeKey(minuskey, FALSE, t.tv_sec, t.tv_usec);
  }
  else {
    float new_speed;  //MUST be a float!
    if (accel > 0) new_speed = accel * speed;
    else  new_speed = USER_LSPEED;

    if (minuskey) {

      if (new_speed > 0) {
	specialAction(NULL, fun, &new_speed, t.tv_sec, t.tv_usec);
	changeKey(minuskey, FALSE, t.tv_sec, t.tv_usec);
	changeKey(pluskey, TRUE, t.tv_sec, t.tv_usec);
      }
      else {
	new_speed = -new_speed;
	specialAction(NULL, fun, &new_speed, t.tv_sec, t.tv_usec);
	changeKey(minuskey, TRUE, t.tv_sec, t.tv_usec);
	changeKey(pluskey, FALSE, t.tv_sec, t.tv_usec);
      }
    }
    else {
      specialAction(NULL, fun, &new_speed, t.tv_sec, t.tv_usec);
      changeKey(pluskey, TRUE, t.tv_sec, t.tv_usec);
    }

    //if (new_speed > 0) {

      //}
      //else {
      //new_speed = -new_speed;
      //specialAction(NULL, fun, &new_speed, t.tv_sec, t.tv_usec);
      //changeKey(minuskey, TRUE, t.tv_sec, t.tv_usec);
      //}
  }
}
//forward, backward
Mvt Mvt::ytrans(0/*KEY_AV*/, KEY_AR, USERSETLSPEED, MOUSE_LINEAR_ACCEL);
//turn left, right
Mvt Mvt::zrot(0/*KEY_GA*/, KEY_DR, USERSETASPEED, MOUSE_ANGULAR_ACCEL);
//move left, right
Mvt Mvt::xtrans(0/*KEY_SG*/, KEY_SD, USERSETLSPEED, MOUSE_LINEAR_ACCEL);
//move down, up
Mvt Mvt::ztrans(0/*KEY_JU*/, KEY_JD, USERSETLSPEED, MOUSE_LINEAR_ACCEL);

static Mvt *mvt1 = null, *mvt2 = null;

/* ==================================================== ======== ======= */
/* ==================================================== ======== ======= */
// Primary Callbacks (on glzone)

void GuiWidgets::setMouseRef(UEvent *e) {
  //printf("mref x:%d y%d\n", e->getX(), e->getY());
  button = e->getButtonNumber();
  x_ref = e->getX();
  y_ref = e->getY();
}

void GuiWidgets::mpress(UEvent *e) {
  button = e->getButtonNumber();

  if (vnc) {  //events are redirected to VNC
    vnc->redirectEvent(e->getX(), e->getY(), e->getButtonNumber());
  }
  else {                               // normal behaviour
    struct _ZVSolid *solid =
      GUI::selectPointedObject(e->getX(), e->getY(), objinfo);
    setMouseRef(e);
    //printf("press x:%d y%d\n", e->getX(), e->getY());

    //openedMenu = the menu that is now opened (and that will be refreshed
    //in the main loop after the OGL scene is rendered)

    openedMenu = updateObjectInfo((solid ? objinfo : null), button);
    if (openedMenu) {
      u_dim ww = 0, hh = 0;

      if (openedMenu == navigMenu) {
	// si c'est navigMenu
	// on calcule sa taille pour pouvoir centrer le menu
	//(NB: il faut forcer l'initialisation graphique du menu car
	// il se peut qu'il n'ait pas deja ete affiche donc que 
	// sa taille soit nulle
	UUpdate upd = UUpdate::layout;
	upd.evenIfHidden(true);
	openedMenu->update(upd);
	//printf("ww=%d hh=%d \n", ww, hh);
	openedMenu->getSize(ww, hh);
      }
      // IMPORTANT: il faut afficher le menu dans la glzone, pas dans 
      // la Frame car ce sont des X Windows differentes (a cause d'OGL)
      // et car ce menu est une "softwin" (= directement dessine la
      // ou il est affiche sans utiliser de X Window specifique
      // afin de permetre des effets de transparence)

      openedMenu->move(e, -ww/2, -hh/2);
      openedMenu->open();
    }
  }

  // IFC
  // Calculate the click vector and do the click
  // method on the object if the object has that method
  // defined
  if (button == 1) {
    struct _ZVSolid *solid =
      GUI::selectPointedObject(e->getX(), e->getY(), objinfo);
    V3 dir;
    clickToVector(e->getX(), e->getY(), &dir);
    doClickMethod(solid, dir);
  }
}


void GuiWidgets::mrelease(UEvent *e) {
  //printf("release btn:%d \n", button);
  if (button > 0) {
    //printf("release x:%d y%d\n", e->getX(), e->getY());
    stopMotion(e); //n
  }

  //close the menu when the mouse is released
  if (openedMenu) openedMenu->close();

  button = 0;
  if (vnc) vnc->redirectEvent(e->getX(), e->getY(), button);
}

void GuiWidgets::mdrag(UEvent *e) {
  if (button > 0) {
    //printf("drag x:%d y%d\n", e->getX(), e->getY());
    motion(e);
  }
}

void GuiWidgets::mmove(UEvent *e) {
  if (vnc) {  //events are redirected to VNC
    vnc->redirectEvent(e->getX(), e->getY(), button);
  }
  else if (button == 0) {
    // mode followMouse continuously indicates object under pointer
    if (followMouseMode) {
      struct _ZVSolid *solid =
	GUI::getPointedObject(e->getX(), e->getY(), objinfo);

      // btn = 0 ==> the popup menu is NOT created
      updateObjectInfo((solid ? objinfo : null), 0);
    }
  }
}

/* ==================================================== ======== ======= */
// Secondary Callbacks (when menu is open)

void GuiWidgets::startMotion(UEvent *e, Mvt* m1, Mvt *m2) {
  //printf("startMotion btn:%d \n", button);
  if (mvt1) mvt1->move(0);
  if (mvt2) mvt2->move(0);
  mvt1 = m1;
  mvt2 = m2;

  //le mesu se ferme des l'activation si mouse btn 2
  if (button == 2 && openedMenu) openedMenu->close();
}

//default Mvts
void GuiWidgets::startMotion(UEvent *e) {
  startMotion(e, &Mvt::zrot, &Mvt::ytrans);
}

void GuiWidgets::stopMotion(UEvent *e) {
  setMouseRef(e);
  button = 0;
  if (mvt1) mvt1->move(0);
  if (mvt2) mvt2->move(0);
  mvt1 = null;
  mvt2 = null;
}

void GuiWidgets::motion(UEvent *e) {
  int delta_x = e->getX() - x_ref;
  int delta_y = e->getY() - y_ref;
  if (mvt1) mvt1->move(delta_x);
  if (mvt2) mvt2->move(delta_y);
}

/* ==================================================== ======== ======= */

void GuiWidgets::kpress(UEvent *e) {
  if (vnc) {     // all the events are redirected to VNC
    XEvent* ev = e->getXEvent();
    char keyname[256];
    KeySym ks;
    XLookupString(&ev->xkey, keyname, 256, &ks, NULL);
    vnc->redirectEvent(XKeysymToString(ks), true/*is_down*/);
  }
  else {  // normal behaviour
    // reset speed (NB: ne tient plus compte des controles) !!!!
    struct timeval t;
    gettimeofday(&t, NULL);

    float user_lspeed = USER_LSPEED; //MUST be a float!
    specialAction(NULL, USERSETLSPEED, &user_lspeed, t.tv_sec, t.tv_usec);
    float user_aspeed = USER_ASPEED; //MUST be a float!
    specialAction(NULL, USERSETASPEED, &user_aspeed, t.tv_sec, t.tv_usec);
    gui.processKey(e->getKeySym(), TRUE);
  }
}

void GuiWidgets::krelease(UEvent *e) {
  if (vnc) {     // all the events are redirected to VNC
    XEvent* ev = e->getXEvent();
    char keyname[256];
    KeySym ks;
    XLookupString(&ev->xkey, keyname, 256, &ks, NULL);
    vnc->redirectEvent(XKeysymToString(ks), false/*is_up*/);
  }
  else // normal behaviour
    gui.processKey(e->getKeySym(), FALSE);
}

// ======================================================================
// ======================================================================
// NEW NAVIGATOR 

UBox* GuiWidgets::makeNavigator(int popup_mode) {
  UVmargin  &vm = uvmargin(0);
  UHmargin  &hm = uhmargin(0);
  UVspacing &vs = uvspacing(0);
  UHspacing &hs = uhspacing(0);

  UBgcolor *bg = popup_mode ? &UBgcolor::none : &UBgcolor::black;

  UTrow &row1 = utrow
    (
     vm + hm + vs + hs 
     + utcell(bg + uhcenter() + uvcenter()
	      + UOn::arm / theme.activeBg
	      + "^"
	      // for menubar
	      + UOn::mpress / ucall(this, &GuiWidgets::setMouseRef)
	      + UOn::mdrag  / ucall(this, &GuiWidgets::mdrag)
	      + UOn::mrelease / ucall(this, &GuiWidgets::mrelease)
	      // for all (and after mpress)
	      + UOn::arm / ucall(this, &GuiWidgets::startMotion, 
				 (Mvt*)0, &Mvt::ztrans)
	      )
     + utcell(bg + vm + hm                 //FORWARD
	      + UOn::arm / theme.activeBg
	      + theme.Up
	      + UOn::mpress / ucall(this, &GuiWidgets::setMouseRef)
	      + UOn::mdrag  / ucall(this, &GuiWidgets::mdrag)
	      + UOn::mrelease / ucall(this, &GuiWidgets::mrelease)
	      + UOn::arm   / ucall(this, &GuiWidgets::startMotion)
	      )
     + utcell(bg + uhcenter() + uvcenter()
	      + UOn::arm / theme.activeBg
	      + "m"
	      + (popup_mode ? &UColor::white
		 : (UColor *) &umenu(UOrient::horizontal + ubutton("true") + ubutton("muche")))
	      )
     );

  UTrow &row2 = utrow
    (
     vm + hm + vs + hs 
     + utcell(bg + vm + hm             //LEFT
	      + UOn::arm / theme.activeBg+ UMode::canArm
	      + theme.Left
	      // for menubar
	      + UOn::mpress / ucall(this, &GuiWidgets::setMouseRef)
	      + UOn::mdrag  / ucall(this, &GuiWidgets::mdrag)
	      + UOn::mrelease / ucall(this, &GuiWidgets::mrelease)
	      // for all (and after mpress)
	      + UOn::arm    / ucall(this, &GuiWidgets::startMotion)
	      )
     + utcell(bg + uhcenter() + uvcenter()
	      + " "
	      + UOn::mpress / ucall(this, &GuiWidgets::setMouseRef)
	      + UOn::mdrag  / ucall(this, &GuiWidgets::mdrag)
	      + UOn::mrelease / ucall(this, &GuiWidgets::mrelease)
	     )
     + utcell(bg + vm + hm               //RIGHT
	      + UOn::arm / theme.activeBg + UMode::canArm
	      + theme.Right
	      + UOn::mpress / ucall(this, &GuiWidgets::setMouseRef)
	      + UOn::mdrag  / ucall(this, &GuiWidgets::mdrag)
	      + UOn::mrelease / ucall(this, &GuiWidgets::mrelease)
	      + UOn::arm    / ucall(this, &GuiWidgets::startMotion)
	      )
    );

 UTrow &row3 = utrow
   (
    vm + hm + vs + hs 
    + utcell(bg + uhcenter() + uvcenter()
	     + UOn::arm / theme.activeBg
	     + "<"
	     + UOn::mpress / ucall(this, &GuiWidgets::setMouseRef)
	     + UOn::mdrag  / ucall(this, &GuiWidgets::mdrag)
	     + UOn::mrelease / ucall(this, &GuiWidgets::mrelease)
	     + UOn::arm / ucall(this, &GuiWidgets::startMotion, 
				   &Mvt::xtrans, (Mvt*)0)
	     )
    + utcell(bg + vm + hm        //BACKWARD
	     + UOn::arm / theme.activeBg
	     + theme.Down
	     + UOn::mpress / ucall(this, &GuiWidgets::setMouseRef)
	     + UOn::mdrag  / ucall(this, &GuiWidgets::mdrag)
	     + UOn::mrelease / ucall(this, &GuiWidgets::mrelease)
	     + UOn::arm   / ucall(this, &GuiWidgets::startMotion)
	     )
    + utcell(bg + uhcenter() + uvcenter()
	     + UOn::arm / theme.activeBg
	     + ">"
	     + UOn::mpress / ucall(this, &GuiWidgets::setMouseRef)
	     + UOn::mdrag  / ucall(this, &GuiWidgets::mdrag)
	     + UOn::mrelease / ucall(this, &GuiWidgets::mrelease)
	     + UOn::arm / ucall(this, &GuiWidgets::startMotion, 
				   &Mvt::xtrans, (Mvt*)0)
	     )
    );

 return &utable
   ( 
    vs + hs
    + UBorder::none + UFont::bold
    + UBgcolor::none + UColor::white
    + row1
    + row2
    + row3
    );
}

#endif /* !VRENGD */
