#ifndef HELPERS_H
#define HELPERS_H

#define AUDIO_MASK	0x0000000f
#define VAT_TOOL	0x00000001
#define RAT_TOOL	0x00000002
#define FPHONE_TOOL	0x00000003
#define VIDEO_MASK	0x000000f0
#define VIC_TOOL	0x00000010
#define WHITEBOARD_MASK	0x00000f00
#define WB_TOOL		0x00000100
#define WBD_TOOL	0x00000200
#define NTE_TOOL	0x00000300
#define MB_TOOL		0x00000400
#define BROWSER_MASK	0x0000f000
#define HTML_MASK	0x00003000
#define NETSCAPE_TOOL	0x00001000
#define MMOSAIC_TOOL	0x00002000
#define SLIDECAST_TOOL	0x00004000
#define VRED_TOOL	0x00005000
#define VREM_TOOL	0x00006000
#define VRML_MASK	0x0000c000
#define WEBSPACE_TOOL	0x0000d000
#define VRWEB_TOOL	0x0000e000
#define XTERM_MASK	0x000f0000
#define TELNET_TOOL	0x00010000
#define SSH_TOOL	0x00020000
#define PS_MASK		0x00f00000
#define GV_TOOL		0x00100000
#define GHOSTVIEW_TOOL	0x00200000
#define ACROREAD_TOOL	0x00300000
#define A2PS_TOOL	0x00400000
#define MP3_MASK	0x0f000000
#define MPG123_TOOL	0x01000000
#define XAUDIO_TOOL	0x02000000
#define FREEAMP_TOOL	0x03000000
#define MTVP_TOOL	0x0d000000
#define MPEGPLAY_TOOL	0x0e000000

#define GATESND		whistle
#define DOORCLOSESND	doorclose
#define DOOROPENSND	doorbell
#define DRIPSND		drip
#define SHOOTSND	shoot
#define OUILLESND	ouille
#define BUBBLESSND	bubbles

extern int audiotool;
extern int audioactive;
extern int videotool;
extern int whiteboardtool;
extern int browsertool;
extern int vrmltool;
extern int slidecasttool;
extern int modelertool;
extern int pstool;
extern int pdftool;
extern int mp3tool;
extern int mpgtool;

extern const char *whistle;
extern const char *doorbell;
extern const char *doorclose;
extern const char *drip;
extern const char *shoot;
extern const char *ouille;
extern const char *bubbles;

void quittools(void);
void quitalltools(void);

char * startwget(const char *);
void unlinktmp(char *);

void startaudio(const char *);
void playSound(const char *);
void quitaudio(void);

void startvideo(const char *);
void quitvideo(void);

void startwhiteboard(const char *);
void quitwhiteboard(void);

void startxterm(const char *);
void quitxterm(void);

void startbrowser(const char *);
void quitbrowser(void);
void startvrml(const char *);
void quitvrml(void);
void startslidecast(const char *);
void quitslidecast(void);
void startmodeler(void);
void quitmodeler(void);

void viewps(const char *);
void printps(const char *);
void quitps(void);
void startpdf(const char *);
void quitpdf(void);

void startmp3(const char *);
void stopmp3(void);
void pausemp3(void);
void contmp3(void);
void startmpg(const char *);
void stopmpg(void);
void pausempg(void);
void contmpg(void);


#endif /* HELPERS_H */

