/*
 * Modeler tool
 *
 * Philippe Dax
 * Nov 2000
 */

#ifndef VRENGD

#include "global.h"
#include "browsers.h"
#include "modeler.h"


/* global variable */
int modelertool = VRED_TOOL;
static int modelerpid = -1;


void startmodeler(void)
{
  modelerpid = fork();

#if defined(WIN32) && !defined(CYGWIN32) /* _spawn */
  if (modelertool == VRED_TOOL)
    modelerpid = _spawnlp(_P_NOWAIT, "vred", "vred", (char *) NULL);
  if (modelertool == VREM_TOOL)
    modelerpid = _spawnlp(_P_NOWAIT, "vrem", "vrem", (char *) NULL);
#else /* WIN32 */

  switch (modelerpid) {
  case -1:
    trace(DBG_TOOL, "can't fork for modeler");
    break;
  case 0:
    if (modelertool == VRED_TOOL) {
      execlp("vred", "vred", (char *) NULL);
      trace(DBG_TOOL, "can't exec vred");
    }
    if (modelertool == VREM_TOOL) {
      execlp("vrem", "vrem", (char *) NULL);
      trace(DBG_TOOL, "can't exec vrem");
    }
    exit(1);
  default:
    break;
  }
#endif /* WIN32 */
}

void quitmodeler(void)
{
#ifndef WIN32 /* peut pas killer sous windows */
  if (modelerpid > 0)
    kill(modelerpid, SIGKILL);
#endif /* !WIN32 */
}

#endif /* !VRENGD */
