#include "global.h"
#include "net.h"
#include "dates.h"


/* compute t2-t1 in seconds, right (but negative) if t1>t2 */ 
double diffDates(struct timeval t1, struct timeval t2)
{
  double d = (double) t2.tv_sec - (double) t1.tv_sec;

  d += ((double) t2.tv_usec - (double) t1.tv_usec)*1e-6; 
  /* diffd = d; */	/* see the comment below */
  return d;	/* HERE compiler error generation !!! */
}

/* add d seconds to the date */
void addToDate(struct timeval *t, double d)
{
  double f = floor(d);

  t->tv_sec += (time_t) f;
  t->tv_usec += (time_t) ((d-f)*1e6);
  while (t->tv_usec >= 1000000) {
    t->tv_usec -= 1000000;
    t->tv_sec++;
  }
}

/* compute a new date for the assume_at of the property
 * and set the last_seen at "now" 
 */
void resetDates(NetProperty *pprop)
{
  struct timeval now;

  gettimeofday(&now, NULL);
  pprop->last_seen = now;
  pprop->assume_at = now;
  addToDate(&pprop->assume_at, MIN_ASSUME_DELAY 
	    + rand()/(RAND_MAX+1.0)*(MAX_ASSUME_DELAY-MIN_ASSUME_DELAY));
}

