#ifndef PAYLOAD_H
#define PAYLOAD_H


#define PAYLOAD_LEN 496	/* max size of datas (last =468, orig = 237) */

typedef struct _Payload {
  /* private */
  u_int16 len;
  u_int16 idx;
  u_int8 data[PAYLOAD_LEN];
} Payload;


int isValidPayload(const Payload *);		/* fast test */
Payload * resetPayload(Payload *);		/* to call before using  */
Payload * rewindPayload(Payload *);		/* begin of payload */
Payload * dumpPayload(FILE *, Payload *);	/* dump payload */
int putPayload(Payload *, const char *format,...);	/* sprintf style */
int getPayload(Payload *, const char *format,...);	/* sscanf style */
void seekPayload(Payload *, u_int16);		/* seek pos */
u_int16 tellPayload(Payload *);			/* tell pos */
int tellStrInPayload(Payload *, const char *);	/* seek string */


#endif /* PAYLOAD_H */
