#ifndef CINEMA_H
#define CINEMA_H

#define CINEMA_TYPE	36
#define CINEMA_NAME	"Cinema"
#define	CINEMA_INIT	cinemaInitFuncList


#if HAVE_LIBMPEG
/*
 * Warning! there is a typedef conflict with Boolean type
 * between mpeg.h and X11/Intrinsic.h
 */
#define Boolean Fuck_Boolean_X11
#include <mpeg.h>
#endif

#define CINEMA_INACTIVE	0	// To indicate
#define CINEMA_PLAYING	1	// the screen
#define CINEMA_PAUSE	2	// status
#define CINEMA_LOOP	16	// Loop or stop at end of film

#define CINEMA_FPS	10	// max number of frames decoded per rendering
#define CINEMA_FULL     0	// modify this value then recompile if you
				//  dont want your image to be resized to
                                //  fill the screen
class Cinema: public WObject {
public:
  u_int8 status;		// status
  u_int8 first;			// first frame
  u_int8 fps;			// frame per sec
  u_int8 pad;			// padding not used
  int texture;			// texture number
  int imagewidth;		// mpeg width in pixels
  int imageheight;		// mpeg height in pixels
  int screensize;		// screen width/height in pixels
  int frame;			// the current frame being displayed
  float rate;			// pic frames per seconds
  char *tmpmpeg;		// name of the mpeg file in cache
  FILE *fpmpeg;			// the corresponding file pointer
  struct timeval start;		// video starting time
  GLubyte *screen;		// pixmap of the screen
  u_int8 *pixels;		// pixmap of the video
#if HAVE_LIBMPEG
  ImageDesc img;		// this is a structure used by mpeg_lib to
				// store infos, see mpeg_lib for more info
#endif

  static const WClass wclass;	// class variable
  virtual const WClass* getWClass() {return &wclass;};  //virtual inst. method

  Cinema(char *);		// construtor

  static void (creator)(char *);
  virtual void changePermanent(float lasting);
  virtual void whenIntersect(WObject *pcur, WObject *pold);
  virtual void quit();

#if 0 //TODO
  virtual void play(void *data, time_t s, time_t us);
  virtual void stop(void *data, time_t s, time_t us);
  virtual void pause(void *data, time_t s, time_t us);
  virtual void rewind(void *data, time_t s, time_t us);
  virtual void loop(void *data, time_t s, time_t us);
#endif
private:
  int mpegInit();
};

void CINEMA_INIT(void);

#endif /* CINEMA_H */

