#include "global.h"
#include "net.h"
#include "wobject.h"
#include "wmgt.h"
#include "list.h"	/* deleteObjectFromList */
#include "grid.h"	/* updateObjectIntoGrid */

#include "gui.h"	/* selectedObjectDeletion */
#include "zv.h"		/* deleteSolidFromList */
#include "payload.h"	/* putPayload */

#include "user.h"
#include "ball.h"	// temp
#include "dart.h"	// temp
#include "bullet.h"	// temp


FuncList getFuncList, setFuncList;


void updateReplica(WObject *po, const Pos &oldpos)
{
#ifndef VRENGD
  updateObjectIn3D(po);
  updateBB(po);
  updateObjectIntoGrid(po, oldpos);
#endif /* !VRENGD */
}

/* Functions set definitions */
void set_xy(WObject *po, Payload *pp)
{
  if (!po) {
    trace(DBG_FORCE, "set_xy: po NULL");
    return;
  }
  Pos oldpos = po->pos;

  getPayload(pp, "ff", &(po->pos.x), &(po->pos.y));
  updateReplica(po, oldpos);
  trace(DBG_WMGT, "set_xy: obj=%d %.2f %.2f", po->noh.type, po->pos.x, po->pos.y);
}

void set_z(WObject *po, Payload *pp)
{
  if (!po) {
    trace(DBG_FORCE, "set_z: po NULL");
    return;
  }
  Pos oldpos = po->pos;

  getPayload(pp, "f", &(po->pos.z));
  updateReplica(po, oldpos);
}

void set_az(WObject *po, Payload *pp)
{
  if (!po) {
    trace(DBG_FORCE, "set_az: po NULL");
    return;
  }
  Pos oldpos = po->pos;

  getPayload(pp, "f", &(po->pos.az));
  updateReplica(po, oldpos);
}

void set_ay(WObject *po, Payload *pp)
{
  if (!po) {
    trace(DBG_FORCE, "set_ay: po NULL");
    return;
  }
  Pos oldpos = po->pos;

  getPayload(pp, "f", &(po->pos.ay));
  updateReplica(po, oldpos);
}

void set_ax(WObject *po, Payload *pp)
{
  if (!po) {
    trace(DBG_FORCE, "set_ax: po NULL");
    return;
  }
  Pos oldpos = po->pos;

  getPayload(pp, "f", &(po->pos.ax));
  updateReplica(po, oldpos);
}

void set_hname(WObject *po, Payload *pp)
{
  if (!po) {
    trace(DBG_FORCE, "set_hname: po NULL");
    return;
  }
  getPayload(pp, "s", po->name.class_name);
  trace(DBG_WMGT, "set_hname: %s", po->name.class_name);
}


/*
 * Get functions Definition
 */
void get_xy(WObject *po, Payload *pp)
{
  if (!po) {
    trace(DBG_FORCE, "get_xy: po NULL");
    return;
  }
  putPayload(pp, "ff", po->pos.x, po->pos.y);
}

void get_z(WObject *po, Payload *pp)
{
  if (!po) {
    trace(DBG_FORCE, "get_z: po NULL");
    return;
  }
  putPayload(pp, "f", po->pos.z);
}

void get_az(WObject *po, Payload *pp)
{
  if (!po) {
    trace(DBG_FORCE, "get_az: po NULL");
    return;
  }
  putPayload(pp, "f", po->pos.az);
}

void get_ay(WObject *po, Payload *pp)
{
  if (!po) {
    trace(DBG_FORCE, "get_ay: po NULL");
    return;
  }
  putPayload(pp, "f", po->pos.ay);
}

void get_ax(WObject *po, Payload *pp)
{
  if (!po) {
    trace(DBG_FORCE, "get_ax: po NULL");
    return;
  }
  putPayload(pp, "f", po->pos.ax);
}

void get_hname(WObject *po, Payload *pp)
{
  if (!po) {
    trace(DBG_FORCE, "get_hname: po NULL");
    return;
  }
  putPayload(pp, "s", po->name.class_name);
  trace(DBG_WMGT, "get_hname: %s", po->name.class_name);
}


/*
 * Permet de modifier la propriete (sa copie locale). La nouvelle
 * valeur se trouve dans payload. Il faut renvoyer la position
 * de lecture de la suite (utiliser getPayload et sa valeur de retour).
 * Cette fonction est typiquement appelee suite a la reception d'un
 * delta sur le reseau.
 */
void setProperty(NetObject *pn, u_int8 prop_id, Payload *pp)
{
  if (!pn) {
    trace(DBG_FORCE, "setProperty: pn NULL");
    return;
  }
  WObject *po = (WObject *) pn;

  if (setFuncList[prop_id][pn->type].pf == NULL) {
    warning("set: property=%d doesn't match the object type=%d",
	     prop_id, pn->type);
    return;
  }
  setFuncList[prop_id][pn->type].pf(po, pp);
}

/*
 * Permet de recuperer la propriete (sa copie locale). Il faut
 * ecrire payload et renvoyer la longueur ecrite 
 * (utiliser putPayload et sa valeur de retour) 
 * Typiquement appelee pour connaitre payload avant d'emettre 
 * un delta.
 */
void getProperty(NetObject *pn, u_int8 prop_id, Payload *pp)
{
  WObject *po = (WObject *) pn;

  if (!pn) {
    trace(DBG_FORCE, "getProperty: pn NULL");
    return;
  }
  if (getFuncList[prop_id][pn->type].pf == NULL) {
    warning("get: prop=%d undefined for object=%d", prop_id, pn->type);
    return;
  }
  getFuncList[prop_id][pn->type].pf(po, pp);
}

void setAllProperties(NetObject *pn, Payload *pp)
{
  if (!pn) {
    trace(DBG_FORCE, "setAllProperties: pn NULL");
    return;
  }
  for (int nprop = 0; nprop < propertiesnumber[pn->type]; nprop++)
    setProperty(pn, nprop, pp);
}

/*
 * Retrieve all properties of one object.
 * The payload is initialized before, and filled here.
 * Called to known the Payload after one declareObjCreation()
 */
void getAllProperties(NetObject *pn, Payload *pp)
{
  if (!pn) {
    trace(DBG_FORCE, "getAllProperties: pn NULL");
    return;
  }
  for (int nprop = 0; nprop < propertiesnumber[pn->type]; nprop++)
    getProperty(pn, nprop, pp);
}

/*
 * Allocate a local copy of the object
 * and initialize all its fields with setProperty()
 * Typically called after an incomingCreate()
 */
struct _NetObject *
replicateObject(u_int8 type_id, struct _NetObjectId noid, struct _Payload *pp)
{
  WObject *po = NULL;

  /* allocate the local replicated copy of the object */
  switch (type_id) {
  case USER_TYPE:
  case BALL_TYPE:
  case DART_TYPE:
  case BULLET_TYPE:
      po = WClass::replicatorInstance(type_id, noid, pp);	// factory
      if (po)
        return &(po->noh);	// OK
      break;
  default:
      trace(DBG_FORCE, "replicateObject: unavailable replica for type=%d", type_id);
  }
  return NULL;	// BAD
}

/*
 * Supprime object du monde, si object n'est pas le local user...
 * La sequence doit inclure un "deleteNetObject" qui est le
 * reciproque d'un newObjectName/createNetObjectFromString.
 * 1) faire le menage et afficher tout ce qui est necessaire.
 * 2) (si la decision a ete prise localement) declareObjDeletion
 * 3) deleteNetObject 
 *    (le nom devient invalide, plus aucun declare n'est possible)
 * 4) faire le delete object final
 */
void requestDeletionFromNetwork(NetObject *pn)
{
#ifndef VRENGD
  if (!pn) {
    trace(DBG_FORCE, "requestDeletionFromNetwork: pn NULL");
    return;
  }
  WObject *po = (WObject *) pn;

  if (po != worlds->plocaluser) {
    if (pn->type == USER_TYPE)
      GuiRemoveUser((User *) po);
    if (po->soh)
      selectedObjectDeletion(po->soh);

    deleteObjectFromGrid(po);
    mobilelist = deleteObjectFromList(po, mobilelist);
    if (po->soh)
      deleteSolidFromList(po->soh);
    po->soh = NULL;
    deleteNetObject(pn);
    delete po;
  }
  else
    notice("You're trying to kill me, but I'm back!");
#endif /* !VRENGD */
}

/*
 * Cette fonction renvoie le nombre total de proprietes du type.
 * Elles doivent etre numerotees de 0 a properties_count-1.
 * Cette fonction utilise par exemple un simple tableau constant.
 * Typiquement appelee sur reception d'un C, apres appel a
 * create_object, pour savoir le nombre de set_property a faire.
 */
u_int8 countProperties(u_int8 type_id)
{
  return propertiesnumber[type_id];
}

