/*******************************************************/
/*                      VNC Object                     */
/*-----------------------------------------------------*/
/*                                                     */
/*  Thanks to that object, you can launch a VNC viewer */
/* into a VReng world. So, you must have a VNC server  */
/* running on a machine (locally or remotely).         */
/*                                                     */
/*  The syntax to add an object into a vre file is :   */
/*    [vnc]                                            */
/*    (name) pos [server] geomparam                    */
/*  where                                              */
/*    pos <- x y z az ax                               */
/*    server <- server=servername,port,password        */
/*    geomparam <- cf VReng specs (e.g. size=sx,sy,sz) */
/*                                                     */
/*                    -------------                    */
/*                                                     */
/*  If a server was entered in the vre file, the       */
/* server is connected...                              */
/*                                                     */

#ifndef VNC_H
#define VNC_H

#define VNC_TYPE	41
#define VNC_NAME	"Vnc"
#define	VNC_INIT	vncInitFuncList

#include "vnc/vncclient.h"

class Vnc : public WObject {
public:
  // Geometry data
  GLdouble vertices[10*3];

  // Texture data
  GLuint texture_num;
  int texture_width;
  int texture_height;
  GLubyte *texture_bytes;
  float u,v;
  GLuint desktoplist;

  GLfloat color[3];

  /* Coordinates projection data */
  GLint viewport[4];
  GLdouble modelMatrix[16];
  GLdouble projMatrix[16];

  // Server connection data
  bool isConnected;
  bool isServerDefined;
  char serverName[40];
  int port;
  char passwdFile[40];

  VNCClientTextured* vncClient;
  fd_set  rmask;
  struct  timeval delay; 

public:
  static const WClass wclass;   // class variable
  virtual const WClass* getWClass() {return &wclass;};  //virtual inst. method

  Vnc(char *l); // Constructor
  //PD ~Vnc(); // Destructor

  static void (creator)(char *l);

  // Called each frame - check if ths texture has to be updated
  virtual void changePermanent(float lasting);

  // Render the object
  virtual void render();

  // Called when the object is destroy
  virtual void quit();

  // Build a default texture
  void defaultTexture();

  // Convert VReng screen coordinates to VNC screen coordinates
  void getVncCoords(int &x,int &y);

  // Create object vertices adapted to current texture
  void createVertices();

  // Redirect Events to VNC Server
  boolean redirectEvent(int x, int y, int button);
  boolean redirectEvent(const char *touche, boolean is_down);

  //dialog box
  void vncConnect(Vnc *po);
  void vncConvert(const char *server, const char *port, const char *passwd);
};

void VNC_INIT(void);


#endif /* VNC_H */

