#ifndef VRENGD

#include <GL/gl.h>

#include "global.h"
#include "net.h"
#include "wobject.h"
#include "wmgt.h"
#include "list.h"
#include "parse.h"
#include "walls.h"

#include "texture.h"
#include "md2.h"


const WClass Walls::wclass(WALLS_TYPE, "Backwalls", Walls::creator);

static Walls *firstwall = NULL;


static
void readWalls(void *va, void *handle)
{
  Walls *po = NULL, *prev = NULL;
  float xs, xe, ys, ye, zs, ze, r, g, b;
  char line[BUFSIZ];

  httpClearBuf();

  while (1) {
    httpGetLine(handle, line);
    
    if (line[0] == '#')
      continue;
    if (sscanf(line, "%f %f %f %f %f %f  %f %f %f",
	             &xs, &xe, &ys, &ye, &zs, &ze, &r, &g, &b) <= 0) {
      break;	/* EOF */
    }
    po = new Walls(xs, xe, ys, ye, zs, ze, r, g, b);
    if (prev == NULL)
      firstwall = po;
    else
      prev->next = po;
    prev = po;
  }
  po->next = NULL;
}

Walls::Walls(float sx, float ex, float sy, float ey, float sz, float ez, float red, float green, float blue)
{
  xs = sx;
  xe = ex;
  ys = sy;
  ye = ey;
  zs = sz;
  ze = ez;
  r  = red;
  g  = green;
  b  = blue;
}

static
float cmpnorm(V3 *a, V3 *b)
{
  float Rx = a->v[0] - b->v[0];
  float Ry = a->v[1] - b->v[1];
  float Rz = a->v[2] - b->v[2];

  return Rx*Rx + Ry*Ry + Rz*Rz;
}

static
float scalarprod(float ax, float ay, float bx, float by)
{
  return ax*bx + ay*by;
}

int wallsIntersectObject(V3 *wallscenter, V3 *wallssize, V3 *wallsnorm)
{
  Walls *walls = firstwall;
  float oxmax, oxmin, oymax, oymin, ozmax, ozmin;
  V3 cur_wallsnorm;
  int first = 1;
  
  oxmin = wallscenter->v[0] - wallssize->v[0];
  oxmax = wallscenter->v[0] + wallssize->v[0];
  oymin = wallscenter->v[1] - wallssize->v[1];
  oymax = wallscenter->v[1] + wallssize->v[1];
  ozmin = wallscenter->v[2] - wallssize->v[2];
  ozmax = wallscenter->v[2] + wallssize->v[2];

  /* Now, we test the collision with all the walls */
  while (walls != NULL) {
    float wxmin = walls->xs < walls->xe ? walls->xs : walls->xe;
    float wxmax = walls->xs > walls->xe ? walls->xs : walls->xe;
    float wymin = walls->ys < walls->ye ? walls->ys : walls->ye;
    float wymax = walls->ys > walls->ye ? walls->ys : walls->ye;
    float wzmin = walls->zs < walls->ze ? walls->zs : walls->ze;
    float wzmax = walls->zs > walls->ze ? walls->zs : walls->ze;

    if ((((oxmin < wxmin) && (oxmax > wxmax)) ||
	 ((oxmin > wxmin) && (oxmax < wxmax)) ||
	 ((oxmax > wxmin) && (oxmax < wxmax)) ||
	 ((oxmin > wxmin) && (oxmin < wxmax)))
	&&
	(((oymin < wymin) && (oymax > wymax)) ||
	 ((oymin > wymin) && (oymax < wymax)) ||
	 ((oymax > wymin) && (oymax < wymax)) ||
	 ((oymin > wymin) && (oymin < wymax)))
	&&
	(((ozmin < wzmin) && (ozmax > wzmax)) ||
	 ((ozmin > wzmin) && (ozmax < wzmax)) ||
	 ((ozmax > wzmin) && (ozmax < wzmax)) ||
	 ((ozmin > wzmin) && (ozmin < wzmax)))) {
      cur_wallsnorm.v[2] = 0.0;
      if (wxmin == wxmax) {
	cur_wallsnorm.v[0] = 1.0;
	cur_wallsnorm.v[1] = 0.0;
      } else {
	cur_wallsnorm.v[1] = 1.0;
	cur_wallsnorm.v[0] = 0.0;
      }

      /* Test which normal we take.... */
      if (scalarprod(wallscenter->v[0] - wxmin, wallscenter->v[1] - wymin,
		      cur_wallsnorm.v[0], cur_wallsnorm.v[1]) < 0.0) {
	cur_wallsnorm.v[0] = -cur_wallsnorm.v[0];
	cur_wallsnorm.v[1] = -cur_wallsnorm.v[1];
      }
      if (first) {
	*wallsnorm = cur_wallsnorm;
	first = 0;
      } else {
	if (cmpnorm(&cur_wallsnorm, wallsnorm) > 0.01)
	  return 2;
      }
    }
    walls = walls->next;
  }
  if (first)
    return 0; /* No collisions */
  else
    return 1;
}

void loadWalls(char *url)
{
  httpOpen(url, readWalls, NULL, THREAD_NO_BLOCK);
} 

void Walls::creator(char *l)
{
  new Walls(l);
}

Walls::Walls(char *l)
{
  parseURL(l, this);

  nature.bbable = VR_NO_BB;
  nature.selectable = VR_NO_SELECTABLE;
  nature.renderable = VR_SPECIAL_RENDER;

  initializeObject(this, WALLS_TYPE, VR_STILL);

  loadWalls(name.url);
}

void Walls::render()
{
  glDisable(GL_LIGHTING);	/* No lighting on walls */
  glDisable(GL_CULL_FACE);	/* A wall = one facet => no culling */
  
  Walls *walls;
  for (walls = firstwall; walls != NULL; walls = walls->next) {
    glColor3f(walls->r, walls->g, walls->b);
    glBegin(GL_QUADS); {
      glVertex3f(walls->xs, walls->ys, walls->zs);
      glVertex3f(walls->xs, walls->ys, walls->ze);
      glVertex3f(walls->xe, walls->ye, walls->ze);
      glVertex3f(walls->xe, walls->ye, walls->zs);
    } glEnd();
  }
  glEnable(GL_LIGHTING);
}

/* freeing the list allocated in readWalls callback (via httpOpen) */
void Walls::quit()
{
  while (firstwall) {
    Walls *walls = firstwall->next;

    delete firstwall;
    firstwall = walls;
  }
}

void wallsInitFuncList(void) { }

#endif /* !VRENGD */
