#ifndef WORLD_H
#define WORLD_H


struct User;
struct WObject;

typedef struct _Universe {
  char name[WORLD_LEN];
  char urlinitial[URL_LEN];
  char worldinitial[WORLD_LEN];
  char groupinitial[GROUP_LEN];
  u_int16 portinitial;
  u_int8 ttlorigin;
  u_int8 prop;
  struct _Universe *next;
} Universe;

typedef struct _World {
  char name[WORLD_LEN];
  char chan[CHAN_LEN];
  char url[URL_LEN];
  u_int16 id;
  u_int8 type;
  u_int8 prop;
  User *plocaluser;
  void *ptrgui;
  struct _World *next;
} World;

extern Universe universe;
extern World *worlds;
extern World manager;


World * allocWorld(void);
World * backWorld(void);
World * forwardWorld(void);
boolean isValidType(int);
void setLocalWorldName(const char *);

World * getCurrentWorld(void);
const char * getCurrentWorldName(void);
void setCurrentChannelName(const char *);
void setChannelName(const char *);
void setManagerChannelName(const char *);
const char * getCurrentChannelName(void);
const char * getManagerChannelName(void);

/* close a world */
void quitWorld(void);

/* general initialization of a world */
void newWorld(const char *url, const char *chanstr, boolean);

/* general initialization of Wmgt module */
void initWMgt(const char *, const char *, const char *, const char *);

/* close Wmgt module */
void quitWMgt(void);

/* signals a key has changed */
void changeKey(int key_id, int etat, long, long);

/* signals a message sent by an user */
void userWriting(const char *);

struct _ZVSolid;
/* call methods dedicated to each object */
void specialAction(struct _ZVSolid *, int, void *, time_t, time_t);

/* give object's class_name & methods names */
void getObjectHumanName(struct _ZVSolid *, char **, char **, char **);

/* give object's all names */
void getObjectAllNames(struct _ZVSolid *, char **, char **, char **, char **);

/* compute the world */
void doWorldCalculation(long, long);

void specialRendering(void);

#include "zmath.h"
int doClickMethod(struct _ZVSolid *, V3);

struct _NetObject;
struct _NetObjectId;
struct _Payload;

/* Permet de modifier la propriete (sa copie locale). La nouvelle
 * valeur se trouve dans text. Il faut renvoyer la position
 * de lecture de la suite (utiliser scanPayload et sa valeur de retour).
 * Cette fonction est typiquement appelee suite a la reception d'un
 * delta sur le reseau.
 */
void setProperty(struct _NetObject *, u_int8, struct _Payload *);

/* Permet de recuperer la propriete (sa copie locale). Il faut
 * ecrire text et renvoyer la longueur ecrite 
 * (utiliser make_text et sa valeur de retour) 
 * Typiquement appelee pour connaitre text avant d'emettre 
 * un delta.
 */
void getProperty(struct _NetObject *, u_int8, struct _Payload *);

/* Permet de recuperer toutes les proprietes d'un objet. Le text est
 * initialise avant l'appel, et rempli dans la procedure.
 * Typiquement appelee pour connaitre text apres emission
 * d'un declareCreationToNetwork.
 */
void getAllProperties(struct _NetObject *, struct _Payload *);

/* Alloue une copie locale pour l'objet, avec initialisation et
 * attribution de tous les champs grace a des setProperty.
 * Typiquement appelee suite a la reception d'un C.
 */
struct _NetObject *replicateObject(u_int8, struct _NetObjectId, struct _Payload *);

/* Supprime object du monde.  */
void requestDeletionFromNetwork(struct _NetObject *);

/* Cette fonction renvoie le nombre total de proprietes du type.
 * Elles doivent etre numerotees de 0 a properties_count-1.
 * Cette fonction utilise par exemple un simple tableau constant.
 * Typiquement appelee sur reception d'un C, apres appel a
 * createReplica, pour savoir le nombre de set_property a faire.
 */
u_int8 countProperties(u_int8);


#endif /* WORLD_H */
