
  // ------------------------------------------------------------------------ //
  // Author               : This file has been written by                     //
  //                            Yann Renard (MyselF / Dim4)                   //
  // Copyright            : This file is totaly free and you may distribute   //
  //                        it to anyone you want, without modifying this     //
  //                        header. If you use it in a commercial project (?) //
  //                        or in bigger project (!), I would be glad to know //
  //                        about it :) Please mail me...                     //
  //                        be glad to know about it, please mail me          //
  // Contact              : You can contact me at                             //
  //                            renard@esiea-ouest.fr                         //
  //                            myself_yr@hotmail.com                         //
  // Bug reports          : Mail me please so I can know about it             //
  // Purpose of this file : This package is my first experiment in bones      //
  //                        programming. I feel it works great for a first    //
  //                        time. For sure their are lots of optim to do...   //
  //                        Your ideas are welcome :)                         //
  // Version              : 1.0                                               //
  // History              : none                                              //
  // ToDo                 : lot's of things :)                                //
  //                        other things :))))                                //
  //                        Maybe buid an HTML tutorial about this subject ?  //
  // Greets               : Dim4 members :)                                   //
  //                        Latex, teacher forever                            //
  //                        Ethereal, thx for ideas of implementation         //
  //                        #codefr, thx for url                              //
  //                        comp.graphics.algorithm && comp.graphics.opengl   //
  //                        pech' and yoyo... newbies in demo hey !           //
  // ------------------------------------------------------------------------ //

#include <GL/gl.h>

#include "global.h"
#include "boneVert.h"
#include "boneLink.h"

  // Construct / Destruct
  BONEVERTEX :: BONEVERTEX ( void )
   {
    initialPosition.setValue(0.0f,0.0f,0.0f);
    initialAngle    = 0.0f;
    initialAxis.    setValue(0.0f,1.0f,0.0f);

    currentPosition.setValue(0.0f,0.0f,0.0f);
    currentAngle    = 0.0f;
    currentAxis.    setValue(0.0f,1.0f,0.0f);

    child    = NULL;
    father   = NULL;
    children = 0;
    childListCompiled = 0;

    link     = NULL;
    links    = 0;
    linkListCompiled = 0;

    influenceScaleFactor = 1.0f;
    animated = 0;
   }

  BONEVERTEX :: BONEVERTEX ( VECT3D & zePosition, float zeAngle, VECT3D & zeAxis )
   {
    initialPosition = zePosition;
    initialAngle    = zeAngle;
    initialAxis     = zeAxis;

    currentPosition = zePosition;
    currentAngle    = zeAngle;
    currentAxis     = zeAxis;

    child    = NULL;
    father   = NULL;
    children = 0;
    childListCompiled = 0;

    link     = NULL;
    links    = 0;
    linkListCompiled = 0;
    animated = 0;
   }

  BONEVERTEX :: BONEVERTEX ( VECT3D * zePosition, float zeAngle, VECT3D * zeAxis )
   {
    initialPosition = *zePosition;
    initialAngle    =  zeAngle;
    initialAxis     = *zeAxis;

    currentPosition = *zePosition;
    currentAngle    =  zeAngle;
    currentAxis     = *zeAxis;

    child    = NULL;
    father   = NULL;
    children = 0;
    childListCompiled = 0;

    link     = NULL;
    links    = 0;
    linkListCompiled = 0;
    animated = 0;
   }

  BONEVERTEX :: ~BONEVERTEX ( void )
   {
    int i;
    // first delete all the children
    if ( ! childListCompiled ) compileChildList ();
    for (i=0; i<children; i++) delete child[i];
    childList.empty ( );

    // Now, delete the selected links for this node
    if ( ! linkListCompiled ) compileLinkList ();
    for (i=0; i<links; i++) delete link[i];
    linkList.empty ( );
   }

  // Accessing initial position datas
  void BONEVERTEX :: setInitialPosition ( VECT3D & zePosition )
   {
    initialPosition =  zePosition;
    currentPosition =  zePosition;
   }

  void BONEVERTEX :: setInitialPosition ( VECT3D * zePosition )
   {
    initialPosition = *zePosition;
    currentPosition = *zePosition;
   }

  void BONEVERTEX :: setInitialPosition ( float ox, float oy, float oz )
   {
    initialPosition = VECT3D ( ox, oy, oz );
    currentPosition = VECT3D ( ox, oy, oz );
   }

  void BONEVERTEX :: setInitialRotation ( float zeAngle, VECT3D & zeAxis )
   {
    initialAngle    =  zeAngle;
    initialAxis     =  zeAxis;
    currentAngle    =  zeAngle;
    currentAxis     =  zeAxis;
   }

  void BONEVERTEX :: setInitialRotation ( float zeAngle, VECT3D * zeAxis )
   {
    initialAngle    =  zeAngle;
    initialAxis     = *zeAxis;
    currentAngle    =  zeAngle;
    currentAxis     = *zeAxis;
   }

  void BONEVERTEX :: setInitialRotation ( float zeAngle, float axisx, float axisy, float axisz )
   {
    initialAngle    =  zeAngle;
    initialAxis     =  VECT3D ( axisx, axisy, axisz );
    currentAngle    =  zeAngle;
    currentAxis     =  VECT3D ( axisx, axisy, axisz );
   }

  // And... Accessing animation position datas
  void BONEVERTEX :: setCurrentPosition ( VECT3D & zePosition )
   {
    currentPosition =  zePosition;
   }

  void BONEVERTEX :: setCurrentPosition ( VECT3D * zePosition )
   {
    currentPosition = *zePosition;
   }

  void BONEVERTEX :: setCurrentPosition ( float ox, float oy, float oz )
   {
    currentPosition =  VECT3D ( ox, oy, oz );
   }

  void BONEVERTEX :: setCurrentRotation ( float zeAngle, VECT3D & zeAxis )
   {
    currentAngle    =  zeAngle;
    currentAxis     =  zeAxis;
   }

  void BONEVERTEX :: setCurrentRotation ( float zeAngle, VECT3D * zeAxis )
   {
    currentAngle    =  zeAngle;
    currentAxis     = *zeAxis;
   }

  void BONEVERTEX :: setCurrentRotation ( float zeAngle, float axisx, float axisy, float axisz )
   {
    currentAngle    =  zeAngle;
    currentAxis     =  VECT3D ( axisx, axisy, axisz );
   }

  // Accessing current position datas ( during animation )
  // with relative values (realtive to initial position )
  void BONEVERTEX :: resetCurrentPosition ( void )
   {
    currentPosition = initialPosition;
   }

  void BONEVERTEX :: resetCurrentRotation ( void )
   {
    currentAngle = initialAngle;
    currentAxis  = initialAxis;
   }

  void BONEVERTEX :: translateCurrentPosition ( VECT3D & delta )
   {
    currentPosition = currentPosition + delta;
   }

  void BONEVERTEX :: translateCurrentPosition ( VECT3D * delta )
   {
    currentPosition = currentPosition + * delta;
   }

  void BONEVERTEX :: translateCurrentPosition ( float dx, float dy, float dz )
   {
    currentPosition.x += dx;
    currentPosition.y += dy;
    currentPosition.z += dz;
   }

  void BONEVERTEX :: scaleCurrentPosition ( float scalex, float scaley, float scalez )
   {
    currentPosition.x *= scalex;
    currentPosition.y *= scaley;
    currentPosition.z *= scalez;
   }

  void BONEVERTEX :: scaleCurrentPosition ( float scale )
   {
    currentPosition = currentPosition * scale;
   }

  // Modifying the node and its children (definitive)
  void BONEVERTEX :: scale ( float sx, float sy, float sz )
   {
    if ( ! childListCompiled ) compileChildList ();

    initialPosition.x *= sx;
    initialPosition.y *= sy;
    initialPosition.z *= sz;
    currentPosition.x *= sx;
    currentPosition.y *= sy;
    currentPosition.z *= sz;

    for (int i=0; i<children; i++)
      child[i] -> scale ( sx, sy, sz );
   }

  // Updating the father of this boneVertex
  void BONEVERTEX :: setFather ( BONEVERTEX * zeFather )
   {
    father = zeFather;
   }

  // Adding children
  void BONEVERTEX :: addChild  ( BONEVERTEX * newChild )
   {
    childList.addElement ( newChild );
    newChild -> setFather ( this );
    childListCompiled = 0;
   }

  // Removing a child and its children
  void BONEVERTEX :: removeChild ( char * zeName )
   {
    BONEVERTEX * temp = findChild ( zeName );
    if ( temp == NULL ) return;
    if ( temp == this ) return;

    childList.removeElement ( temp );
    childListCompiled = 0;

    delete temp;
   }

  // Finding a boneVertex in the tree using its name
  BONEVERTEX * BONEVERTEX :: findChild ( char * zeName )
   {
    BONEVERTEX * result = NULL;

    if ( ! childListCompiled ) compileChildList ();

    if ( strcmp(zeName, getName()) == 0 )
      result = this;
    else
     {
      int i=0;
      while (( result == NULL ) && (i < children))
        result = child[i++]->findChild ( zeName );
     }

    return result; 
   }

  // Adding a link
  void BONEVERTEX :: addLink ( LINK * zeLink )
   {
    linkList.addElement ( zeLink );
    linkListCompiled = 0;
   }

  // Removing a link
  void BONEVERTEX :: removeLink ( LINK * zeLink )
   {
    linkList.removeElement ( zeLink );
    linkListCompiled = 0;
   }

  // Compiling the lists
  void BONEVERTEX :: compileChildList ( void )
   {
    child = childList.getNiceTable ( & children );
    childListCompiled = 1;
   }

  void BONEVERTEX :: compileLinkList ( void )
   {
    link = linkList.getNiceTable ( & links );
    linkListCompiled = 1;
   }

  // Generating the initial matrix for this node
  void BONEVERTEX :: generateInitialMatrix ( void )
   {
    int i,j;

    // First, we'll need to know all the childs
    if ( ! childListCompiled ) compileChildList ();

    glPushMatrix ();

    // Now I let OpenGL calculate the matrix
    glTranslatef  ( initialPosition.x, initialPosition.y, initialPosition.z);
    glRotatef     ( initialAngle, initialAxis.x , initialAxis.y, initialAxis.z );
    // I save it
    glGetFloatv   ( GL_MODELVIEW_MATRIX, initialMatrix );

    // Here is a nice matrix inversion
    // 1. temp gets the transposed rotation part of the matrix
    float temp [16];
    temp[ 0] = initialMatrix[ 0]; temp[ 4] = initialMatrix[ 1]; temp[ 8] = initialMatrix[ 2]; temp[12] = 0;
    temp[ 1] = initialMatrix[ 4]; temp[ 5] = initialMatrix[ 5]; temp[ 9] = initialMatrix[ 6]; temp[13] = 0;
    temp[ 2] = initialMatrix[ 8]; temp[ 6] = initialMatrix[ 9]; temp[10] = initialMatrix[10]; temp[14] = 0;
    temp[ 3] = 0;                 temp[ 7] = 0;                 temp[11] = 0;                 temp[15] = 1;
    // 2. tempVect gets an inverted translation from the matrix
    VECT3D tempVect( - initialMatrix[12], - initialMatrix[13], - initialMatrix[14]);
    // 3. tempVect is to be done in the inverted coordinate system so multiply
    tempVect = temp * tempVect;
    // 4. now we have the nice inverted matrix :)
    temp[12] = tempVect.x;
    temp[13] = tempVect.y;
    temp[14] = tempVect.z;
    // 5. Stores it !
    for (j=0;j<16; j++) initialMatrixInverted[j] = temp[j];

    // Now, store the rotation matrices ( for normals computation )
    int off=0;
    for (i=0; i<4; i++)
     for (j=0; j<4; j++, off++)
      if ((i<3) && (j<3))
       {
	initialRotMatrix        [off] = initialMatrix        [off];
	initialRotMatrixInverted[off] = initialMatrixInverted[off];
       }
      else if (i==j)
       {
	initialRotMatrix        [off] = 1.0f;
	initialRotMatrixInverted[off] = 1.0f;
       }
      else
       {
	initialRotMatrix        [off] = 0.0f;
	initialRotMatrixInverted[off] = 0.0f;
       }

    // If you don't believe me, test to see if inverted matrix is correctly built
    // VECT3D unit(1,1,1);
    // unit = initialMatrix * unit;
    // printf("Unit b4 : %f %f %f\n", unit.x, unit.y, unit.z );
    // unit = initialMatrixInverted * unit;
    // printf("Unit    : %f %f %f\n", unit.x, unit.y, unit.z );

    // Now, let's do the same for children :)
    for (i=0; i<children; i++)
      child[i]->generateInitialMatrix ();

    glPopMatrix ();
   }

  // Now let's have a look to the current matrix, same code as above
  // but no dirty invert :)
  void BONEVERTEX :: generateCurrentMatrix ( void )
   {
    if ( ! childListCompiled ) compileChildList ();

    glPushMatrix ();

    glTranslatef  ( currentPosition.x, currentPosition.y, currentPosition.z);
    glRotatef     ( currentAngle, currentAxis.x , currentAxis.y, currentAxis.z );
    glGetFloatv   ( GL_MODELVIEW_MATRIX, currentMatrix );

    // Now we have the current transformation matrix,
    // we'll extract the rotation part so we can
    // move the normals of the mesh correctly to
    // update the lighting !
    currentRotMatrix[ 0] = currentMatrix[ 0];
    currentRotMatrix[ 1] = currentMatrix[ 1];
    currentRotMatrix[ 2] = currentMatrix[ 2];
    currentRotMatrix[ 3] = 0.0f;

    currentRotMatrix[ 4] = currentMatrix[ 4];
    currentRotMatrix[ 5] = currentMatrix[ 5];
    currentRotMatrix[ 6] = currentMatrix[ 6];
    currentRotMatrix[ 7] = 0.0f;

    currentRotMatrix[ 8] = currentMatrix[ 8];
    currentRotMatrix[ 9] = currentMatrix[ 9];
    currentRotMatrix[10] = currentMatrix[10];
    currentRotMatrix[11] = 0.0f;

    currentRotMatrix[12] = 0.0f;
    currentRotMatrix[13] = 0.0f;
    currentRotMatrix[14] = 0.0f;
    currentRotMatrix[15] = 1.0f;

    // And now, just generate the childrem matrices
    for (int i=0; i<children; i++)
      child[i]->generateCurrentMatrix ();

    glPopMatrix ();
   }

  // I/O functions
  void BONEVERTEX :: read ( char * filename, float scale )
   {
    FILE * file = (FILE *) fopen ( filename , "rb" );
    if ( file == NULL )
     {
      printf ( "BONEVERTEX :: read\n" );
      printf ("   Unable to open : [%s] for read\n" , filename );
      return;
     }

    readFromFile ( file, scale );

    fclose ( file );
   }

  void BONEVERTEX :: write ( char * filename )
   {
    FILE * file = (FILE *) fopen ( filename , "wb" );
    if ( file == NULL )
     {
      printf ( "BONEVERTEX :: write\n" );
      printf ("   Unable to open : [%s] for write\n" , filename );
      return;
     }

    writeToFile ( file );

    fclose ( file );
   }

  void BONEVERTEX :: readFromFile ( FILE * file, float scale )
   {
    char nameCurrent[512];
    float posx, posy, posz;
    float angle;
    float axisx, axisy, axisz;

    readString ( file, nameCurrent );

    posx = readFloat ( file ) * scale;
    posy = readFloat ( file ) * scale;
    posz = readFloat ( file ) * scale;

    angle = readFloat ( file );

    axisx = readFloat ( file );
    axisy = readFloat ( file );
    axisz = readFloat ( file );

    setName ( nameCurrent );
    setInitialPosition ( posx, posy, posz );
    setInitialRotation ( angle, axisx, axisy, axisz );

    int cpt = readInt ( file ); // Number of children
    for (int i=0; i<cpt; i++)
     {
      BONEVERTEX * temp = new BONEVERTEX ();
      addChild ( temp );
      temp -> readFromFile ( file );
     }

    compileChildList ();
   }

  void BONEVERTEX :: writeToFile ( FILE * file )
   {
    if ( ! childListCompiled ) compileChildList ();

    writeString ( file, getName () );

    float posx, posy, posz;
    float angle;
    float axisx, axisy, axisz;

    posx = initialPosition.x;
    posy = initialPosition.y;
    posz = initialPosition.z;

    angle = initialAngle;
    
    axisx = initialAxis.x;
    axisy = initialAxis.y;
    axisz = initialAxis.z;

    writeFloat ( file, posx );
    writeFloat ( file, posy );
    writeFloat ( file, posz );

    writeFloat ( file, angle );

    writeFloat ( file, axisx );
    writeFloat ( file, axisy );
    writeFloat ( file, axisz );

    writeInt ( file, children );

    for (int i=0; i<children; i++)
      child[i] -> writeToFile ( file );
   }

  void BONEVERTEX :: print ( int cpt, FILE * dest )
   {
    if ( ! childListCompiled ) compileChildList ();
    int i;

    for (i=0; i<cpt; i++)
      fprintf ( dest, " |   " );
    if ( children != 0 ) fprintf ( dest, "[-] " );
    else                 fprintf ( dest, " |- " );

    fprintf ( dest, "%s\n", getName () );

    for (i=0; i<children; i++)
      child[i] -> print ( cpt+1, dest );
   }
