// This may look like C code, but it is really -*- C++ -*-

//<copyright>
//
// Copyright (c) 1996
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
//
// This file is part of VRweb.
//
// VRweb is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// VRweb is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with VRweb; see the file LICENCE. If not, write to the
// Free Software Foundation, Inc., 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// Note that the GNU General Public License does not permit incorporating
// the Software into proprietary or commercial programs. Such usage
// requires a separate license from IICM.
//
//</copyright>

//<file>
//
// Name:        lightlist.h
//
// Purpose:     Interface to class LightList
//
// Created:      8 Feb 1996  Georg Meszaros
//
// Modified:    13 Jun 1996  Georg Meszaros 
//
//
// Description:
//
// Definition of the class LightList, a linked list of differen light types 
// 
//
//</file>


//<class>
//
// Name:    LightList
//
// Purpose:
//
//
// Public Interface:
//
/*
    LightList();
    ~LightList();   

    void add(AnyLight* element);
    > adds a new element from type AnyLight* at the end of the linked list

    void print();
    > print all elements

    unsigned length() const;   
    > number of elements 

*/    
// Description:
//
// A simple linked list to store as many different lights as necessary
// on the free store. Types of AnyLight are declared in attributes. 
// 
//
//</class>


#ifndef harmony_scene_list_h
#define harmony_scene_list_h

class AnyLight;

class LightList
{
  public:
    LightList();

    ~LightList();   

    void add(AnyLight* element);
    void print();

    unsigned length() const;    

  private:
    unsigned length_;          // lenght of the linked list
    AnyLight* element_;        // holds a pointer to a light
    LightList* next_;          // pointer to the next element(LightList) or nil for the tail
    LightList* prev_;          // pointer to the predecessor or nil for the head
    static LightList* head_;   // head of the list
    static LightList* tail_;   // ... and the tail to make append easier

}; // LightList

inline unsigned LightList::length() const { return length_; }

#endif
