/* (C) 1998 Justin Schoeman */

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>                     
                     
#include <stdio.h>
#include <stdlib.h>

#ifdef NTSC
#define SPF (int)(88100/30) /*NTSC*/
#else
#define SPF (int)(88100/25) /*PAL*/
#endif

int main(int argc, char** argv)
{
 char name[1024], junk[1024];
 unsigned int i,j,k,l,m,n,o,p;
 int jfs_stream[256];
 FILE *cliptab;
 signed short aframe[SPF/2], aframe2[SPF/2];

 if(argc!=2)
 {
  fprintf(stderr, "Usage:\n\n");
  fprintf(stderr, " str2ppm <cliptab>\n\n");
  exit(0);
 }
 
 fprintf(stderr, "INITIALISING AUDIO FILES\n");
 cliptab=fopen(argv[1], "r");
 if(!cliptab)
 {
  perror("open cliptab");
  exit(-1);
 }
 i=0;
 while(strcmp(fgets(name, 1024, cliptab),"*\n")!=0)
 {
  fprintf(stderr, "group %d: ", i);
  sscanf(name, "%s", junk);
  sprintf(name, "%s.out", junk); /* .out */
  fprintf(stderr, "[%s]\n", name);
  jfs_stream[i]=open(name, O_RDONLY);
  if(jfs_stream[i]<=0)
  {
   perror("open audio file");
   exit(-1);
  }
  i++;
 }
 while(fgets(junk, 256, cliptab))
 {
  switch(junk[0])
  {
   case 'O':
   case 'B': sscanf(junk, "%c %d %d %d", &(junk[0]), &j, &k, &l);
             fprintf(stderr, "Block group %u start %u length %u\n", j, k, l);
             lseek(jfs_stream[j], k*SPF, SEEK_SET);
             for(o=0; o<l; o++)
             {
              read(jfs_stream[j], &aframe, SPF);
              fwrite(&aframe, 2, SPF/2, stdout);
             }
             break;
   case 'F': sscanf(junk, "%c %d %d %d", &(junk[0]), &j, &k, &l);
             fprintf(stderr, "Block group %u start %u length %u (fade out)\n", j, k, l);
             lseek(jfs_stream[j], k*SPF, SEEK_SET);
             for(o=0; o<l; o++)
             {
              read(jfs_stream[j], &aframe, SPF);
              for(p=0; p<(SPF/2); p++)
               aframe[p]=aframe[p]*((float)(l-o)/(float)(l));
              fwrite(&aframe, 2, SPF/2, stdout);
             }
             break;
   case 'f': sscanf(junk, "%c %d %d %d", &(junk[0]), &j, &k, &l);
             fprintf(stderr, "Block group %u start %u length %u (fade in)\n", j, k, l);
             lseek(jfs_stream[j], k*SPF, SEEK_SET);
             for(o=0; o<l; o++)
             {
              read(jfs_stream[j], &aframe, SPF);
              for(p=0; p<(SPF/2); p++)
               aframe[p]=aframe[p]*(1-((float)(l-o)/(float)(l)));
              fwrite(&aframe, 2, SPF/2, stdout);
             }
             break;
   case 'X': sscanf(junk, "%c %d %d %d %d %d", &(junk[0]), &j, &k, &l, &m, &n);
             fprintf(stderr, "Block group %u start %u length %u (mix to %u,%u)\n", j, k, l, m, n);
             for(o=0; o<l; o++)
             {
              lseek(jfs_stream[j], (k+o)*SPF, SEEK_SET);
              read(jfs_stream[j], &aframe, SPF);
              lseek(jfs_stream[m], (n+o)*SPF, SEEK_SET);
              read(jfs_stream[j], &aframe2, SPF);
              for(p=0; p<(SPF/2); p++)
               aframe[p]=aframe2[p]*(1-((float)(l-o)/(float)(l)))+aframe[p]*(((float)(l-o)/(float)(l)));
              fwrite(&aframe, 2, SPF/2, stdout);
             }
             break;
   default: fprintf(stderr, "Unknown edit command\n");
    	    exit(-1);
  }
 }
 return 0;
}
