#include "frameobj.h"

#include <qcolor.h>

/////////////////////////////////////////////////////////////////
// FrameObj
/////////////////////////////////////////////////////////////////
FrameObj::FrameObj() : MapObj()
{
//    cout << "Const FrameObj ()\n";
    init ();
}

FrameObj::FrameObj(QCanvas* c) :MapObj(c)
{
//    cout << "Const FrameObj\n";
    init ();
}

FrameObj::~FrameObj()
{
	clear();
}

void FrameObj::init()
{
    type=NoFrame;
    border=0;
}

void FrameObj::clear()
{
    switch (type)
    {
		case NoFrame:
			break;
		case Rectangle:
			delete rectFrame;
			break;
    }
	type=NoFrame;
	border=0;
}

void FrameObj::move(double x, double y)
{
    switch (type)
    {
		case NoFrame:
			break;
		case Rectangle:
			rectFrame->move (x,y);
			break;
    }
}

void FrameObj::moveBy(double x, double y)
{
	MapObj::moveBy (x,y);
}

void FrameObj::positionBBox()
{
}

void FrameObj::calcBBoxSize()
{
}

void FrameObj::setRect(const QRect &r)
{
	bbox=r;
    switch (type)
    {
		case NoFrame:
			break;
		case Rectangle:
			rectFrame->setX (bbox.x() );
			rectFrame->setY (bbox.y() );
			rectFrame->setSize (bbox.width(),bbox.height() );
			break;
    }
}

int FrameObj::getBorder()
{
	return border;
}

FrameType FrameObj::getFrameType()
{
	return type;
}

QString FrameObj::getFrameTypeName()
{
    switch (type)
    {
		case Rectangle:
			return "Rectangle";
			break;
		default:
			return "NoFrame";
    }
}

void FrameObj::setFrameType(const FrameType &t)
{
	if (t!=type)
	{
		clear();
		type=t;
		switch (type)
		{
			case NoFrame:
				border=0;
				break;
			case Rectangle:
				border=10;
				rectFrame = new QCanvasRectangle (canvas);
				rectFrame->setZ(Z_FRAME);
				rectFrame->setBrush( QColor("white") );
				rectFrame->setPen( QPen(QColor("black") ));
				break;
		}
		setVisibility (visible);
	}
}

void FrameObj::setFrameType(const QString &t)
{
	if (t=="Rectangle")
		FrameObj::setFrameType (Rectangle);
	else	
		FrameObj::setFrameType (NoFrame);
}

void FrameObj::setVisibility (bool v)
{
    MapObj::setVisibility(v);
	switch (type)
	{
		case NoFrame:
			break;
		case Rectangle:
			if (visible)
				rectFrame->show();
			else    
				rectFrame->hide();
			break;
	}
}

