#
# WAJIG - Debian Administration Manager
#
# Documentation for wajig
#
# Copyright (c) Graham.Williams@csiro.au
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#

import const

#
# VERSION
#
def version():
    print "wajig " + const.version +\
          """ - Command line system admin for Debian GNU/Linux
Copyright (c) Graham.Williams@csiro.au

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

On Debian systems, this may be found in /usr/share/common-licenses/GPL.
"""

#
# USAGE
#
def usage():
    print """Usage:
        wajig [options] [command] [packages|files] ...

	Wajig is a command line system manager for Debian GNU/Linux

        For a list of commands try `wajig help'.
        Basic documentation available with `wajig doc | less'
"""

#
# HELP
#
def help(verbose):

#
# COMMON COMMANDS
#
    if verbose == 0:
        print """Common wajig commands:

 update         Update the list of downloadable packages

 new            List packages that became available since last update
 newupgrades    List packages newly available for upgrading

 install        Install (or upgrade) one or more packages or .deb files
 remove         Remove one or more packages (see also purge)

 upgrade	Upgrade all of the installed packages or just those listed

 listfiles	List the files that are supplied by the named package
 listnames	List all known packages or those containing supplied string
 whatis		For each package named obtain a one line description
 whichpkg	Find the package that supplies the given command or file 

Run `wajig -v help' for a complete list of commands and
`wajig -vv help' or `wajig doc' for basic documentation.
"""

#
# ALL COMMANDS AND OPTIONS
#
    elif verbose == 1:
      print """All wajig commands:

 autoclean	Remove all superseded downloaded deb files
 bug		Check reported bugs in package using the Debian Bug Tacker
 build		Retrieve/unpack sources and build .deb for the named packages
 clean		Remove all downloaded deb files
 daily-upgrade  Perform an update then a dist-upgrade
 describe	One line description of packages (-v and -vv for more detail)
 describenew	One line description of new packages
 detail  	Provide a detailed description of package (describe -vv)
 detailnew  	Provide a detailed description of new packages (describe -vv)
 dist-upgrade	Upgrade to new distribution (installed and new rqd packages)
 doc            Equivalent to help with -verbose=2
 download       Download package files ready for an install
 edit		Edit any file that root can edit
 editsources	Edit the sources.list file which locates Debian archives
 filedownload   Download packages listed in file ready for an install
 fileinstall    Install packages listed in a file
 findfile       Search for a file within installed packages
 force		Install packages even if it overwrites files from other pkgs
 help           Print documentation (detail depends on --verbose)
 hold		Place listed packages on hold so they are not upgraded
 init           Initialise or reset the wajig archive files
 install        Install (or upgrade) one or more packages or .deb files
 integrity      Check the integrity of installed packages (through checksums)
 lastupdate     Identify when an update was last performed
 list           List the status of every known package
 listalts	List the objects that can have alternatives configured
 listfiles	List the files that are supplied by the named package
 listinstalled  List the name of each package installed on the system
 listnames	List all known packages or those containing supplied string
 new            List packages that became available since last update
 newupgrades    List packages newly available for upgrading
 orphans        List libraries not required by any installed package
 policy         From preferences file show priorities and policy
 purge          Remove one or more packages and configuration files
 reconfigure    Reconfigure the named installed packages
 reinstall      Reinstall each of the named packages
 reload 	Ask a daemon (e.g., gdm, apache) to reload configs
 remove         Remove one or more packages (see also purge)
 repackage      Generate a .deb file for an installed package
 reset          Initialise or reset the wajig archive files
 restart	Stop and then start a daemon, e.g., gdm, apache
 search         Search for packages containing listed words
 source		Retrieve and unpack sources for the named packages
 start		Start a daemon, e.g., gdm, apache
 status		Show the version and available version of packages
 stop		Stop a daemon, e.g., gdm, apache
 toupgrade      List packages with newer versions available for upgrading
 update         Update the list of downloadable packages
 updatealts	Update default alternative for things like x-window-manager
 upgrade	Upgrade all of the installed packages or just those listed
 whatis		A synonym for describe
 whichpkg	Find the package that supplies the given command or file 

Command line options:

 -h|--help      Print usage message.
 -q|--quiet     Do system commands everything quietly.
 -t|--teaching  Trace the sequence of commands performed.
 -v|--verbose=n Increase (or set) the level of verbosity (to n).

Run `wajig -vv help' for basic documentation.
"""

#
# FULL DOCUMENTATION
#
    else:
      print """Welcome to wajig, the command line system admin for Debian GNU/Linux.

Wajig is Copyright (c) Graham.Williams@csiro.au

Wajig is available from any Debian archive (unstable).

It is also available from

	deb http://datamining.csiro.au/debian ./
	deb-src http://datamining.csiro.au/debian ./

------------------------------------------------------------------------
USING WAJIG

Wajig expects a command and will call upon other Debian tools to
perform the command. You can obtain a list of common commands with
`wajig help' and a list of all commands with `wajig -v help'. The
commands can be mixed case and can have hyphens and underscores to
make them more readable and wajig will accept them. Fuller
documentation is available with `wajig -vv help' or `wajig doc'.

------------------------------------------------------------------------
HISTORY

If you've tried to remember all the different commands to get
different information about different aspects of Debian package
management and then used other commands to install and remove packages
then you'll know that it can become a little too much.
 
Swapping between dselect, deity, deity-gtk, aptitutde, apt-get, dpkg,
gnome-apt, apt-cache, and so on is interesting but cumbersome.  Plus
personally I find dselect, deity, and aptitude confusing and even
though I've spent hours understanding each of them, I don't think the
time was particularly well spent.

This Python script simply collects together what I have learnt over
the years about various commands!  Clearly I have yet to learn all
there is.

Another effort called feta has a similar goal of being a front end to
APT and I have extended and refined my wajig interface to match feta
to some extent. Wajig aims to offer more than just package management
though.

------------------------------------------------------------------------
GETTING STARTED - USING SUDO

The aim of wajig is to operate as a user command and to do super user
privileged commands as necessary. The easiest way to do this is to use
the `sudo' package which will ask you for your (user) password and
then run the command as the super user. If you don't have sudo
installed then wajig will use `su' to run as super user, but you will
need to enter the super user password frequently. If `sudo' is
installed but not set up for you to access the appropriate APT
commands you will see a permission denied message.

Installing sudo is straight forward. As root run the command `visudo'
to edit the configuration file.  Add the lines:

  Cmnd_Alias  APT = /usr/bin/apt-get, /usr/bin/apt-cache, /usr/bin/dpkg, \ 
                    /usr/bin/sensible-editor, /usr/sbin/dpkg-reconfigure, \ 
                    /etc/init.d/*, /usr/sbin/update-alternatives, \ 
                    /usr/lib/apt-move/fetch, /usr/bin/dselect

and

  kayon     ALL=(ALL) APT

in the appropriate places. Then user `kayon' can run the APT and
related commands as the super user.

------------------------------------------------------------------------
AVAILABLE PACKAGES

You will generally need to update the list of packages available for
downloading, unless you are staying with the `stable' release where
you generally only need to get the list of available packages once.
The command 

        wajig update

is used to update the information about what is available for
downloading.  This relies on the entries in the sources.list file in
/etc/apt to know where to get the list of available packages from.
You can edit this file (using the system's default editor which is
changed with the command `wajig updatealts editor') with:
	
	wajig editsources

But you will need to understand the format of the file, which is
explained in the sources.list manual page:

	man sources.list

------------------------------------------------------------------------
FINDING PACKAGES

Once the list of available packages is updated you can see what new
packages have been added to Debian with the command

        wajig new

Note that after the first time you use `wajig update' all packages
will be considered new!

Packages that you already have installed may have been upgraded in the
archive. The command:

        wajig newupgrades

will list the packages that have been upgraded on the archive since
the last time an update was done.

For a complete list of packages that have newer versions available on
the archive use:

        wajig toupgrade

To check the version of any installed package plus the version
available from the archive previously and now and the so called
Desired and Status flags, use:

	wajig status <package names>

Without a list of package names all installed packages will be listed.


To check for a particular package for which you might guess at part of
its name you can use:

	wajig listnames <string>

Without the <string> argument all known package names will be listed.

Each package supplies a number of files and sometimes you like to see
where those files go, or even just view the list of files
supplied. The command to use is:

	wajig listfiles <package name>

To list a one line description for a package use:

	wajig whatis <package name>

And to find which package supplies a given command or file use:

	wajig whichpkg <command or file path>

------------------------------------------------------------------------
INSTALLING PACKAGES

To install a new package (or even update an already installed package)
all you need do is:

        wajig install <package name>

Instead of INSTALL you could equivalently say UPDATE. If instead you
say DOWNLOAD then the packages will be downloaded but not installed so
that a follow up INSTALL will do the install without having to
download the packages. This is useful when you are installing many
packages that need to be downloaded, but you don't want to wait for
the download, yet you want to be there for the install!

You can list multiple packages to install with the one command.

The INSTALL command will also accept a .deb file.  So, for example, if
you have downloaded a Debian package file (with the .deb extension)
you can install it with:

        wajig install <.deb file>

The .deb file will be searched for in both the current directory and
in the apt archive at /var/cache/apt/archive/.

You can list multiple .deb files to install.

If the .deb package file you wish to install is available on the
internet you can give its address and wajig will download then install
it:

  wajig install http://samfundet.no/debian/dists/woody/css/xine-dvd-css.dvd

Once a package is installed remove it with:

	wajig remove <package name>

Once again, you can list multiple packages to remove with the one command.

A REMOVE will not remove configuration files.  To get rid of the
configuration files as well use:

	wajig purge <package name>

You can upgrade all installed packages with:

	wajig upgrade

And you can upgrade all installed packages and install all newly
required packages in the distribution with:

	wajig dist-upgrade

If you have a list of packages you want installed stored in a file (as
you might create with the LISTINSTALLED command run on a different
Debian machine) you can use FILEINSTALL or FILEDOWNLOAD to install or
download the packages:

	wajig fileinstall newpkgs.txt

The file can be any format, perhaps one package per line or all
packages on one line separated by white space.

------------------------------------------------------------------------
BUILDING PACKAGES

You can download the source code for a package, perhaps modify it, and
generate your own .deb file for installation. You will need deb-src
lines in your sources.list file, such as the following:

	deb-src http://ftp.debian.org/debian unstable main contrib non-free

Generally you can add the `-src' to copies of pre-existing `deb' lines.

To retrieve and unpack a source Debian package use:

	wajig source <package names>

Note that you can list several packages.

This command downloads the .tar.gz file and the .dsc file for the
package. The .tar.gz file contains the source code and associated
files. The .dsc file contains test information that is used by the
packaging system. The .tar.gz file will be extracted to create a
subdirectory consisting of the package name and version.

To go one step further and also configure, compile and generate a
Debian .deb package from source code (useful if you need to compile a
package for your setup specifically) then use instead:

	wajig build <package names>

------------------------------------------------------------------------
MANAGING LOCAL PACKAGE ARCHIVE

When packages are installed the corresponding .deb files are stored in
/var/cache/apt/archive. This can become quite populated with older
versions of packages and we can clean out these older versions with:

	wajig autoclean

Note however that it is sometimes useful to have older versions
hanging around if you are tracking unstable. Sometimes the newer
versions of packages are broken and you need to revert to an older
version.

Nonetheless, if you get short of disk space then you might want to
remove all the downloaded .deb files with:

	wajig clean

If instead you want to create a partial Debian mirror on your own web
server then the following command is useful after you have set up
apt-move to move the Debian packages from /var/cache/apt/archive to
/var/www/pub/debian:

	wajig move

------------------------------------------------------------------------
MANAGING DAEMONS OR SERVICES

Wajig also allows you to start, stop, reload, and restart services.
The commands all follow the same pattern:

	wajig restart <service name>

The start and stop commands are obvious.  The restart command
generally performs a stop followed by a start. The reload command
will ask the daemon to reload its configuration files generally
without stopping the daemon, if this is possible.  The services you
can specify here depend on what you have installed.  Common services
include:

	apache		  Web server
	cron		  Regular task scheduler
	exim		  Email delivery system
	gdm		  The Gnome Windows Display Manager (for logging on)
	nfs-kernel-server Network File System
	ssh		  The Secure Shell daemon

------------------------------------------------------------------------
REQUIREMENTS

Wajig depends on a collection of other packages:
        python          (either 1.5.2 or 2)
        apt             (for apt-get and apt-cache)
        apt-move
        wget
        fping

------------------------------------------------------------------------
HOW IT WORKS

Wajig maintains state information in ~/.wajig/$(hostname). Three files
there record the currently known available packages as of the last
"update", the previous version of this same file, and a list of
installed packages. This directory is created whenever wajig notices
that it does not exist, typically the first time you run wajig. 

The hostname is included in the above path for those environments
where a collection of Debian machines share the /home directories
through NFS, for example. Each machine may well be managed separately
(e.g., by the primary user of that machine who need not know the root
password) and so have a different collection of Installed packages,
and even a different collection of Available packages (e.g., stable
versus unstable and i386 versus sparc).

------------------------------------------------------------------------
LIMITATIONS

There are some know limitations particularly where a network of
machines share /var/cache/apt/archives (to share the downloading of
packages).  Occasionally one wajig will not be able to lock this
shared directory because at the same time another wajig on another
machine has it locked.

------------------------------------------------------------------------
TODO

	Document: bug, findfile, force, describe, integrity, list,
		  orphans, reconfigure, reinstall, repackage, search,
		  hold, updatealts, listalts, lastupdate, edit, detail,
                  listinstalled, daily-update.

------------------------------------------------------------------------
ACKNOWLEDGEMENTS

Wajig is written by Graham J. Williams. Wajig is licensed under the
GNU GPL and is Copyright (c) Graham.Williams@csiro.au 

The idea for wajig came from my regularly jotting down notes about
different commands within Debian for different tasks, all to do with
package management. The `feta' tool is an alternative tool which aims
to be a front-end to APT and is written by Joe Wreschnig
<piman@sacredchao.net>.

Dirk Eddelbuettel <edd@debian.org> has been most helpful and
encouraging in getting Wajig uploaded to the Debian archives and
making many extremely useful suggestions for improving and enhancing
Wajig.
"""
