/* Copyright (C) 1999 Rafal Wierzbicki <rafal@mcss.mcmaster.ca>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

static char *cvsident = "$Id: wharf.c,v 1.2 1999/03/25 23:04:59 rafal Exp $";


/* XPM */
static char * cycle_xpm[] = {
    "10 10 4 1",
    " 	c None",
    ".	c #F7F3FF",
    "+	c #AEAAAE",
    "@	c #000000",
    "..........",
    ".+++++++++",
    ".+++@@@+++",
    ".++@+++@++",
    ".++@+++@++",
    ".++@+++@++",
    ".++@+++@++",
    ".++@+++@++",
    ".+++@@@+++",
    ".+++++++++"};
/* XPM */
static char * start_xpm[] = {
    "10 10 4 1",
    " 	c None",
    ".	c #F7F3FF",
    "+	c #AEAAAE",
    "@	c #000000",
    "..........",
    ".+++++++++",
    ".++++++@@+",
    ".+++++@@@+",
    ".+@@+@@@++",
    ".+@@@@@+++",
    ".+@@@@++++",
    ".+@@@+++++",
    ".+@@++++++",
    ".+++++++++"};
/* XPM */
static char * stop_xpm[] = {
    "11 10 4 1",
    " 	c None",
    ".	c #F7F3FF",
    "+	c #AEAAAE",
    "@	c #000000",
    "...........",
    ".++++++++++",
    ".+@@+++@@++",
    ".+@@@+@@@++",
    ".++@@@@@+++",
    ".+++@@@++++",
    ".++@@@@@+++",
    ".+@@@+@@@++",
    ".+@@+++@@++",
    ".++++++++++"};

#include "wallp.xpm"
#include "wallp.h"
#include <X11/extensions/shape.h>
#include <Imlib.h>

static int timer = 0;
static int calls = 0;
static unsigned int current = 0;
static unsigned int pcurrent = 0;

extern GSList *simple_list;

GtkWidget *progressbar;

static gint wharf_list_show ();

static void
wharf_start_idle ()
{
    if (!timer)
        timer = gtk_timeout_add (1000, (GtkFunction) wharf_list_show, NULL);
}

static void
wharf_stop_idle ()
{
    if (timer)
    {
        gtk_timeout_remove (timer);
        timer = 0;
    }
}

static void
wharf_event (GtkWidget *w, GdkEventButton *event)
{
    if (event->type==GDK_BUTTON_RELEASE && event->button==3)
    {
        wharf_stop_all ();
    }
    else if (event->type==GDK_BUTTON_RELEASE && event->button==1)
    {
        wharf_start_idle ();
    }
}

static
gint wharf_stop_all ()
{
    wharf_stop_idle ();
    return FALSE;
}

static gint
wharf_list_show ()
{
    char *item_data;
    static int sleep_time;
    static time_t time_start;
    time_t time_now;
    gint selection;
    gfloat percentage = 0.0;

    time_now = time (NULL);

    if (calls == 0)
    {
        calls = 1;
        current = (gint) random_image ();
        pcurrent = (gint) random_image ();

        item_data = g_slist_nth_data (simple_list, pcurrent);
        /* do the icon thing here */
        icon (item_data);
        /* do the root window here*/
        item_data = g_slist_nth_data (simple_list, current);
        if (put_image_on_root (item_data, STYLE))
        {
            simple_list_remove (item_data);
        }
        time_start = time (NULL);
    }

    sleep_time = 60;

    percentage =  ((float)time_now - (float)time_start)/(float)sleep_time;
    /* strange manouvers here to make the progress bar as accurate as possible */
    if (percentage > 1.0)
        percentage = 1.0;
    else if (percentage < 0.0)
        percentage = 0.0;
    gtk_progress_bar_update (GTK_PROGRESS_BAR(progressbar), percentage);

    if ((time_now - time_start) >= sleep_time )
    {

        if (no_of_list_items == 0)
        {
            wharf_stop_all ();
            return FALSE;
        }
        current = pcurrent;
        pcurrent = (gint) random_image ();
        /* icon thing */
        item_data = g_slist_nth_data (simple_list, pcurrent);
        icon (item_data);
        /*root thing*/
        item_data = g_slist_nth_data (simple_list, current);
        if (put_image_on_root (item_data, STYLE))
        {
            simple_list_remove (item_data);
        }
        time_start = time (NULL);
    }
    return TRUE;
}

void wharf_create_gui (void)
{
    static GtkWidget *window=NULL;
    GtkWidget *darea, *viewport;
    GtkWidget *hbox, *vbox, *button;
    GtkWidget *pixmapwid;
    GdkBitmap *mask=NULL;
    GdkPixmap *pixmap=NULL;
    GtkStyle *style;

    if (!window)
    {
        window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
        gtk_window_set_title (GTK_WINDOW (window), "WallP");
        /*      gtk_widget_set_usize (window, 60, 60);*/
        gtk_widget_realize (window);
        gtk_signal_connect (GTK_OBJECT (window), "destroy",
                            GTK_SIGNAL_FUNC(gtk_main_quit),
                            NULL);
        gtk_signal_connect (GTK_OBJECT (window), "delete_event",
                            GTK_SIGNAL_FUNC (gtk_false),
                            NULL);

        vbox = gtk_vbox_new (FALSE, 0);
        gtk_container_add (GTK_CONTAINER (window), vbox);
        gtk_widget_show (vbox);

        viewport = gtk_viewport_new (NULL, NULL);
        gtk_widget_set_usize(viewport, 54, 44);
        gtk_box_pack_start(GTK_BOX(vbox),viewport,FALSE,FALSE,0);
        gtk_widget_show(viewport);

        darea=gtk_drawing_area_new();
        gtk_drawing_area_size (GTK_DRAWING_AREA(darea), 54, 44);
        gtk_widget_set_usize(darea, 60, 50);
        gtk_container_add(GTK_CONTAINER(viewport),darea);
        gtk_widget_show(darea);
        icon_area = darea;

        hbox = gtk_hbox_new (FALSE, 0);
        gtk_container_add (GTK_CONTAINER (vbox), hbox);
        gtk_widget_show (hbox);

        /* buttons */

        progressbar = gtk_progress_bar_new ();
        gtk_widget_set_usize (progressbar, 34, 10);
        gtk_box_pack_start(GTK_BOX(hbox),progressbar,FALSE,FALSE,0);
        gtk_widget_show (progressbar);

        button = gtk_button_new();
        gtk_widget_set_usize (button, 10, 10);
        gtk_box_pack_start(GTK_BOX(hbox), button, FALSE, FALSE, 0);
        gtk_signal_connect (GTK_OBJECT(button), "clicked",
                            GTK_SIGNAL_FUNC (wharf_stop_idle), NULL);
        gtk_widget_show (button);

        style = gtk_widget_get_style (window);
        pixmap = gdk_pixmap_create_from_xpm_d(window->window, &mask,
                                              &style->bg[GTK_STATE_NORMAL],
                                              (gchar **)stop_xpm);
        pixmapwid = gtk_pixmap_new (pixmap, mask);
        gtk_container_add (GTK_CONTAINER(button), pixmapwid);
        gtk_widget_show (pixmapwid);

        button = gtk_button_new ();
        gtk_widget_set_usize (button, 10, 10);
        gtk_box_pack_start(GTK_BOX(hbox), button, FALSE, FALSE, 0);
        gtk_signal_connect (GTK_OBJECT(button), "clicked",
                            GTK_SIGNAL_FUNC(wharf_start_idle), NULL);
        gtk_widget_show (button);

        pixmap = gdk_pixmap_create_from_xpm_d(window->window, &mask,
                                              &style->bg[GTK_STATE_NORMAL],
                                              (gchar **)start_xpm);
        pixmapwid = gtk_pixmap_new (pixmap, mask);
        gtk_container_add (GTK_CONTAINER(button), pixmapwid);
        gtk_widget_show (pixmapwid);

        /*gtk_signal_connect(GTK_OBJECT(progressbar), "button_release_event",
        GTK_SIGNAL_FUNC(wharf_event),
        NULL);*/

        gdk_window_set_functions (window->window, 0);
        gdk_window_set_decorations (window->window, 0);

        gtk_widget_show (window);
        /*wharf_start_idle ();*/
    }
}
