#ifndef MSG_AGGREGATING_COMMUNICATION_MANAGER_H
#define MSG_AGGREGATING_COMMUNICATION_MANAGER_H

// Copyright (c) The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.

// Authors: Malolan Chetlur             mal@ececs.uc.edu
//          Jorgen Dahl                 dahlj@ececs.uc.edu
//          Dale E. Martin              dmartin@cliftonlabs.com
//          Radharamanan Radhakrishnan  ramanan@ececs.uc.edu
//          Dhananjai Madhava Rao       dmadhava@ececs.uc.edu
//          Philip A. Wilsey            phil.wilsey@uc.edu

#include "warped.h"
#include "CommunicationManagerImplementationBase.h"
#include "MessageManager.h"

/** The MsgAggregatingCommunicationManager class.

As the name implies, this is the communication manager
implementation that uses the message aggregation optimization.
This class is derived from the CommunicationManager abstract base
class.

*/
class MsgAggregatingCommunicationManager : public CommunicationManagerImplementationBase {

public:

  /**@name Public Class Methods of MsgAggregatingCommunicationManager. */
  //@{
  
  /** Constructor.

  @param physicalLayer Handle to the phys. comm. mgr.
  */
  MsgAggregatingCommunicationManager( PhysicalCommunicationLayer *physicalLayer,
				      TimeWarpSimulationManager *simMgr);

  /// Destructor.
  ~MsgAggregatingCommunicationManager();

  /// initialize the communication manager
  void initializeCommunicationManager();

  /** Send message.

  @param msg Message to send.
  */
  void sendMessage( KernelMessage *msg, unsigned int dest);
   
  /** Retrieve a message from the physical comm. layer.

  @return Retrieved message.
  */
  SerializedInstance *retrieveMessageFromPhysicalLayer();

  unsigned int checkPhysicalLayerForMessages(int maxNum);
   
  void incrementAgeOfMessage(){
    myMessageManager->incrementAgeOfMessage();
  }
   
  void setRollingBackFlagInMessageManager(){
    myMessageManager->setRollBackFlag();
  }
   
  void resetRollingBackFlagInMessageManager(){
    myMessageManager->resetRollBackFlag();
  }

  void flush(){
    myMessageManager->sendMessage();
  }

  void flushIfAgeExceeded(){
    myMessageManager->flushIfAgeExceeded();
  }

  void flushIfWaitedTooLong(){
    myMessageManager->flushIfWaitedTooLong(waitedWithNoInputMessages);
  }

  virtual void configure( SimulationConfiguration & ){}

private:

  MessageManager *myMessageManager;
  int waitedWithNoInputMessages;

  //@} // End of Public Class Methods of MsgAggregatingCommunicationManager
};

#endif
