// Copyright (c) The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.

// Authors: Malolan Chetlur             mal@ececs.uc.edu
//          Jorgen Dahl                 dahlj@ececs.uc.edu
//          Dale E. Martin              dmartin@cliftonlabs.com
//          Radharamanan Radhakrishnan  ramanan@ececs.uc.edu
//          Dhananjai Madhava Rao       dmadhava@ececs.uc.edu
//          Philip A. Wilsey            phil.wilsey@uc.edu

//---------------------------------------------------------------------------
// 
// $Id: PeriodicStateManager.cpp
// 
//---------------------------------------------------------------------------

#include "SimulationObject.h"
#include "PeriodicStateManager.h"
#include "State.h"

PeriodicStateManager::PeriodicStateManager(SimulationManager *simMgr,
                                           unsigned int period ) :
   StateManagerImplementationBase( simMgr, period ){
}

PeriodicStateManager::~PeriodicStateManager(){
}

void
PeriodicStateManager::saveState(const VTime& currentTime,
                                SimulationObject *object){

   // store this object's id temporarily
   OBJECT_ID *currentObjectID = object->getObjectID();
   unsigned int simObjectID = currentObjectID->getSimulationObjectID();
   
   if(periodCounter[simObjectID] <= 0){
      
      // we need to first allocate a state. Copy the current state into
      // this newly created state. Then allocate a state object and
      // fill in the current time and a pointer to the newly copied
      // current state.
      
      State *newState = object->allocateState();
      newState->copyState(object->getState());
   
      SetObject<State> stateObject(currentTime, newState);

      // look up the state queue of the simulation object and insert the
      // newly allocated state object
      myStateQueue[simObjectID].insert(stateObject);
      // reset period counter to state period
      periodCounter[simObjectID] = objectStatePeriod[simObjectID];
   }
   else {
      // decrement period counter
      periodCounter[simObjectID] = periodCounter[simObjectID] - 1;
   }
}


