/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2008 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#ifndef WATCHESDIALOG_H
#define WATCHESDIALOG_H

#include <QDialog>

class QLabel;
class QListWidget;
class QDialogButtonBox;

namespace WebIssues
{

class ColumnConditionSettings;

/**
* Dialog for configuring folder watches.
*/
class WatchesDialog : public QDialog
{
    Q_OBJECT
public:
    /**
    * Constructor.
    *
    * @param folderId Identifier of the folder.
    * @param parent The parent widget.
    */
    WatchesDialog( int folderId, QWidget* parent );

    /**
    * Destructor.
    */
    ~WatchesDialog();

public: // overrides
    void accept();

private slots:
    void newFilter();

private:
    void populateList();

    void setSelectedWatches( const QStringList& watches );
    QStringList selectedWatches();

private:
    int m_folderId;

    QListWidget* m_list;

    ColumnConditionSettings* m_settings;
};

}

#endif
