/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2009 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#ifndef CONNECTIONINFO_H
#define CONNECTIONINFO_H

#include <QStringList>

#include "datarows.h"

/**
* Structure storing information about a connection to the WebIssues server.
*/
class ConnectionInfo
{
public:
    /**
    * Constructor.
    */
    ConnectionInfo();

    /**
    * Destructor.
    */
    ~ConnectionInfo();

public:
    /**
    * Return the name of the server.
    */
    const QString& serverName() const { return m_serverName; }

    /**
    * Return the unique identifier of the server.
    */
    const QString& serverUuid() const { return m_serverUuid; }

    /**
    * Return the version of the server.
    *
    * Before version 0.8.3 this string is empty.
    */
    const QString& serverVersion() const { return m_serverVersion; }

    /**
    * Check if the server is at least the given version.
    *
    * This function ignores the part after the dash (for example beta or RC version).
    */
    bool checkVersion( const QString& version ) const;

    /**
    * Return the list of features enabled on the server.
    */
    const QStringList& features() const { return m_features; }

    /**
    * Check if the specific feature is enabled on the server.
    */
    bool checkFeature( const QString& feature ) const;

    /**
    * Return the identifier of the logged in user.
    */
    int userId() const { return m_userId; }

    /**
    * Return the access level of the logged in user.
    */
    Access access() const { return m_access; }

private:
    static int parseVersion( const QString& version );

protected:
    QString m_serverName;
    QString m_serverUuid;

    QString m_serverVersion;
    QStringList m_features;

    int m_userId;
    Access m_access;
};

#endif
