#!/usr/bin/perl
#
# conf_rules.cgi
#
# This script displays all rules in a given rule file and allows the user
# to edit them.  It will also grab out any reference information and 
# activate links to IDS, CVE, etc.  
#
# Since rule files can be queit large, rules are not displayed in fields
# Instead, you must click edit to edit a rule and the field will appear.
# Note that this is a precursor to a new rule editing screen which will
# be interactive and provide choices according to the Snort rules document.
#
require './snort-lib.pl';

# External URLs to Snort rule info
%refurls = ('arachnids' => 'http://www.whitehats.com/IDS/',
            'bugtraq'   => 'http://www.securityfocus.com/bid/',
            'cve'       => 'http://cve.mitre.org/cgi-bin/cvename.cgi?name=',
            'mcafee'    => 'http://vil.nai.com/vil/dispVirus.asp?virus_k=');

&ReadParse();

# If the user can't view rules - well we'll bail right here
&snort_error($text{'rule_noview'}) if (!$access{'ruleview'});

# Check to see if user can access a given ruleset
$whatsfailed = $text{'rule_error'};
if ($access{'rules'} ne "*") {
   if ($access{'rules'} =~ /^\!/) {
      # The access array is all EXCEPT selected
      &snort_error($text{'rule_noacc'}, " ", $in{'rule'}) if ($access{'rules'} =~ /\b$in{'rule'}\b/);
   } else {
      &snort_error($text{'rule_noacc'}, " ", $in{'rule'}) if ($access{'rules'} !~ /\b$in{'rule'}\b/);
   } 
}

# Some basic error checking
&snort_error($text{'rule_norule'}) if !$in{'rule'};
$rulefile = $config{'snort_rules_path'} . "/" . $in{'rule'} . ".rules";
&snort_error($text{'rule_nofile'}, " ($rulefile)") if (! -r $rulefile);

# Grab the rule file and parse it into arrays
if ($access{'ruletog'} || $access{'ruleedit'} || $access{'ruledel'}) {
   $readonly = 0;
} else {
   $readonly = 1;
}
$rules = &read_file_lines($rulefile);

# Lets start the page
&header($text{'rule_title'}, "", undef, 1, 1, 0,
   &help_search_link("snort", "man", "doc", "google"));
print "<hr>\n";

if ($access{'ruleadd'}) {
   print "<form method=\"post\" action=\"save_rules.cgi\">\n"; 
   print "<input type=hidden name=ruleset value=\"" . &html_escape($in{'rule'}) . "\">\n";
}

print "<table border=0 cellspacing=1 width=100%>\n";
print "<tr $tb><td colspan=4 align=center><font size=+1><b>$text{'rule_header'} $rulefile</b></font></td></tr>\n";
print "<tr $tb><th>$text{'rule_col1'}</th><th>$text{'rule_col2'}</th><th>$text{'rule_col3'}</th>";
print "<th>$text{'rule_col4'}</th>" if !$readonly;
print "</tr>\n";

# Dump the rule rows for each rule found 
$rulectr = 1;

foreach $newrule (@$rules) {
   next if ($newrule !~ /->.+(.+)/);  # Try to see if its a rule or bogus comment

   # To pass the rule into other scripts for processing, first search for a snort id which will
   # be unique, but works only with offical rules and Snort 1.8 or higher.
   # If a Snort ID can't be found, lets include the entire rule in the links (making pages HUGE)
   # Maybe at some point we can put in a paging setup to only display X rules per page
   if ($newrule =~ /sid:\s*(\d+)\s*;/) {
      $rulevar = $1;  # We found a Snort ID
   } else {
      # Lets convert the rule into a GET compatible format.
      $rulevar = urlize($newrule);
   }

   print "<tr $cb><th>" . $rulectr++ . "</th>";

   ($prt_rule) = $newrule =~ /^[#]*\s*(.+)/;  # Strip off the comment for printing
   $prt_rule = &html_escape($prt_rule);

   # Lets include links to vulnerability databases where appropriate
   foreach $site (keys %refurls) {
      $prt_rule =~ s/(reference\:.*)($site)(\s*\,\s*)[0]*(\S+?)\;/$1<a href=\"$refurls{lc $2}$4\" target=\"_blank\">$2$3$4<\/a>\;/ig;
   }

   print "<td><tt><font size=-1>" . $prt_rule . "</font></tt></td>\n";

   # Check to see if the rule is enabled or disabled
   if ($newrule =~ /^[#]+/) {
      print "<td align=center valign=center><img src=\"images/disabled.gif\" alt=\"$text{'index_disabled'}\"></td>\n";
      print "<td><font size=-1>" if !$readonly;
      print "<a href=\"save_rules.cgi?action=enable&ruleset=$in{'rule'}&rule=$rulevar\">$text{'index_enable'}</A> " if $access{'ruletog'};
   } else {
      print "<td align=center valign=center><img src=\"images/enabled.gif\" alt=\"$text{'index_enabled'}\"></td>\n";
      print "<td><font size=-1>" if !$readonly;
      print "<a href=\"save_rules.cgi?action=disable&ruleset=$in{'rule'}&rule=$rulevar\">$text{'index_disable'}</A> " if $access{'ruletog'};
   }

   print "<a href=\"save_rules.cgi?action=edit&ruleset=$in{'rule'}&rule=$rulevar\">Edit</A> " if $access{'ruleedit'};
   print "<a href=\"save_rules.cgi?action=wantdelete&ruleset=$in{'rule'}&rule=$rulevar\">Delete</A>" if $access{'ruledel'};
   print "</font></td>\n" if !$readonly;

   print "</tr>\n";
}

# If we can add rules, lets give them space
print "<tr $cb><td colspan=2><input name=newrule size=90></td><td align=center colspan=2><input type=submit value=\"$text{'rule_addbutton'}\"></td></tr>\n" if ($access{'ruleadd'});

print "</table>\n";
print "</form>\n" if ($access{'ruleadd'});

print "<hr>\n";
&footer("index.cgi", $text{'back_link'});

