#!/usr/bin/perl
#
# save_net.cgi
#
# This script takes in the new network settings
# and saves them in the configuration file

# Do common initialization and get common routines
require 'snort-lib.pl';
ReadParse();

# Check if user can switch rule status
$whatfailed = "Unable to save changes";
$access{'net'} || &snort_error($text{'net_ecannot'});

# Lets lock the file here to be sure we get the right line numbers
lock_file($config{'snort_config'});

# Read in rule config data
$conf = &get_config("var");

# Lets find any changes and replace the lines
$data = &read_file_lines($config{'snort_config'});

foreach $key (keys %$conf) {
   if ($$conf{$key}->{'value'} ne $in{$key}) {
      $data_idx = $$conf{$key}->{'line'};
      # We shouldn't need this, but just in case someone has duplicates...
      ($outkey) = split('__', $key);  # Make sure we strip the index for saving in the conf file
      $new_tuple= "var " . $outkey;
      $new_tuple .= " " . $in{$key} if $in{$key};
      $$data[$data_idx] = $new_tuple;
   }
}

&flush_file_lines();  # Store the new data
unlock_file($config{'snort_config'});

# Log the change
&webmin_log("net", undef, $config{'snort_config'},
	    { 'file' => $config{'snort_config'} });

# Redirect user back to main page
&redirect("index.cgi");
