#!/usr/local/bin/perl
# virt_index.cgi
# Display a menu for some specific virtual server, or the default server

require './apache-lib.pl';
&ReadParse();
($conf, $v) = &get_virtual_config($in{'virt'});
&can_edit_virt($v) || &error($text{'virt_ecannot'});
&header($text{'virt_title'}, "", undef, undef, undef, undef, &restart_button());

# Display header and icons
print "<center><font size=+2>",&text('virt_header', &virtual_name($v)),
      "</font></center>\n";
print "<hr>\n";
print "<h3>$text{'virt_opts'}</h3>\n";
if ($in{'virt'} && $access{'vaddr'}) {
	$vr_icon = { "icon" => "images/virt.gif",
		     "name" => $text{'virt_conf'},
		     "link" => "edit_vserv.cgi?virt=$in{'virt'}" };
	}
$sw_icon = { "icon" => "images/show.gif",
	     "name" => $text{'virt_show'},
	     "link" => "show.cgi?virt=$in{'virt'}" };
if ($in{'virt'} && $access{'types'} eq '*') {
	$ed_icon = { "icon" => "images/edit.gif",
		     "name" => $text{'virt_edit'},
		     "link" => "manual_form.cgi?virt=$in{'virt'}" };
	}
&config_icons("virtual", "edit_virt.cgi?virt=$in{'virt'}&", $sw_icon,
	      $ed_icon ? $ed_icon : (),
	      $vr_icon ? $vr_icon : ());

# Display per-directory options
@dir = ( &find_directive_struct("Directory", $conf) ,
         &find_directive_struct("DirectoryMatch", $conf),
	 &find_directive_struct("Files", $conf),
	 &find_directive_struct("FilesMatch", $conf),
	 &find_directive_struct("Location", $conf),
	 &find_directive_struct("LocationMatch", $conf) );
if (@dir) {
	print "<hr>\n";
	print "<h3>$text{'dir_title'}</h3>\n";
	print "<table width=100% cellpadding=5>\n";
	foreach $d (@dir) {
		if ($i%3 == 0) { print "<tr>\n"; }
		print "<td valign=top align=center width=33%>\n";
		$what = &dir_name($d);
		substr($what, 0, 1) = uc(substr($what, 0, 1));
		&generate_icon("images/dir.gif", $what,
		       	"dir_index.cgi?idx=".&indexof($d, @$conf).
			"&virt=$in{'virt'}");
		print "</td>\n";
		if ($i++%3 == 2) { print "</tr>\n"; }
		}
	while($i++%3) { print "<td width=33%></td>\n"; }
	print "</table>\n";
	}

print "<form action=create_dir.cgi>\n";
print "<input type=hidden name=virt value=$in{'virt'}>\n";
print "<table border>\n";
print "<tr $tb> <td><b>$text{'virt_adddir'}</b></td> </tr>\n";
print "<tr $cb> <td><table>\n";
print "<tr> <td><b>$text{'virt_type'}</b></td> <td><select name=type>\n";
foreach $t ($httpd_modules{'core'} >= 1.2 ? ("Directory", "Files", "Location")
					  : ("Directory", "Location")) {
	print "<option value=$t>$text{'virt_'.$t}\n";
	}
print "</select></td>\n";
if ($httpd_modules{'core'} >= 1.2) {
	print "<td><b>$text{'virt_regexp'}</b></td>\n";
	print "<td><input type=radio name=regexp value=0 checked> ",
	      "$text{'virt_exact'}\n";
	print "<input type=radio name=regexp value=1> ",
	      "$text{'virt_re'}</td> </tr>\n";
	}
else { print "<td></td> </tr>\n"; }
print "<tr> <td><b>$text{'virt_path'}</b></td>\n";
print "<td><input name=path size=40></td>\n";
print "<td colspan=2 align=right>",
      "<input type=submit value=\"$text{'create'}\"></td> </tr>\n";
print "</table></td></tr></table></form>\n";

print "<hr>\n";
&footer("", $text{'index_return'});

