#!/usr/local/bin/perl
# index.cgi
# Display burn profiles and icons for global options

require './burner-lib.pl';
&header($text{'index_title'}, "", undef, 1, 1);
print "<hr>\n";

if (!&has_command($config{'cdrecord'})) {
	print "<p>",&text('index_ecdrecord', "<tt>$config{'cdrecord'}</tt>",
			  "/config.cgi?$module_name"),"<p>\n";
	print "<hr>\n";
	&footer("/", $text{"index"});
	exit;
	}

print "<h3>$text{'index_profiles'}</h3>\n";
@profiles = &list_profiles();
print "<form action=edit_profile.cgi>\n";
if (@profiles) {
	print "<table border width=100%>\n";
	print "<tr $tb> <td><b>$text{'index_name'}</b></td> ",
	      "<td><b>$text{'index_type'}</b></td> ",
	      "<td><b>$text{'index_files'}</b></td> </tr>\n";
	foreach $p (@profiles) {
		print "<tr $cb>\n";
		print "<td><a href='edit_profile.cgi?id=$p->{'id'}'>",
		      "$p->{'name'}</a></td>\n";
		print "<td>",$text{'index_type'.$p->{'type'}},"</td>\n";
		if ($p->{'type'} == 1) {
			print "<td>$p->{'iso'}</td>\n";
			}
		else {
			print "<td>";
			for($i=0; defined($p->{"source_$i"}); $i++) {
				print "&nbsp;|&nbsp;" if ($i);
				print $p->{"source_$i"};
				}
			print "</td>\n";
			}
		print "</tr>\n";
		}
	print "</table>\n";
	}
else {
	print "<b>$text{'index_none'}</b><p>\n";
	}
print "<input type=submit value='$text{'index_add'}'>\n";
print "<select name=type>\n";
print "<option value=1 checked> $text{'index_type1'}\n";
print "<option value=2> $text{'index_type2'}\n";
print "<option value=3> $text{'index_type3'}\n";
print "</select></form>\n";

print "<hr>\n";
print "<h3>$text{'index_global'}</h3>\n";
@links = ( "edit_mkisofs.cgi", "edit_dev.cgi" );
@titles = ( $text{'mkisofs_title'}, $text{'dev_title'} );
@icons = ( "images/mkisofs.gif", "images/dev.gif" );
&icons_table(\@links, \@titles, \@icons);

print "<hr>\n";
&footer("/", $text{'index'});

