#!/usr/local/bin/perl
# add.cgi
# Add or update a server or group from the webmin servers module

require './cluster-software-lib.pl';
&ReadParse();
@servers = &list_servers();

if ($in{'add'}) {
	# Add a single host
	@add = grep { $_->{'id'} eq $in{'server'} } @servers;
	&error_setup($text{'add_err'});
	$msg = &text('add_msg', &server_name($add[0]));
	}
else {
	# Add all from a group
	@add = grep { $_->{'group'} eq $in{'group'} } @servers;
	&error_setup($text{'add_gerr'});
	$msg = &text('add_gmsg', $in{'group'});
	}
&header($text{'add_title'}, "");
print "<hr>\n";
print "<b>$msg</b><p>\n";

# Setup error handler for down hosts
sub add_error
{
$add_error_msg = join("", @_);
}
&remote_error_setup(\&add_error);

# Get the packages for each host
%sconfig = &foreign_config("software");
foreach $s (@add) {
	$add_error_msg = undef;
	local $host = { 'id' => $s->{'id'} };
	local $soft = &remote_foreign_check($s->{'host'}, "software");
	if ($add_error_msg) {
		print "$add_error_msg<p>\n";
		next;
		}
	if (!$soft) {
		print &text('add_echeck', $s->{'host'}),"<p>\n";
		next;
		}
	&remote_foreign_require($s->{'host'}, "software", "software-lib.pl");
	local $rconfig = &remote_foreign_config($s->{'host'}, "software");
	if ($rconfig->{'package_system'} ne $sconfig{'package_system'}) {
		print &text('add_esystem', $s->{'host'}),"<p>\n";
		next;
		}
	local $gconfig = &remote_foreign_config($s->{'host'}, undef);
	foreach $g ('os_type', 'os_version',
		    'real_os_type', 'real_os_version') {
		$host->{$g} = $gconfig{$g};
		}
	local $n = &remote_foreign_call($s->{'host'}, "software",
					"list_packages");
	local $packages = &remote_eval($s->{'host'}, "software", "\\%packages");
	for($i=0; $i<$n; $i++) {
		push(@{$host->{'packages'}},
		     { 'name' => $packages->{$i,'name'},
		       'class' => $packages->{$i,'class'},
		       'desc' => $packages->{$i,'desc'} });
		}
	&save_software_host($host);
	print &text('add_ok', &server_name($s), $n),"<p>\n";
	}
&remote_finished();

print "<hr>\n";
&footer("", $text{'index_return'});


