#!/usr/local/bin/perl
# Handled remote_* function calls by a faster method. When first called
# as a CGI, forks and starts listening on a port which is returned to the
# client. From then on, direct TCP connections can be made to this port
# to send requests and get replies.

do './web-lib.pl';
use POSIX;
use Socket;
&init_config();
&ReadParse();
print "Content-type: text/plain\n\n";

# Can this user make remote calls?
%access = &get_module_acl();
if ($access{'rpc'} == 0 || $access{'rpc'} == 2 &&
    $base_remote_user ne 'admin' && $base_remote_user ne 'root') {
	print "0 Invalid user for RPC\n";
	exit;
	}

# Find a free port
$port = 10000;
$proto = getprotobyname('tcp');
if (!socket(MAIN, PF_INET, SOCK_STREAM, $proto)) {
	print "0 socket failed : $!\n";
	exit;
	}
setsockopt(MAIN, SOL_SOCKET, SO_REUSEADDR, pack("l", 1));
while(1) {
	$port++;
	last if (bind(MAIN, sockaddr_in($port, INADDR_ANY)));
	}
listen(MAIN, SOMAXCONN);
if (open(RANDOM, "/dev/urandom")) {
	local $tmpsid;
	read(RANDOM, $tmpsid, 16);
	$sid = lc(unpack('h*', $tmpsid));
	close RANDOM;
	}
else {
	$sid = time()*$$;
	}
print "1 $port $sid\n";

# Fork and listen for calls ..
$pid = fork();
if ($pid < 0) {
	die "fork() failed : $!";
	}
elsif ($pid) {
	exit;
	}
untie(*STDIN);
untie(*STDOUT);

# Accept the TCP connection
$acptaddr = accept(SOCK, MAIN);
die "accept failed!" if (!$acptaddr);
select(SOCK); $| = 1;

while(1) {
	# Wait for the request
	local $rmask;
	vec($rmask, fileno(SOCK), 1) = 1;
	local $sel = select($rmask, undef, undef, 30);
	last if ($sel <= 0);

	local $line = <SOCK>;
	last if (!$line);
	local ($len, $auth) = split(/\s+/, $line);
	die "Invalid session ID" if ($auth ne $sid);
	local $rawarg;
	while(length($rawarg) < $len) {
		local $got;
		local $rv = read(SOCK, $got, $len - length($rawarg));
		exit if ($rv <= 0);
		$rawarg .= $got;
		}
	local $arg = &unserialise_variable($rawarg);

	# Process it
	local $rawrv;
	if ($arg->{'action'} eq 'ping') {
		# Just respond with an OK
		$rawrv = &serialise_variable( { 'status' => 1 } );
		}
	elsif ($arg->{'action'} eq 'check') {
		# Check if some module is supported
		$rawrv = &serialise_variable(
			{ 'status' => 1,
			  'rv' => &foreign_check($arg->{'module'}) } );
		}
	elsif ($arg->{'action'} eq 'config') {
		# Get the config for some module
		local %config = &foreign_config($arg->{'module'});
		$rawrv = &serialise_variable(
			{ 'status' => 1, 'rv' => \%config } );
		}
	elsif ($arg->{'action'} eq 'write') {
		# Transfer data to a local temp file
		local $file = $arg->{'file'} ? $arg->{'file'} : &tempname();
		open(FILE, ">$file");
		print FILE $arg->{'data'};
		close(FILE);
		$rawrv = &serialise_variable(
			{ 'status' => 1, 'rv' => $file } );
		}
	elsif ($arg->{'action'} eq 'read') {
		# Transfer data from a file
		local ($data, $got);
		open(FILE, $arg->{'file'});
		while(read(FILE, $got, 1024) > 0) {
			$data .= $got;
			}
		close(FILE);
		$rawrv = &serialise_variable(
			{ 'status' => 1, 'rv' => $data } );
		}
	elsif ($arg->{'action'} eq 'require') {
		# require a library
		&foreign_require($arg->{'module'},
				 $arg->{'file'});
		$rawrv = &serialise_variable( { 'status' => 1 });
		}
	elsif ($arg->{'action'} eq 'call') {
		# execute a function
		local @rv = &foreign_call($arg->{'module'},
				    $arg->{'func'},
				    @{$arg->{'args'}});
		if (@rv == 1) {
			$rawrv = &serialise_variable(
				{ 'status' => 1, 'rv' => $rv[0] } );
			}
		else {
			$rawrv = &serialise_variable(
				{ 'status' => 1, 'arv' => \@rv } );
			}
		}
	elsif ($arg->{'action'} eq 'eval') {
		# eval some perl code
		local $rv;
		if ($arg->{'module'}) {
			chdir($arg->{'module'});
			$rv = eval "package $arg->{'module'};\n".
				   $arg->{'code'}."\n";
			chdir("..");
			}
		else {
			$rv = eval $arg->{'code'};
			}
		$rawrv = &serialise_variable(
			{ 'status' => 1, 'rv' => $rv } );
		}
	elsif ($arg->{'action'} eq 'quit') {
		$rawrv = &serialise_variable( { 'status' => 1 } );
		}
	else {
		$rawrv = &serialise_variable( { 'status' => 0 } );
		}

	# Send back to the client
	print SOCK length($rawrv),"\n";
	print SOCK $rawrv;
	last if ($arg->{'action'} eq 'quit');
	}

