#include <qptrlist.h>
#include "ctxparameter.h"
class WDDEntries
{
    private:
    QString displayName;
    QPtrList<CtxParameter>*parameters;
    int sessionTimeOut;
    bool enaWelcome;
    bool enaErrors;
    QStringList *welcomeFiles;
    QMap<QString, QString> *errorPages;
    public:
    WDDEntries()
    {
	displayName="";
	parameters=new QPtrList<CtxParameter>;
	sessionTimeOut=30;
	enaWelcome=false;
	enaErrors=false;
	welcomeFiles=new QStringList;
	errorPages=new QMap<QString,QString>;
    }
    WDDEntries(const QString displayName, QPtrList<CtxParameter>*params, int sessionTimeOut=30):displayName(displayName),parameters(params),sessionTimeOut(sessionTimeOut)
    {
	enaWelcome=false;
	enaErrors=false;
	welcomeFiles=new QStringList;
	errorPages=new QMap<QString,QString>;
    }
    virtual ~WDDEntries()
    {
	delete parameters;
    }
    QString getDisplayName()
    {
	return this->displayName;
    }
    QPtrList<CtxParameter> *getParameters()
    {
	return this->parameters;
    }
    int getSessionTimeOut()
    {
	return this->sessionTimeOut;
    }
    void setSessionTimeOut(int sessionTimeout)
    {
	this->sessionTimeOut=sessionTimeout;
    }
    void setDisplayName(const QString displayName)
    {
	this->displayName=displayName;
    }
    void setParameters(QPtrList<CtxParameter>*params)
    {
	this->parameters=params;
    }
    QStringList* getWelcomeFiles()
    {
	return welcomeFiles;
    }
    QMap<QString, QString>* getErrorPages()
    {
	return errorPages;
    }
    void setEnaWelcome(bool flag)
    {
	enaWelcome=flag;
    }
    void setEnaErrorPages(bool flag)
    {
	enaErrors=flag;
    }
    bool getEnaWelcome()
    {
	return enaWelcome;
    }
    bool getEnaErrorPages()
    {
	return enaErrors;
    }
};
