/*
 * MFString.h
 *
 * Copyright (C) 1999 Stephen F. White
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#ifndef _MFSTRING_H
#define _MFSTRING_H

#ifndef _FIELDVALUE_H
#include "FieldValue.h"
#endif

class ElementList;

class MFString : public MFieldValue {
public:
			MFString();
			MFString(const MFString &string);
			MFString(MyString *value);
			MFString(MyString value);
                        MFString(StringArray *values);
    virtual	       ~MFString();

    virtual int         getType() const { return MFSTRING; }
    virtual const char *getTypeName() const { return "MFString"; }
    virtual int         write(int filedes, int indent) const;
//    virtual int	  writeCC(int filedes, char* variableName) const;
    virtual bool	equals(const FieldValue *value) const;
    virtual FieldValue *copy();

    virtual int		getSFSize() const { return _value.size(); }
    virtual FieldValue *getSFValue(int index) const;
    virtual void	setSFValue(int index, FieldValue *value);
    virtual void	setSFValue(int index, const char* value);

    const MyString     *getValues() const { return _value.getData(); }
    MyString		getValue(int i) const { return _value[i]; }
    int			getSize() const { return _value.size(); }
    void		setValue(int index, MyString value) 
                           { _value[index] = value; }

    virtual void        insertSFValue(int index, FieldValue *value);
    virtual void        insertSFValue(int index, const char* value);
    virtual void        removeSFValue(int index) { _value.remove(index); }

    MyString	        getEcmaScriptComment(MyString name, int flags) const;

    bool                isAnimateable() const { return false; }

private:
    StringArray	       _value;
};

#endif // _MFSTRING_H
