/*
 * NodeNurbsPositionInterpolator.h
 *
 * Copyright (C) 1999 Stephen F. White, 2004 J. "MUFTI" Scheurich
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#ifndef _NODE_NURBS_POSITION_INTERPOLATOR_H
#define _NODE_NURBS_POSITION_INTERPOLATOR_H

#ifndef _PROTO_MACROS_H
#include "ProtoMacros.h"
#endif
#ifndef _PROTO_H
#include "Proto.h"
#endif
#include "NodeNurbsCurve.h"

#include "SFMFTypes.h"

class Mesh;

class ProtoNurbsPositionInterpolator : public Proto {
public:
		    ProtoNurbsPositionInterpolator(Scene *scene);
    virtual Node   *create(Scene *scene);
    FieldIndex      dimension;
    FieldIndex      keyValue;
    FieldIndex      keyWeight;
    FieldIndex      knot;
    FieldIndex      order;
};

class NodeNurbsPositionInterpolator : public Node {
public:
		    NodeNurbsPositionInterpolator(Scene *scene, Proto *proto);
		    ~NodeNurbsPositionInterpolator();
    virtual int	    getType() const { return NODE_NURBS_POSITION_INTERPOLATOR; }
    virtual Node   *copy() const { return new NodeNurbsPositionInterpolator(*this); }

    int		    getNodeClass() const 
                       { 
                       return INTERPOLATOR_NODE | CHILD_NODE; 
                       }

    virtual void    draw();
    virtual void    drawHandles();

    virtual Vec3f   getHandle(int handle, int *constraint, int *field);
    virtual void    setHandle(int handle, const Vec3f &v);

    virtual void    setField(int index, FieldValue *value);

    virtual void    flip(int index);

    virtual bool    writeEXTERNPROTO(int filedes);
    int		    write(int filedes, int indent);

    void            createNurbsCurve();

    virtual Node   *toNurbsCurve(void);

    fieldMacros(SFInt32, dimension,         ProtoNurbsPositionInterpolator)
    fieldMacros(MFVec3f, keyValue,          ProtoNurbsPositionInterpolator)
    fieldMacros(MFDouble,keyWeight,         ProtoNurbsPositionInterpolator)
    fieldMacros(MFDouble,knot,              ProtoNurbsPositionInterpolator)
    fieldMacros(SFInt32, order,             ProtoNurbsPositionInterpolator)
protected:
    NodeNurbsCurve *_nurbsCurve;
    bool            _nurbsCurveDirty;
    Array<float>    _chain;
};
#endif // _NODE_NURBS_POSITION_INTERPOLATOR_H
