/*
 * NodePointSet.cpp
 *
 * Copyright (C) 1999 Stephen F. White
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include "stdafx.h"

#include "NodePointSet.h"
#include "Proto.h"
#include "FieldValue.h"
#include "SFNode.h"
#include "NodeColor.h"
#include "NodeCoordinate.h"
#include "DuneApp.h"
#include "Util.h"

ProtoPointSet::ProtoPointSet(Scene *scene)
  : Proto(scene, "PointSet")
{
    color.set(
          addExposedField(SFNODE, "color", new SFNode(NULL), NODE_COLOR));
    coord.set(
          addExposedField(SFNODE, "coord", new SFNode(NULL), NODE_COORDINATE));
}

Node *
ProtoPointSet::create(Scene *scene)
{ 
    return new NodePointSet(scene, this); 
}

NodePointSet::NodePointSet(Scene *scene, Proto *def)
  : Node(scene, def)
{
}

void
NodePointSet::draw()
{
    Node       *coord = ((SFNode *) getField(coord_Index(),true))->getValue();
    MFColor    *colors = NULL;
    int		colorSize = 0;
    float       pointSize = TheApp->GetPointSetSize();

    glPushAttrib(GL_ENABLE_BIT);
    glDisable(GL_LIGHTING);
    glDisable(GL_TEXTURE_2D);
    if (pointSize == 0.0) {
        glEnable(GL_POINT_SMOOTH);
        glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
        glEnable(GL_BLEND);
        glPointSize(1.0);
    } else {
        glDisable(GL_POINT_SMOOTH);
        glPointSize(pointSize);
    }
    if (color()->getValue()) {
        if (color()->getValue()->getType() == NODE_COLOR) {
	    colors = ((NodeColor *)(color()->getValue()))->color();
	    colorSize = colors->getSFSize();
        }
    }
    if (colors == NULL) {
	float	    c[4];
	glGetMaterialfv(GL_FRONT, GL_EMISSION, c);
	Util::myGlColor4fv(c);
    }

    if (!coord || ((NodeCoordinate *) coord)->point()->getType() != MFVEC3F)
	return;

    MFVec3f    *coords = ((NodeCoordinate *) coord)->point();
    int		coordSize = coords->getSFSize();

    glBegin(GL_POINTS);
    for (int i = 0; i < coordSize; i++) {
	if (i < colorSize)
	    Util::myGlColor3fv(colors->getValue(i));
	glVertex3fv(coords->getValue(i));
    }
    glEnd();
    glEnable(GL_LIGHTING);
    glPopAttrib();
}


Vec3f
NodePointSet::getMinBoundingBox(void)
{
    Vec3f ret(0, 0, 0);
    Node *coord = ((SFNode *) getField(coord_Index(),true))->getValue();
    if (coord != NULL) {
        MFVec3f *coords = ((NodeCoordinate *)coord)->point();
        if (coords != NULL)
            ret = coords->getMinBoundingBox();
   }
   return ret;
}

Vec3f
NodePointSet::getMaxBoundingBox(void)
{
    Vec3f ret(0, 0, 0);
    Node *coord = ((SFNode *) getField(coord_Index(),true))->getValue();
    if (coord != NULL) {
        MFVec3f *coords = ((NodeCoordinate *)coord)->point();
        if (coords != NULL)
            ret = coords->getMaxBoundingBox();
   }
   return ret;
}

void
NodePointSet::flip(int index)
{
    NodeCoordinate *ncoord = (NodeCoordinate *)coord()->getValue();
    if (ncoord)
        if (ncoord->getType() == NODE_COORDINATE) {
	    MFVec3f *coords = ncoord->point();
            if (coords != NULL)
                coords->flip(index);
        }
}

