/*
 * SFVec3f.h
 *
 * Copyright (C) 1999 Stephen F. White
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#ifndef _SFVEC3F_H
#define _SFVEC3F_H

#ifndef _FIELDVALUE_H
#include "FieldValue.h"
#endif
#ifndef _VEC3F_H
#include "Vec3f.h"
#endif

class SFVec3f : public FieldValue {
public:
			SFVec3f(float x, float y, float z);
			SFVec3f(const Vec3f &value);
			SFVec3f(void);  // silly default

    virtual int         getType() const { return SFVEC3F; }
    virtual const char *getTypeName() const { return "SFVec3f"; }
    virtual int	        write(int filedes, int indent) const;
//    virtual int		writeCC(int filedes, char* variableName) const;
    virtual bool	equals(const FieldValue *value) const;
    virtual FieldValue *copy() { return new SFVec3f(*this); }
    
    const float	       *getValue() const { return _value; }
    float		getValue(int pos) const { return _value[pos]; }
    void		setValue(int index, float value);
    void		setValue(float v1, float v2, float v3);
    virtual void	clamp(const FieldValue *min, const FieldValue *max);

    MyString	        getEcmaScriptComment(MyString name, int flags) const;

    bool                isAnimateable() const { return true; }
    bool                hasAnimationSupport() { return true; }
    void		flip(int index) { _value[index] *= -1.0; }
    void 		scale(float scale1, float scale2, float scale3);
	void        scale(float* mult);
    void 		translate(float* v);
    void 		rotate(float* rot);

private:
    float		_value[3];
};

#endif // _SFVEC3F_H
