/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.BufferedReader;
import java.io.OutputStream;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.vecmath.Matrix3f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.api.Interface;
import org.jmol.api.JmolAdapter;
import org.jmol.api.JmolViewer;
import org.jmol.api.SymmetryInterface;
import org.jmol.util.BitSetUtil;
import org.jmol.util.Logger;
import org.jmol.util.Parser;
import org.jmol.util.Quaternion;

public abstract class AtomSetCollectionReader {
    public static final float ANGSTROMS_PER_BOHR = 0.5291772f;
    protected AtomSetCollection atomSetCollection;
    protected BufferedReader reader;
    protected String readerName;
    public Hashtable htParams;
    protected String parameterData;
    public String line;
    public String prevline;
    protected int[] next = new int[1];
    protected long ptLine;
    public int[] latticeCells;
    public boolean doProcessLines;
    public boolean iHaveUnitCell;
    public boolean iHaveSymmetryOperators;
    protected boolean doApplySymmetry;
    protected boolean ignoreFileSymmetryOperators;
    protected boolean isTrajectory;
    protected boolean applySymmetryToBonds;
    protected boolean needToApplySymmetry;
    protected boolean getHeader;
    protected int templateAtomCount;
    public int modelNumber;
    protected int vibrationNumber;
    public int desiredVibrationNumber = Integer.MIN_VALUE;
    protected BitSet bsModels;
    protected BitSet bsFilter;
    protected String filter;
    protected boolean haveAtomFilter;
    protected String spaceGroup;
    protected boolean havePartialChargeFilter;
    public String calculationType = "?";
    private boolean iHaveFractionalCoordinates;
    private boolean doPackUnitCell;
    private boolean doConvertToFractional;
    private boolean fileCoordinatesAreFractional;
    protected boolean ignoreFileUnitCell;
    protected boolean ignoreFileSpaceGroupName;
    private float symmetryRange;
    protected float[] notionalUnitCell;
    private int[] firstLastStep;
    protected int desiredModelNumber = Integer.MIN_VALUE;
    private int lastModelNumber = Integer.MAX_VALUE;
    private int desiredSpaceGroupIndex = -1;
    protected SymmetryInterface symmetry;
    protected OutputStream os;
    public boolean continuing = true;
    protected JmolViewer viewer;
    public boolean haveModel;
    private String previousSpaceGroup;
    private float[] previousUnitCell;
    private int nMatrixElements = 0;
    private Matrix3f matrixRotate;
    private String previousScript;

    public Object readData(String string, Hashtable hashtable, BufferedReader bufferedReader) throws Exception {
        this.initialize(hashtable);
        this.readAtomSetCollection(bufferedReader);
        bufferedReader.close();
        return this.finalize(hashtable, string);
    }

    protected Object readData(String string, Hashtable hashtable, Object object) {
        this.initialize(hashtable);
        this.readAtomSetCollectionFromDOM(object);
        return this.finalize(hashtable, string);
    }

    public void readAtomSetCollectionFromDOM(Object object) {
    }

    public final void readAtomSetCollection(BufferedReader bufferedReader) {
        this.reader = bufferedReader;
        this.atomSetCollection = new AtomSetCollection(this.readerName, this);
        try {
            this.initializeReader();
            if (this.continuing) {
                this.readLine();
            }
            while (this.line != null && this.continuing) {
                if (!this.checkLine()) continue;
                this.readLine();
            }
            this.finalizeReader();
        }
        catch (Exception exception) {
            this.setError(exception);
        }
    }

    protected void initializeReader() throws Exception {
    }

    protected boolean checkLine() throws Exception {
        return true;
    }

    public boolean checkLastModel() {
        if (this.isLastModel(this.modelNumber) && this.doProcessLines) {
            this.continuing = false;
            return false;
        }
        this.doProcessLines = false;
        return true;
    }

    public boolean isLastModel(int n) {
        return this.desiredModelNumber > 0 || n >= this.lastModelNumber;
    }

    public boolean doGetVibration(int n) {
        return this.desiredVibrationNumber <= 0 || n == this.desiredVibrationNumber;
    }

    protected void finalizeReader() throws Exception {
        this.applySymmetryAndSetTrajectory();
    }

    private Object finalize(Hashtable hashtable, String string) {
        String string2;
        String string3;
        if (!hashtable.containsKey("templateAtomCount")) {
            hashtable.put("templateAtomCount", new Integer(this.atomSetCollection.getAtomCount()));
        }
        if (hashtable.containsKey("bsFilter")) {
            hashtable.put("filteredAtomCount", new Integer(BitSetUtil.cardinalityOf((BitSet)hashtable.get("bsFilter"))));
        }
        if (!this.calculationType.equals("?")) {
            this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("calculationType", this.calculationType);
        }
        if ((string3 = (string2 = this.atomSetCollection.getFileTypeName())).indexOf("(") >= 0) {
            string3 = string3.substring(0, string3.indexOf("("));
        }
        int n = this.atomSetCollection.getAtomSetCount();
        while (--n >= 0) {
            this.atomSetCollection.setAtomSetAuxiliaryInfo("fileName", string, n);
            this.atomSetCollection.setAtomSetAuxiliaryInfo("fileType", string3, n);
        }
        this.atomSetCollection.freeze();
        if (this.atomSetCollection.errorMessage != null) {
            return this.atomSetCollection.errorMessage + "\nfor file " + string + "\ntype " + string2;
        }
        if (this.atomSetCollection.getAtomCount() == 0) {
            return "No atoms found\nfor file " + string + "\ntype " + string2;
        }
        return this.atomSetCollection;
    }

    private void setError(Exception exception) {
        exception.printStackTrace();
        this.atomSetCollection.errorMessage = this.line == null ? "Unexpected end of file after line " + --this.ptLine + ":\n" + this.prevline : "Error reading file at line " + this.ptLine + ":\n" + this.line + "\n" + exception.getMessage();
    }

    private void initialize(Hashtable hashtable) {
        Object object;
        this.initializeSymmetry();
        this.htParams = hashtable;
        this.viewer = (JmolViewer)hashtable.get("viewer");
        hashtable.remove("viewer");
        this.getHeader = hashtable.containsKey("getHeader");
        this.readerName = (String)hashtable.get("readerName");
        this.parameterData = (String)hashtable.get("parameterData");
        if (hashtable.containsKey("vibrationNumber")) {
            this.desiredVibrationNumber = (Integer)hashtable.get("vibrationNumber");
        } else if (hashtable.containsKey("modelNumber")) {
            this.desiredModelNumber = (Integer)hashtable.get("modelNumber");
        }
        this.applySymmetryToBonds = hashtable.containsKey("applySymmetryToBonds");
        this.filter = (String)hashtable.get("filter");
        this.haveAtomFilter = this.filter != null && (this.filter.indexOf(".") >= 0 || this.filter.indexOf("[") >= 0 || this.filter.indexOf(":") >= 0 || this.filter.toUpperCase().indexOf("BIOMOLECULE") >= 0);
        this.havePartialChargeFilter = this.filter != null && this.filter.toLowerCase().indexOf("charge=") >= 0;
        this.bsFilter = (BitSet)hashtable.get("bsFilter");
        if (this.bsFilter == null && this.filter != null) {
            this.bsFilter = new BitSet();
            hashtable.put("bsFilter", this.bsFilter);
            this.filter = (";" + this.filter + ";").replace(',', ';');
            Logger.info("filtering with " + this.filter);
        }
        int n = hashtable.containsKey("ptFile") ? (Integer)hashtable.get("ptFile") : -1;
        this.isTrajectory = hashtable.containsKey("isTrajectory");
        if (n > 0 && hashtable.containsKey("firstLastSteps")) {
            object = ((Vector)hashtable.get("firstLastSteps")).elementAt(n - 1);
            if (object instanceof BitSet) {
                this.bsModels = (BitSet)object;
            } else {
                this.firstLastStep = (int[])object;
            }
            this.templateAtomCount = (Integer)hashtable.get("templateAtomCount");
        } else if (hashtable.containsKey("firstLastStep")) {
            this.firstLastStep = (int[])hashtable.get("firstLastStep");
        } else if (hashtable.containsKey("bsModels")) {
            this.isTrajectory = hashtable.containsKey("isTrajectory");
            this.bsModels = (BitSet)hashtable.get("bsModels");
        }
        if (this.bsModels != null || this.firstLastStep != null) {
            this.desiredModelNumber = Integer.MIN_VALUE;
        }
        if (this.bsModels == null && this.firstLastStep != null) {
            if (this.firstLastStep[0] < 0) {
                this.firstLastStep[0] = 0;
            }
            if (this.firstLastStep[2] == 0 || this.firstLastStep[1] < this.firstLastStep[0]) {
                this.firstLastStep[1] = -1;
            }
            if (this.firstLastStep[2] < 1) {
                this.firstLastStep[2] = 1;
            }
            this.bsModels = new BitSet();
            this.bsModels.set(this.firstLastStep[0]);
            if (this.firstLastStep[1] > this.firstLastStep[0]) {
                for (int i = this.firstLastStep[0]; i <= this.firstLastStep[1]; i += this.firstLastStep[2]) {
                    this.bsModels.set(i);
                }
            }
        }
        if (this.bsModels != null && (this.firstLastStep == null || this.firstLastStep[1] != -1)) {
            this.lastModelNumber = this.bsModels.length();
        }
        this.symmetryRange = hashtable.containsKey("symmetryRange") ? ((Float)hashtable.get("symmetryRange")).floatValue() : 0.0f;
        this.latticeCells = new int[3];
        if (hashtable.containsKey("lattice")) {
            object = (Point3f)hashtable.get("lattice");
            this.latticeCells[0] = (int)((Point3f)object).x;
            this.latticeCells[1] = (int)((Point3f)object).y;
            this.latticeCells[2] = (int)((Point3f)object).z;
            this.doPackUnitCell = hashtable.containsKey("packed") || this.latticeCells[2] < 0;
        }
        boolean bl = this.doApplySymmetry = this.latticeCells[0] > 0 && this.latticeCells[1] > 0;
        if (!this.doApplySymmetry) {
            this.latticeCells[0] = 0;
            this.latticeCells[1] = 0;
            this.latticeCells[2] = 0;
        }
        if (hashtable.containsKey("spaceGroupIndex")) {
            this.desiredSpaceGroupIndex = (Integer)hashtable.get("spaceGroupIndex");
            if (this.desiredSpaceGroupIndex == -2) {
                this.spaceGroup = (String)hashtable.get("spaceGroupName");
            }
            this.ignoreFileSpaceGroupName = this.desiredSpaceGroupIndex == -2 || this.desiredSpaceGroupIndex >= 0;
            boolean bl2 = this.ignoreFileSymmetryOperators = this.desiredSpaceGroupIndex != -1;
        }
        if (hashtable.containsKey("unitcell")) {
            object = (float[])hashtable.get("unitcell");
            this.setUnitCell((float)object[0], (float)object[1], (float)object[2], (float)object[3], (float)object[4], (float)object[5]);
            this.ignoreFileUnitCell = this.iHaveUnitCell;
        }
        if (hashtable.containsKey("OutputStream")) {
            this.os = (OutputStream)hashtable.get("OutputStream");
        }
    }

    public boolean doGetModel(int n) {
        boolean bl;
        boolean bl2 = this.bsModels == null ? this.desiredModelNumber < 1 || n == this.desiredModelNumber : (n > this.lastModelNumber ? false : (bl = n > 0 && this.bsModels.get(n - 1) || this.haveModel && this.firstLastStep != null && this.firstLastStep[1] < 0 && (this.firstLastStep[2] < 2 || (n - 1 - this.firstLastStep[0]) % this.firstLastStep[2] == 0)));
        if (bl && this.desiredModelNumber == 0) {
            this.atomSetCollection.discardPreviousAtoms();
        }
        this.haveModel |= bl;
        if (bl) {
            this.doProcessLines = true;
        }
        return bl;
    }

    protected void initializeSymmetry() {
        this.previousSpaceGroup = this.spaceGroup;
        this.previousUnitCell = this.notionalUnitCell;
        this.iHaveUnitCell = this.ignoreFileUnitCell;
        if (!this.ignoreFileUnitCell) {
            this.notionalUnitCell = new float[22];
            int n = 22;
            while (--n >= 0) {
                this.notionalUnitCell[n] = Float.NaN;
            }
            this.symmetry = null;
        }
        if (!this.ignoreFileSpaceGroupName) {
            this.spaceGroup = "unspecified *";
        }
        this.needToApplySymmetry = false;
    }

    protected void newAtomSet(String string) {
        if (this.atomSetCollection.getCurrentAtomSetIndex() >= 0) {
            this.atomSetCollection.newAtomSet();
            this.atomSetCollection.setCollectionName("<collection of " + (this.atomSetCollection.getCurrentAtomSetIndex() + 1) + " models>");
        } else {
            this.atomSetCollection.setCollectionName(string);
        }
        Logger.debug(string);
    }

    protected int cloneLastAtomSet(int n) throws Exception {
        this.applySymmetryAndSetTrajectory();
        int n2 = this.atomSetCollection.getLastAtomSetAtomCount();
        this.atomSetCollection.cloneLastAtomSet(n);
        if (this.atomSetCollection.haveUnitCell) {
            this.iHaveUnitCell = true;
            this.needToApplySymmetry = true;
            this.spaceGroup = this.previousSpaceGroup;
            this.notionalUnitCell = this.previousUnitCell;
        }
        return n2;
    }

    public void setSpaceGroupName(String string) {
        if (this.ignoreFileSpaceGroupName) {
            return;
        }
        this.spaceGroup = string.trim();
        Logger.info("Setting space group name to " + this.spaceGroup);
    }

    public void setSymmetryOperator(String string) {
        if (this.ignoreFileSymmetryOperators) {
            return;
        }
        this.atomSetCollection.setLatticeCells(this.latticeCells, this.applySymmetryToBonds, this.doPackUnitCell);
        if (!this.atomSetCollection.addSpaceGroupOperation(string)) {
            Logger.warn("Skipping symmetry operation " + string);
        }
        this.iHaveSymmetryOperators = true;
    }

    private void initializeCartesianToFractional() {
        int n;
        for (n = 0; n < 16; ++n) {
            if (Float.isNaN(this.notionalUnitCell[6 + n])) continue;
            return;
        }
        for (n = 0; n < 16; ++n) {
            this.notionalUnitCell[6 + n] = n % 5 == 0 ? 1 : 0;
        }
        this.nMatrixElements = 0;
    }

    public void clearLatticeParameters() {
        if (this.ignoreFileUnitCell) {
            return;
        }
        for (int i = 6; i < this.notionalUnitCell.length; ++i) {
            this.notionalUnitCell[i] = Float.NaN;
        }
        this.checkUnitCell(6);
    }

    public void setUnitCellItem(int n, float f) {
        if (this.ignoreFileUnitCell) {
            return;
        }
        if (n == 0 && f == 1.0f || n == 3 && f == 0.0f) {
            return;
        }
        if (!Float.isNaN(f) && n >= 6 && Float.isNaN(this.notionalUnitCell[6])) {
            this.initializeCartesianToFractional();
        }
        this.notionalUnitCell[n] = f;
        if (Logger.debugging) {
            Logger.debug("setunitcellitem " + n + " " + f);
        }
        if (n < 6 || Float.isNaN(f)) {
            this.iHaveUnitCell = this.checkUnitCell(6);
        } else if (++this.nMatrixElements == 12) {
            this.checkUnitCell(22);
        }
    }

    public void setUnitCell(float f, float f2, float f3, float f4, float f5, float f6) {
        if (this.ignoreFileUnitCell) {
            return;
        }
        if (f != 1.0f) {
            this.notionalUnitCell[0] = f;
        }
        this.notionalUnitCell[1] = f2;
        this.notionalUnitCell[2] = f3;
        if (f4 != 0.0f) {
            this.notionalUnitCell[3] = f4;
        }
        if (f5 != 0.0f) {
            this.notionalUnitCell[4] = f5;
        }
        if (f6 != 0.0f) {
            this.notionalUnitCell[5] = f6;
        }
        this.iHaveUnitCell = this.checkUnitCell(6);
    }

    public void addPrimitiveLatticeVector(int n, float[] fArray) {
        n = 6 + n * 3;
        this.notionalUnitCell[n++] = fArray[0];
        this.notionalUnitCell[n++] = fArray[1];
        this.notionalUnitCell[n++] = fArray[2];
        this.checkUnitCell(15);
    }

    private boolean checkUnitCell(int n) {
        for (int i = 0; i < n; ++i) {
            if (!Float.isNaN(this.notionalUnitCell[i])) continue;
            return false;
        }
        this.getSymmetry().setUnitCell(this.notionalUnitCell);
        if (this.doApplySymmetry) {
            this.doConvertToFractional = !this.fileCoordinatesAreFractional;
        }
        return true;
    }

    protected SymmetryInterface getSymmetry() {
        this.symmetry = (SymmetryInterface)Interface.getOptionInterface("symmetry.Symmetry");
        return this.symmetry;
    }

    public void setFractionalCoordinates(boolean bl) {
        this.iHaveFractionalCoordinates = this.fileCoordinatesAreFractional = bl;
    }

    protected boolean filterAtom(Atom atom) {
        return !this.haveAtomFilter || this.filterAtom(atom, this.atomSetCollection.getAtomCount());
    }

    protected boolean filterAtom(Atom atom, int n) {
        boolean bl;
        block5: {
            block6: {
                String string;
                block4: {
                    bl = false;
                    if (atom.group3 == null) break block4;
                    string = "[" + atom.group3.toUpperCase() + "]";
                    if (this.filter.indexOf("![") < 0 ? this.filter.indexOf("[") >= 0 && this.filter.toUpperCase().indexOf(string) < 0 : this.filter.toUpperCase().indexOf(string) >= 0) break block5;
                }
                if (atom.atomName == null) break block6;
                string = "." + atom.atomName.toUpperCase() + ";";
                if (this.filter.indexOf("!.") < 0 ? this.filter.indexOf("*.") >= 0 && this.filter.toUpperCase().indexOf(string) < 0 : this.filter.toUpperCase().indexOf(string) >= 0) break block5;
            }
            if (!(this.filter.indexOf("!:") >= 0 ? this.filter.indexOf(":" + atom.chainID) >= 0 : this.filter.indexOf(":") >= 0 && this.filter.indexOf(":" + atom.chainID) < 0)) {
                bl = true;
            }
        }
        this.bsFilter.set(n, bl);
        return bl;
    }

    public void setAtomCoord(Atom atom, float f, float f2, float f3) {
        atom.set(f, f2, f3);
        this.setAtomCoord(atom);
    }

    public void setAtomCoord(Atom atom) {
        if (this.doConvertToFractional && !this.fileCoordinatesAreFractional && this.symmetry != null) {
            this.symmetry.toFractional(atom);
            this.iHaveFractionalCoordinates = true;
        }
        this.needToApplySymmetry = true;
    }

    protected void addSites(Hashtable hashtable) {
        this.atomSetCollection.setAtomSetAuxiliaryInfo("pdbSites", hashtable);
        Enumeration enumeration = hashtable.keys();
        String string = "";
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            Hashtable hashtable2 = (Hashtable)hashtable.get(string2);
            int n = string2.length();
            while (--n >= 0) {
                char c = string2.charAt(n);
                if (Character.isLetterOrDigit(c) || c == '\'') continue;
                string2 = string2.substring(0, n) + "_" + string2.substring(n + 1);
            }
            String string3 = (String)hashtable2.get("seqNum");
            String string4 = (String)hashtable2.get("groups");
            if (string4.length() == 0) continue;
            this.addJmolScript("@site_" + string2 + " " + string4);
            this.addJmolScript("@" + string3 + " " + string4);
            this.addJmolScript("site_" + string2 + " = \"" + string4 + "\".split(\",\")");
            string = string + (string == "" ? "" : ",") + "site_" + string2;
        }
        this.addJmolScript("site_list = \"" + string + "\".split(\",\")");
    }

    public void applySymmetryAndSetTrajectory() throws Exception {
        if (this.needToApplySymmetry && this.iHaveUnitCell) {
            this.atomSetCollection.setCoordinatesAreFractional(this.iHaveFractionalCoordinates);
            this.atomSetCollection.setNotionalUnitCell(this.notionalUnitCell);
            this.atomSetCollection.setAtomSetSpaceGroupName(this.spaceGroup);
            this.atomSetCollection.setSymmetryRange(this.symmetryRange);
            if (this.doConvertToFractional || this.fileCoordinatesAreFractional) {
                this.atomSetCollection.setLatticeCells(this.latticeCells, this.applySymmetryToBonds, this.doPackUnitCell);
                if (this.ignoreFileSpaceGroupName || !this.iHaveSymmetryOperators) {
                    if (this.createSpaceGroup()) {
                        this.atomSetCollection.setAtomSetSpaceGroupName(this.symmetry.getSpaceGroupName());
                        this.atomSetCollection.applySymmetry(this.symmetry);
                    }
                } else {
                    this.atomSetCollection.applySymmetry();
                }
            }
        }
        if (this.isTrajectory) {
            this.atomSetCollection.setTrajectory();
        }
        this.initializeSymmetry();
    }

    protected boolean createSpaceGroup() {
        return this.getSymmetry().createSpaceGroup(this.desiredSpaceGroupIndex, this.spaceGroup.indexOf("*") >= 0 ? "P1" : this.spaceGroup, this.notionalUnitCell, this.atomSetCollection.doNormalize);
    }

    public void setMOData(Hashtable hashtable) {
        this.atomSetCollection.setAtomSetAuxiliaryInfo("moData", hashtable);
        Vector vector = (Vector)hashtable.get("mos");
        if (vector != null) {
            Logger.info(vector.size() + " molecular orbitals read in model " + this.modelNumber);
        }
    }

    public void setTransform(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        if (this.matrixRotate != null) {
            return;
        }
        this.matrixRotate = new Matrix3f();
        Vector3f vector3f = new Vector3f();
        vector3f.set(f, f2, f3);
        vector3f.normalize();
        this.matrixRotate.setColumn(0, vector3f);
        vector3f.set(f4, f5, f6);
        vector3f.normalize();
        this.matrixRotate.setColumn(1, vector3f);
        vector3f.set(f7, f8, f9);
        vector3f.normalize();
        this.matrixRotate.setColumn(2, vector3f);
        this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("defaultOrientationMatrix", new Matrix3f(this.matrixRotate));
        Quaternion quaternion = new Quaternion(this.matrixRotate);
        this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("defaultOrientationQuaternion", quaternion);
        Logger.info("defaultOrientationMatrix = " + this.matrixRotate);
    }

    public static String getElementSymbol(int n) {
        return JmolAdapter.getElementSymbol(n);
    }

    protected void fillDataBlock(String[][] stringArray, int n, int n2) throws Exception {
        if (n2 == 0) {
            this.fillDataBlock(stringArray);
            return;
        }
        int n3 = stringArray.length;
        for (int i = 0; i < n3; ++i) {
            this.discardLinesUntilNonBlank();
            int n4 = (this.line.length() - n) / n2;
            stringArray[i] = new String[n4];
            int n5 = 0;
            int n6 = n;
            while (n5 < n4) {
                stringArray[i][n5] = this.line.substring(n6, n6 + n2);
                ++n5;
                n6 += n2;
            }
        }
    }

    protected void fillDataBlock(String[][] stringArray) throws Exception {
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            stringArray[i] = AtomSetCollectionReader.getTokens(this.discardLinesUntilNonBlank());
        }
    }

    protected void fillFloatArray(float[] fArray) throws Exception {
        String[] stringArray = new String[]{};
        int n = 0;
        for (int i = 0; i < fArray.length; ++i) {
            while (stringArray != null && n >= stringArray.length) {
                stringArray = AtomSetCollectionReader.getTokens(this.readLine());
                n = 0;
            }
            if (stringArray == null) break;
            fArray[i] = this.parseFloat(stringArray[n++]);
        }
    }

    protected void fillFrequencyData(int n, int n2, int n3, boolean[] blArray, boolean bl, int n4, int n5, int[] nArray) throws Exception {
        boolean bl2;
        boolean bl3 = bl2 = n3 != n2;
        if (nArray != null) {
            n2 = nArray.length;
        }
        int n6 = bl ? n2 : n2 * 3;
        int n7 = blArray.length;
        String[][] stringArray = new String[n6][];
        this.fillDataBlock(stringArray, n4, n5);
        int n8 = 0;
        int n9 = 0;
        while (n8 < n6) {
            String[] stringArray2 = stringArray[n8];
            String[] stringArray3 = bl ? null : stringArray[++n8];
            String[] stringArray4 = bl ? null : stringArray[++n8];
            int n10 = stringArray2.length - (bl ? n7 * 3 : n7) - 1;
            for (int i = 0; i < n7; ++i) {
                int n11;
                String string;
                if ((string = stringArray2[++n10]).charAt(0) == ')') {
                    string = string.substring(1);
                }
                float f = this.parseFloat(string);
                float f2 = this.parseFloat(bl ? stringArray2[++n10] : stringArray3[n10]);
                float f3 = this.parseFloat(bl ? stringArray2[++n10] : stringArray4[n10]);
                if (blArray[i]) continue;
                int n12 = n11 = nArray == null ? n9 : nArray[n9];
                if (n11 < 0) continue;
                if (Logger.debugging) {
                    Logger.debug("vib " + n11 + "/" + i + ": " + f + " " + f2 + " " + f3);
                }
                this.atomSetCollection.addVibrationVector(n + n3 * i + n11, f, f2, f3, bl2);
            }
            ++n8;
            ++n9;
        }
    }

    protected void discardLines(int n) throws Exception {
        int n2 = n;
        while (--n2 >= 0) {
            this.readLine();
        }
    }

    protected String discardLinesUntilStartsWith(String string) throws Exception {
        while (this.readLine() != null && !this.line.startsWith(string)) {
        }
        return this.line;
    }

    protected String discardLinesUntilContains(String string) throws Exception {
        while (this.readLine() != null && this.line.indexOf(string) < 0) {
        }
        return this.line;
    }

    protected void discardLinesUntilBlank() throws Exception {
        while (this.readLine() != null && this.line.trim().length() != 0) {
        }
    }

    protected String discardLinesUntilNonBlank() throws Exception {
        while (this.readLine() != null && this.line.trim().length() == 0) {
        }
        return this.line;
    }

    protected void checkLineForScript(String string) {
        this.line = string;
        this.checkLineForScript();
    }

    public void checkLineForScript() {
        int n;
        if (this.line.indexOf("Jmol PDB-encoded data") >= 0) {
            this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("jmolData", "" + this.line);
        }
        if (this.line.endsWith("#noautobond")) {
            this.line = this.line.substring(0, this.line.lastIndexOf(35)).trim();
            this.atomSetCollection.setNoAutoBond();
        }
        if ((n = this.line.indexOf("jmolscript:")) >= 0) {
            String string = this.line.substring(n + 11, this.line.length());
            if (string.indexOf("#") >= 0) {
                string = string.substring(0, string.indexOf("#"));
            }
            this.addJmolScript(string);
            this.line = this.line.substring(0, n).trim();
        }
    }

    protected void addJmolScript(String string) {
        Logger.info("#jmolScript: " + string);
        if (this.previousScript == null) {
            this.previousScript = "";
        } else if (!this.previousScript.endsWith(";")) {
            this.previousScript = this.previousScript + ";";
        }
        this.previousScript = this.previousScript + string;
        this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("jmolscript", this.previousScript);
    }

    public String readLine() throws Exception {
        this.prevline = this.line;
        this.line = this.reader.readLine();
        if (this.os != null && this.line != null) {
            this.os.write(this.line.getBytes());
            this.os.write(10);
        }
        ++this.ptLine;
        if (Logger.debugging) {
            Logger.debug(this.line);
        }
        return this.line;
    }

    protected static final String[] getStrings(String string, int n, int n2) {
        String[] stringArray = new String[n];
        int n3 = 0;
        int n4 = 0;
        while (n3 < n) {
            stringArray[n3] = string.substring(n4, n4 + n2);
            ++n3;
            n4 += n2;
        }
        return stringArray;
    }

    protected String[] getTokens() {
        return Parser.getTokens(this.line);
    }

    protected static void getTokensFloat(String string, float[] fArray, int n) {
        Parser.parseFloatArray(AtomSetCollectionReader.getTokens(string), fArray, n);
    }

    public static String[] getTokens(String string) {
        return Parser.getTokens(string);
    }

    protected static String[] getTokens(String string, int n) {
        return Parser.getTokens(string, n);
    }

    protected float parseFloat() {
        return Parser.parseFloat(this.line, this.next);
    }

    public float parseFloat(String string) {
        this.next[0] = 0;
        return Parser.parseFloat(string, this.next);
    }

    protected float parseFloat(String string, int n, int n2) {
        this.next[0] = n;
        return Parser.parseFloat(string, n2, this.next);
    }

    protected int parseInt() {
        return Parser.parseInt(this.line, this.next);
    }

    public int parseInt(String string) {
        this.next[0] = 0;
        return Parser.parseInt(string, this.next);
    }

    protected int parseInt(String string, int n) {
        this.next[0] = n;
        return Parser.parseInt(string, this.next);
    }

    protected int parseInt(String string, int n, int n2) {
        this.next[0] = n;
        return Parser.parseInt(string, n2, this.next);
    }

    protected String parseToken() {
        return Parser.parseToken(this.line, this.next);
    }

    protected String parseToken(String string) {
        this.next[0] = 0;
        return Parser.parseToken(string, this.next);
    }

    protected String parseTokenNext(String string) {
        return Parser.parseToken(string, this.next);
    }

    protected String parseToken(String string, int n, int n2) {
        this.next[0] = n;
        return Parser.parseToken(string, n2, this.next);
    }

    protected static String parseTrimmed(String string, int n) {
        return Parser.parseTrimmed(string, n);
    }

    protected static String parseTrimmed(String string, int n, int n2) {
        return Parser.parseTrimmed(string, n, n2);
    }
}

