/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.jmol.util.Logger;

public class BinaryDocument {
    protected DataInputStream stream;
    protected boolean isRandom = false;
    protected boolean isBigEndian = true;
    long nBytes;
    OutputStream os;

    public void close() {
        try {
            this.stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.os != null) {
            try {
                this.os.flush();
                this.os.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void setStream(BufferedInputStream bufferedInputStream, boolean bl) {
        if (bufferedInputStream == null) {
            return;
        }
        this.stream = new DataInputStream(bufferedInputStream);
        this.isBigEndian = bl;
    }

    public void setStream(DataInputStream dataInputStream) {
        this.stream = dataInputStream;
    }

    public void setRandom(boolean bl) {
        this.isRandom = bl;
    }

    public byte readByte() throws Exception {
        ++this.nBytes;
        return this.ioReadByte();
    }

    private byte ioReadByte() throws Exception {
        byte by = this.stream.readByte();
        if (this.os != null) {
            this.os.write(by);
        }
        return by;
    }

    public int readByteArray(byte[] byArray) throws IOException {
        int n = this.ioRead(byArray);
        this.nBytes += (long)n;
        return n;
    }

    private int ioRead(byte[] byArray) throws IOException {
        int n = this.stream.read(byArray);
        if (n > 0 && this.os != null) {
            this.os.write(byArray, 0, n);
        }
        return n;
    }

    public void readByteArray(byte[] byArray, int n, int n2) throws Exception {
        this.nBytes += this.ioRead(byArray, n, n2);
    }

    private long ioRead(byte[] byArray, int n, int n2) throws Exception {
        int n3 = this.stream.read(byArray, n, n2);
        if (n3 > 0 && this.os != null) {
            this.os.write(byArray, n, n3);
        }
        return n3;
    }

    public String readString(int n) throws Exception {
        byte[] byArray = new byte[n];
        this.readByteArray(byArray);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append((char)byArray[i]);
        }
        return stringBuffer.toString();
    }

    public short readShort() throws Exception {
        this.nBytes += 2L;
        return this.isBigEndian ? this.ioReadShort() : (short)(this.ioReadByte() & 0xFF | (this.ioReadByte() & 0xFF) << 8);
    }

    private short ioReadShort() throws Exception {
        short s = this.stream.readShort();
        if (this.os != null) {
            this.os.write(s);
        }
        return s;
    }

    public int readInt() throws Exception {
        this.nBytes += 4L;
        return this.isBigEndian ? this.ioReadInt() : this.readLEInt();
    }

    private int ioReadInt() throws Exception {
        int n = this.stream.readInt();
        if (this.os != null) {
            this.writeInt(n);
        }
        return n;
    }

    private void writeInt(int n) throws Exception {
        this.os.write((byte)(n >> 24 & 0xFF));
        this.os.write((byte)(n >> 16 & 0xFF));
        this.os.write((byte)(n >> 8 & 0xFF));
        this.os.write((byte)(n & 0xFF));
    }

    public int readUnsignedShort() throws Exception {
        this.nBytes += 2L;
        int n = this.ioReadByte() & 0xFF;
        int n2 = this.ioReadByte() & 0xFF;
        return this.isBigEndian ? (n << 8) + n2 : (n2 << 8) + n;
    }

    public long readLong() throws Exception {
        this.nBytes += 8L;
        return this.isBigEndian ? this.ioReadLong() : (long)this.ioReadByte() & 0xFFL | ((long)this.ioReadByte() & 0xFFL) << 8 | ((long)this.ioReadByte() & 0xFFL) << 16 | ((long)this.ioReadByte() & 0xFFL) << 24 | ((long)this.ioReadByte() & 0xFFL) << 32 | ((long)this.ioReadByte() & 0xFFL) << 40 | ((long)this.ioReadByte() & 0xFFL) << 48 | ((long)this.ioReadByte() & 0xFFL) << 54;
    }

    private long ioReadLong() throws Exception {
        long l = this.stream.readLong();
        if (this.os != null) {
            this.writeLong(l);
        }
        return l;
    }

    private void writeLong(long l) throws Exception {
        this.writeInt((int)(l >> 32 & 0xFFFFFFFFL));
        this.writeInt((int)(l & 0xFFFFFFFFL));
    }

    public float readFloat() throws Exception {
        this.nBytes += 4L;
        return this.isBigEndian ? this.ioReadFloat() : Float.intBitsToFloat(this.readLEInt());
    }

    private float ioReadFloat() throws Exception {
        float f = this.stream.readFloat();
        if (this.os != null) {
            this.os.write(Float.floatToIntBits(f));
        }
        return f;
    }

    public double readDouble() throws Exception {
        this.nBytes += 8L;
        return this.isBigEndian ? this.ioReadDouble() : Double.longBitsToDouble(this.readLELong());
    }

    private double ioReadDouble() throws Exception {
        double d = this.stream.readDouble();
        if (this.os != null) {
            this.writeLong(Double.doubleToRawLongBits(d));
        }
        return d;
    }

    private int readLEInt() throws Exception {
        return this.ioReadByte() & 0xFF | (this.ioReadByte() & 0xFF) << 8 | (this.ioReadByte() & 0xFF) << 16 | (this.ioReadByte() & 0xFF) << 24;
    }

    private long readLELong() throws Exception {
        return (long)this.ioReadByte() & 0xFFL | ((long)this.ioReadByte() & 0xFFL) << 8 | ((long)this.ioReadByte() & 0xFFL) << 16 | ((long)this.ioReadByte() & 0xFFL) << 24 | ((long)this.ioReadByte() & 0xFFL) << 32 | ((long)this.ioReadByte() & 0xFFL) << 40 | ((long)this.ioReadByte() & 0xFFL) << 48 | ((long)this.ioReadByte() & 0xFFL) << 56;
    }

    public void seek(long l) {
        try {
            if (l == this.nBytes) {
                return;
            }
            if (l < this.nBytes) {
                this.stream.reset();
                this.nBytes = 0L;
            } else {
                l -= this.nBytes;
            }
            this.stream.skipBytes((int)l);
            this.nBytes += l;
        }
        catch (Exception exception) {
            Logger.error(null, exception);
        }
    }

    public long getPosition() {
        return this.nBytes;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.os = outputStream;
    }
}

