/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.export;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.SystemFlavorMap;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.freehep.util.export.ExportFileType;

public class VectorGraphicsTransferable
implements ClipboardOwner,
Transferable {
    private Component component;
    private DataFlavor imageFlavor = new DataFlavor("image/x-java-image; class=java.awt.Image", "Image");
    private Map types = new HashMap();
    private static Map defaultTypes;

    public VectorGraphicsTransferable(Component component) {
        this(component, true);
    }

    public VectorGraphicsTransferable(Component component, boolean bl2) {
        this.component = component;
        if (bl2) {
            this.addDefaultFileTypes();
        }
    }

    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (dataFlavor.match(this.imageFlavor)) {
            Image image = this.component.createImage(this.component.getWidth(), this.component.getHeight());
            Graphics graphics = image.getGraphics();
            this.component.print(graphics);
            graphics.dispose();
            return image;
        }
        ExportFileType exportFileType = (ExportFileType)this.types.get(dataFlavor);
        if (exportFileType != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            exportFileType.exportToFile((OutputStream)byteArrayOutputStream, this.component, this.component, null, this.component.getName());
            byteArrayOutputStream.close();
            return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] dataFlavorArray = new DataFlavor[this.types.size() + 1];
        this.types.keySet().toArray(dataFlavorArray);
        dataFlavorArray[this.types.size()] = this.imageFlavor;
        return dataFlavorArray;
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        if (dataFlavor.match(this.imageFlavor)) {
            return true;
        }
        return this.types.containsKey(dataFlavor);
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    public void addExportFileType(DataFlavor dataFlavor, ExportFileType exportFileType) {
        this.types.put(dataFlavor, exportFileType);
    }

    private void addDefaultFileTypes() {
        if (defaultTypes == null) {
            defaultTypes = VectorGraphicsTransferable.createDefaultTypes();
        }
        this.types.putAll(defaultTypes);
    }

    private static Map createDefaultTypes() {
        HashMap hashMap = new HashMap();
        VectorGraphicsTransferable.addType(hashMap, "ENHMETAFILE", "image/emf", "Enhanced Meta File", "org.freehep.graphicsio.emf.EMFExportFileType");
        return hashMap;
    }

    private static void addType(Map map, String string, String string2, String string3, String string4) {
        try {
            DataFlavor dataFlavor = new DataFlavor(string2, string3);
            SystemFlavorMap systemFlavorMap = (SystemFlavorMap)SystemFlavorMap.getDefaultFlavorMap();
            systemFlavorMap.addUnencodedNativeForFlavor(dataFlavor, string);
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Class<?> clazz = classLoader == null ? Class.forName(string4) : classLoader.loadClass(string4);
            ExportFileType exportFileType = (ExportFileType)clazz.newInstance();
            map.put(dataFlavor, exportFileType);
        }
        catch (Throwable throwable) {
            System.err.println("Unable to install flavor for mime type '" + string2 + "' (this is expected if not using JDK 1.4)");
        }
    }
}

