/*
 *  icons.c:		Some nice XPM icons
 *
 *  Written by:		Ullrich Hafner
 *  
 *  Copyright (C) 1998 Ullrich Hafner <hafner@bigfoot.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 */

/*
 *  $Date: 1999/03/12 13:33:05 $
 *  $Author: hafner $
 *  $Revision: 1.21 $
 *  $State: Exp $
 */

#define _ICONS_C

#include <stdio.h>

#include "config.h"

#include "misc.h"
#include "icons.h"

#include "error.h"

/*******************************************************************************

		     global variables (from window.c)
  
*******************************************************************************/

extern GtkWidget *main_window;

/*******************************************************************************

			     local variables
  
*******************************************************************************/

/* XPM */
static char *info_xpm[] = {
/* columns rows colors chars-per-pixel */
"37 37 48 1",
"  c Gray0",
". c #101028",
"X c #101828",
"o c #181828",
"O c #101830",
"+ c #181830",
"@ c #182038",
"# c #182041",
"$ c #202049",
"% c #202849",
"& c #202859",
"* c #283449",
"= c #383c59",
"- c #283061",
"; c #303871",
": c #304179",
"> c #414961",
", c #494d61",
"< c #515569",
"1 c #595d79",
"2 c #697579",
"3 c #384586",
"4 c #38418e",
"5 c #38498e",
"6 c #41498e",
"7 c #41518e",
"8 c #49598e",
"9 c #415196",
"0 c #495196",
"q c #495996",
"w c #515d96",
"e c #59619e",
"r c #697196",
"t c #797da6",
"y c #868696",
"u c #868aae",
"i c #9692a6",
"p c #c7c3c7",
"a c #c7cbcf",
"s c #cfcbdf",
"d c #d7d3d7",
"f c #d7d7df",
"g c #dfdbdf",
"h c #e7e3e7",
"j c #efebef",
"k c #f7f3f7",
"l c #fffbff",
"z c None",
/* pixels */
"zzzzzzzzzzzzzz211>>>>1rrzzzzzzzzzzzzz",
"zzzzzzzzzzzz++.++#&&&&$$%,,zzzzzzzzzz",
"zzzzzzzzzzOO&&;444455555533=<zzzzzzzz",
"zzzzzzzz=OOO&&;444455555533=<<zzzzzzz",
"zzzzzz**.&&:444wwfjgge555666331zzzzzz",
"zzzzz#OO-444444ffhpppi::666666611zzzz",
"zzzzz#OO-444444ffhpppi::666666611zzzz",
"zzz**O;;4444444jjppppa@@666666677tzzz",
"zz<..-444444445ssppaayXX6666667777zzz",
"zz<..-444444445ssppaayXX6666667777zzz",
"zz+$$4444444555eeiayy@@@6666777777rrz",
"z<.;;444444555555:@XX@::666777777900z",
"z<.;;444444555555:@XX@::666777777900z",
"**$44444455ejjjjjjjkkk66677777799000u",
"OO-44444555e33.aaaddddXX777777900000w",
"OO-44444555e33.aaaddddXX777777900000w",
"..:444555555336jjddddgXX7777990000000",
"OO4445555555666kkddgggXX7779000000000",
"##4555555556666kkdggggXX7990000000000",
"##4555555556666kkdggggXX7990000000000",
"##5555555666666kkgggghXX900000000000q",
"++5555556666666kkgghhhXX0000000000qqq",
"++5555556666666kkgghhhXX0000000000qqq",
"##5555666666666kkghhhhXX000000000qqqt",
"<<:556666666667kkhhhhhXX0000000qqqqqz",
"<<:556666666667kkhhhhhXX0000000qqqqqz",
"zz%666666666777kkhhhhjXX000000qqqqqqz",
"zz,666666667777kkhhjjjXX0000qqqqqqzzz",
"zz,666666667777kkhhjjjXX0000qqqqqqzzz",
"zzz;;6666777777kkjjjjjXX000qqqqqqezzz",
"zzzyy8667777kkkkkjjkkkkklqqqqqqeezzzz",
"zzzzy8667777kkkkkjjkkkkklqqqqqqeezzzz",
"zzzzzr88777799XXXXXXXXoooooqqqezzzzzz",
"zzzzzzzzw7790000000000qqqqqqrrzzzzzzz",
"zzzzzzzzz7790000000000qqqqqqrrzzzzzzz",
"zzzzzzzzzzzw000000000qqqqeezzzzzzzzzz",
"zzzzzzzzzzzzzzzttt0ttuzzzzzzzzzzzzzzz"
};

/* XPM */
static char *warning_xpm[] = {
/* columns rows colors chars-per-pixel */
"57 57 4 1",
"  c Gray0",
". c #fb1041",
"X c Gray100",
"o c None",
/* pixels */
"oooooooooooooooooooooooooooo oooooooooooooooooooooooooooo",
"ooooooooooooooooooooooooooo . ooooooooooooooooooooooooooo",
"ooooooooooooooooooooooooooo . ooooooooooooooooooooooooooo",
"oooooooooooooooooooooooooo ... oooooooooooooooooooooooooo",
"oooooooooooooooooooooooooo ... oooooooooooooooooooooooooo",
"ooooooooooooooooooooooooo ..... ooooooooooooooooooooooooo",
"ooooooooooooooooooooooooo ..... ooooooooooooooooooooooooo",
"oooooooooooooooooooooooo ....... oooooooooooooooooooooooo",
"oooooooooooooooooooooooo ....... oooooooooooooooooooooooo",
"ooooooooooooooooooooooo ......... ooooooooooooooooooooooo",
"ooooooooooooooooooooooo ......... ooooooooooooooooooooooo",
"oooooooooooooooooooooo ........... oooooooooooooooooooooo",
"oooooooooooooooooooooo ..... ..... oooooooooooooooooooooo",
"ooooooooooooooooooooo ..... X ..... ooooooooooooooooooooo",
"ooooooooooooooooooooo ..... X ..... ooooooooooooooooooooo",
"oooooooooooooooooooo ..... XXX ..... oooooooooooooooooooo",
"oooooooooooooooooooo ..... XXX ..... oooooooooooooooooooo",
"ooooooooooooooooooo ..... XXXXX ..... ooooooooooooooooooo",
"ooooooooooooooooooo ..... XXXXX ..... ooooooooooooooooooo",
"oooooooooooooooooo ..... XXXXXXX ..... oooooooooooooooooo",
"oooooooooooooooooo ..... XXXXXXX ..... oooooooooooooooooo",
"ooooooooooooooooo ..... XXXXXXXXX ..... ooooooooooooooooo",
"ooooooooooooooooo ..... XXXXXXXXX ..... ooooooooooooooooo",
"oooooooooooooooo ..... XXXX   XXXX ..... oooooooooooooooo",
"oooooooooooooooo ..... XXX     XXX ..... oooooooooooooooo",
"ooooooooooooooo ..... XXXX     XXXX ..... ooooooooooooooo",
"ooooooooooooooo ..... XXXX     XXXX ..... ooooooooooooooo",
"oooooooooooooo ..... XXXXX     XXXXX ..... oooooooooooooo",
"oooooooooooooo ..... XXXXX     XXXXX ..... oooooooooooooo",
"ooooooooooooo ..... XXXXXX     XXXXXX ..... ooooooooooooo",
"ooooooooooooo ..... XXXXXX     XXXXXX ..... ooooooooooooo",
"oooooooooooo ..... XXXXXXX     XXXXXXX ..... oooooooooooo",
"oooooooooooo ..... XXXXXXX     XXXXXXX ..... oooooooooooo",
"ooooooooooo ..... XXXXXXXX     XXXXXXXX ..... ooooooooooo",
"ooooooooooo ..... XXXXXXXXX   XXXXXXXXX ..... ooooooooooo",
"oooooooooo ..... XXXXXXXXXX   XXXXXXXXXX ..... oooooooooo",
"oooooooooo ..... XXXXXXXXXX   XXXXXXXXXX ..... oooooooooo",
"ooooooooo ..... XXXXXXXXXXX   XXXXXXXXXXX ..... ooooooooo",
"ooooooooo ..... XXXXXXXXXXX   XXXXXXXXXXX ..... ooooooooo",
"oooooooo ..... XXXXXXXXXXXX   XXXXXXXXXXXX ..... oooooooo",
"oooooooo ..... XXXXXXXXXXXXXXXXXXXXXXXXXXX ..... oooooooo",
"ooooooo ..... XXXXXXXXXXXXXXXXXXXXXXXXXXXXX ..... ooooooo",
"ooooooo ..... XXXXXXXXXXXXX   XXXXXXXXXXXXX ..... ooooooo",
"oooooo ..... XXXXXXXXXXXXXX   XXXXXXXXXXXXXX ..... oooooo",
"oooooo ..... XXXXXXXXXXXXXX   XXXXXXXXXXXXXX ..... oooooo",
"ooooo ..... XXXXXXXXXXXXXXX   XXXXXXXXXXXXXXX ..... ooooo",
"ooooo ..... XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX ..... ooooo",
"oooo ..... XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX ..... oooo",
"oooo ..... XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX ..... oooo",
"ooo ..... XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX ..... ooo",
"ooo .....                                       ..... ooo",
"oo ................................................... oo",
"oo ................................................... oo",
"o ..................................................... o",
"o ..................................................... o",
" ....................................................... ",
"                                                         "
};

/* XPM */
static char *question_xpm[] = {
/* columns rows colors chars-per-pixel */
"54 54 4 1",
"  c Gray0",
". c #5151fb",
"X c Gray100",
"o c None",
/* pixels */
"oooooooooooooooooooooo          oooooooooooooooooooooo",
"oooooooooooooooooo    ..........    oooooooooooooooooo",
"oooooooooooooooo  ..................  oooooooooooooooo",
"oooooooooooooo  ......................  oooooooooooooo",
"oooooooooooo  ..........................  oooooooooooo",
"ooooooooooo .............................. ooooooooooo",
"oooooooooo ................................ oooooooooo",
"ooooooooo .................................. ooooooooo",
"oooooooo .................................... oooooooo",
"ooooooo ...................................... ooooooo",
"oooooo ........................................ oooooo",
"ooooo ..................      .................. ooooo",
"oooo .................  XXXXXX  ................. oooo",
"oooo ................ XXXXXXXXXX ................ oooo",
"ooo ................ XXXXXXXXXXXX ................ ooo",
"ooo ............... XXXXXXXXXXXXXX ............... ooo",
"oo ............... XXXXXX    XXXXXX ............... oo",
"oo ............... XXXXX .... XXXXX ............... oo",
"o ............... XXXXX ...... XXXXX ............... o",
"o ............... XXXX ........ XXXX ............... o",
"o ................ XX ......... XXXX ............... o",
"o ................    ......... XXXX ............... o",
" .............................. XXXX ................ ",
" ............................. XXXXX ................ ",
" ............................ XXXXX ................. ",
" ........................... XXXXXX ................. ",
" .......................... XXXXXX .................. ",
" ......................... XXXXXX ................... ",
" ........................ XXXXXX .................... ",
" ....................... XXXXXX ..................... ",
" ....................... XXXXX ...................... ",
" ....................... XXXX ....................... ",
"o ...................... XXXX ...................... o",
"o ...................... XXXX ...................... o",
"o ...................... XXXX ...................... o",
"o ...................... XXXX ...................... o",
"oo ......................    ...................... oo",
"oo ................................................ oo",
"ooo .............................................. ooo",
"ooo .....................    ..................... ooo",
"oooo ................... XXXX ................... oooo",
"oooo ................... XXXX ................... oooo",
"ooooo .................. XXXX .................. ooooo",
"oooooo ................. XXXX ................. oooooo",
"ooooooo .................    ................. ooooooo",
"oooooooo .................................... oooooooo",
"ooooooooo .................................. ooooooooo",
"oooooooooo ................................ oooooooooo",
"ooooooooooo .............................. ooooooooooo",
"oooooooooooo  ..........................  oooooooooooo",
"oooooooooooooo  ......................  oooooooooooooo",
"oooooooooooooooo  ..................  oooooooooooooooo",
"oooooooooooooooooo    ..........    oooooooooooooooooo",
"oooooooooooooooooooooo          oooooooooooooooooooooo"
};

/* XPM */
static char *kill_xpm [] = {
"43 44 5 1",
" 	c None",
".	c #EFBEEFBEEFBE",
"X	c #514451445144",
"o	c #9E79A2899E79",
"O	c #000000000000",
"   ...XX                           ....oX  ",
"  ...oXO                           ...oXXo ",
" ..oXXOO       XOOOOOOOOO          ..XXoOXo",
"..oXXOOX     XOOXXXOXOXOOOOX       .XXOXoOX",
"..oXXX.X   XOOXXXXXXXXXXOOOOOX    X..oXooXO",
".oXOX...X XOXXXXoXoXoXoXoOXOOOX  Xo..oOXXOO",
"oXOOXoo.XXOXXoXoXoXoooXoXoOXOOOOXo..ooXOOO ",
"XOOXOXooOOXXoXoXoooooooXoXXOXOOOXooooXOXo  ",
"XX  XOXXOXXoX.o...o.o.o.XoOXOXOOOXXoXOX    ",
"     XOOXXoX.o...o.o.o.o.XoOXOXOOOXXOX     ",
"      XOXoXoo.....o.o.o.o.XoOXOXOOXOX      ",
"      OXoXoX.......o.....o.XXOXOOOOX       ",
"      XXXoX.........o.....ooOXOXOOO        ",
"      OXoX.o.......o.....o.XXOXOOOO        ",
"      XXXoo...............ooOXOXOOO        ",
"      OXoX.o.....o.o.o.oX.XXXOXOOOO        ",
"      XOXXXo......o.o.o......oOOOOO        ",
"      OXoo.........o.o....XXXXXOOOX        ",
"      oXooXOOOOOXXo..ooXOOOOOOXoOOX        ",
"      XX.XOOOOOOOX..ooXOOOOOOOOoOO         ",
"      Xo.XOOOOOOOOo..XXOOOOOOOOXOO         ",
"      o..OOOOOOOOO..OXXXOOOOOOOXOO         ",
"      Xo.OOOOOOOOX.OOOXXOOOOOOXXOX         ",
"       X..OOOOOXo..OOOXXXXOOOOoOOX         ",
"       OX.o.o.o...XOOOOXOXXoXoOXO          ",
"        Oo.o.o.o..OOOOOXXOXXoXXOX          ",
"        OXo..o....OOOOOXOXOoXXOOX          ",
"         OXOX.....oOOOXXXOXOOOOO           ",
"         XoXO.o.....ooXoXXXXOXO            ",
"         XX.O.O.o...oXoXXOXOOOOX           ",
"        .Xo.XOOoOoOoOXXOXXOOOXOXX          ",
"       ..XX..XXOXoOoOXOOXOOOXOOOX          ",
"      ..ooXoo.XOoOXOXOXOOXOXOOOOOX         ",
"     ..ooXOX...XoOXOXOXOXOXOXOOOOOX        ",
"    ..ooXOXXXo..o.ooXXXXXXOXOOOOOXOX       ",
" ....ooXOXX XX...o.ooXXOXOXOO XOXoXOX      ",
".....oXOO    Xo.....ooOXOXOOX  XOo.o.XoXOX ",
".....XoO      Xo....oXXOXOOX    XXo.....XOX",
"oo.XX.oXX      OXoooXXOXOOX      XXo..oXoOX",
"XXo...ooO       XOXOXOOOOX        XoooXoXO ",
" oXXo.oXO                          XX.oXOX ",
"  oXXoXOO                          X.oXOX  ",
"   oOOOO                           XoXXX   ",
"     XO                            oXO     "};

/* XPM */
static char *folder_cap_up_xpm[] = {
/* columns rows colors chars-per-pixel */
"33 33 63 1",
"  c #8e8a9e",
". c #8e9a8e",
"X c #9e8a9e",
"o c #8e9a9e",
"O c #b6929e",
"+ c #9eaa9e",
"@ c #fffbff",
"# c #9e9aae",
"$ c #ae9aae",
"% c #a6aaa6",
"& c #aeaaae",
"* c #8e9271",
"= c #9e9a8e",
"- c #be9a96",
"; c Gray0",
": c #614138",
"> c #413041",
", c #efdbcf",
"< c #696161",
"1 c #aeaabe",
"2 c #8e7d8e",
"3 c #303820",
"4 c #494130",
"5 c #c75149",
"6 c #616151",
"7 c #beaaae",
"8 c #a68259",
"9 c #8e8a71",
"0 c #412020",
"q c #aebaae",
"w c #515941",
"e c #381810",
"r c #308a30",
"t c #beaabe",
"y c #384141",
"u c #308e38",
"i c #303859",
"p c #202020",
"a c #9ee39e",
"s c #003000",
"d c #bebabe",
"f c #101800",
"g c #cfb2b6",
"h c #bebaae",
"j c #208a30",
"k c #083410",
"l c #081810",
"z c #001000",
"x c #306930",
"c c #181818",
"v c #aedbb6",
"b c #697d69",
"n c #aebabe",
"m c #100000",
"M c #bebacf",
"N c #416141",
"B c #517d51",
"V c #416949",
"C c #385130",
"Z c #cfbacf",
"A c #417151",
"S c #96aa8e",
"D c #c7cbc7",
/* pixels */
" . .X.XoOoOoOoO+@+#+$+#+$+$%&%&&&",
".*.X.X=X=X=O=-O@;:O$+-+$+$%$%$&&&",
" .X.XoOoOOOO#O@;>;:+#+@@,@<%&&&&1",
"2X.X=X=XOOOOO@;34>;:+$@56O;$&&&7&",
"X.XoOoOoOoO+@;>689>;:+@5-0;&&&1q&",
".X=X=X=O=-O@;3w88883;:-<5<;&&7&7q",
"XoOoOOOO#O@;>68o@O89>;:5O5;&1q1q1",
"=X=XOOOOO@;3;;;050;;;>;:5e;7&&&7&",
"OoOoroO+@;>6;;0;8;0;;9>;:0;q&q1qt",
"=X=Oy-O@;3wO;0305030;883;:;7q7&tq",
"OOOOui@;>pOo:;0;5;0;:O8p>;;q1qtqt",
"OOOasi;3wp=@:;3;5;3;:@9p*>;:&tqtq",
"OoOars>6O9i@855585558@i989>;:qtqd",
"=-O@rfwO=@yg4@@@@@@@4gy@=883;:htq",
"#O@jkikj@@ty:@@@@@@@:yt@@O89>;:qd",
"O@;arlzx@@@y:@@@@@@@:y@@@@=8*>;:h",
"O;urkilsplpcplpcplpcplpcplpc;;;4d",
"Oxaisxsz4:::ccccccccc:::4::;qthdh",
"#arjvszs-bbq:;:4:4:;:Obb1b<;dndnd",
"Orairlym%@6@:;4eee4;:,,<@a6ihthtd",
"$jkakslsu,7%:;:303:;:,7@a6,;dnddd",
"afaryryzs@6@4;:e3e:;4,6<@-6ihdddd",
"#aurvsusu,7@:;:803:;:@,@7<,;ddddM",
"+rslrismsl,-:;4eee4;:a%<%<%idddgd",
"asuakzlszr<,:;:303:;:6,6<@<iddMvM",
"srarsryzsf@a4;:e3e:;4usuyuy;uudgv",
"ususkszskzizkskskskskzkiisizliMvM",
"rlzmzzzmzNNNNNNtqtNNslsmszslzl*gd",
"&BVVezVxk3yxCx7b2V7%aVVVNVVVNV<vZ",
"%wNC3fsksfsCxCCC%w%NNwBwBwBwBwB2v",
"bAwVczCk3kBAw%dq7VNnd%<B<B<B<B<BZ",
".2*2.2.2...=.O.=bbbO.bSO=OSOSOSO+",
"&&1q&q1qtqtqdqdndnddddMvMvMvZvZDD"
};

/* XPM */
static char *latex_xpm[] = {
/* columns rows colors chars-per-pixel */
"33 33 215 2",
"   c #9c9a9c",
".  c #949a8c",
"X  c #94969c",
"o  c #9c9a94",
"O  c #9c9694",
"+  c #9c9e9c",
"@  c #a49e9c",
"#  c #a4a29c",
"$  c #aca6a4",
"%  c #acaaa4",
"&  c #b4aaac",
"*  c #b4aaa4",
"=  c #acaaac",
"-  c #b4b2ac",
";  c #b4aeb4",
":  c #b4b2b4",
">  c #b4b6b4",
",  c #bcbabc",
"<  c #bcbebc",
"1  c #c4c2c4",
"2  c #949294",
"3  c #9c969c",
"4  c #b4aeac",
"5  c #9c928c",
"6  c #c4bebc",
"7  c #948e8c",
"8  c #ccc6c4",
"9  c #847e7c",
"0  c #d4d2cc",
"q  c #bcbab4",
"w  c #a4a6a4",
"e  c #b4bab4",
"r  c #bcb6bc",
"t  c #bcbec4",
"y  c #949694",
"u  c #bcb6b4",
"i  c #6c6664",
"p  c #6c6a64",
"a  c #d4cac4",
"s  c #7c766c",
"d  c #aca2a4",
"f  c #cccac4",
"g  c #8c867c",
"h  c #646264",
"j  c #e4e2dc",
"k  c #acaeb4",
"l  c #a49a94",
"z  c #aca69c",
"x  c #8c8a84",
"c  c #ccc6bc",
"v  c #746e6c",
"b  c #6c665c",
"n  c #8c827c",
"m  c #746a64",
"M  c #bcb2ac",
"N  c #7c7674",
"B  c #747a74",
"V  c #94928c",
"C  c #c4bab4",
"Z  c #7c726c",
"A  c #847a74",
"S  c #948a84",
"D  c #cccecc",
"F  c #a4a2a4",
"G  c #acaeac",
"H  c #746a5c",
"J  c #6c625c",
"K  c #847e74",
"L  c #8c7e74",
"P  c #7c7e7c",
"I  c #8c8a8c",
"U  c #ccced4",
"Y  c #848a7c",
"T  c #a49ea4",
"R  c #c4bec4",
"E  c #746664",
"W  c #948e84",
"Q  c #746e64",
"!  c #847a6c",
"~  c #7c7a74",
"^  c #848284",
"/  c #848684",
"(  c #6c6a6c",
")  c #cccacc",
"_  c #c4c6c4",
"`  c #bcc2bc",
"'  c #84766c",
"]  c #b4b6ac",
"[  c #ac9e9c",
"{  c #645a54",
"}  c #9c8e8c",
"|  c #bcb6ac",
" . c #a49e94",
".. c #848274",
"X. c #8c8e8c",
"o. c #8c8e84",
"O. c #645e64",
"+. c #8c7e7c",
"@. c #6c5e64",
"#. c #64565c",
"$. c #bcb2b4",
"%. c #cccec4",
"&. c #8c9284",
"*. c #84867c",
"=. c #94968c",
"-. c #8c8e7c",
";. c #6c7264",
":. c #c4c2bc",
">. c #746e74",
",. c #a49a9c",
"<. c #a4a69c",
"1. c #bcc2b4",
"2. c #c4c2b4",
"3. c #c4c6bc",
"4. c #acb2a4",
"5. c #949684",
"6. c #94927c",
"7. c #949a84",
"8. c #848674",
"9. c #7c7a6c",
"0. c #949284",
"q. c #bcbeb4",
"w. c #a4a294",
"e. c #84767c",
"r. c #645a64",
"t. c #a49aa4",
"y. c #dcd6cc",
"u. c #bcbaac",
"i. c #ccd2c4",
"p. c #a4aa9c",
"a. c #8c927c",
"s. c #8c8a7c",
"d. c #9c9e8c",
"f. c #9c9e94",
"g. c #a4a694",
"h. c #dcdedc",
"j. c #acae9c",
"k. c #aca6ac",
"l. c #9c9294",
"z. c #747264",
"x. c #74726c",
"c. c #746a6c",
"v. c #8c8284",
"b. c #acaa9c",
"n. c #9c9a8c",
"m. c #8c9274",
"M. c #848a74",
"N. c #7c8274",
"B. c #acaea4",
"V. c #84827c",
"C. c #6c6a5c",
"Z. c #6c6264",
"A. c #b4aea4",
"S. c #7c826c",
"D. c #8c8e74",
"F. c #8c8674",
"G. c #9ca294",
"H. c #aca2ac",
"J. c #7c6e6c",
"K. c #d4cec4",
"L. c #7c7e6c",
"P. c #8c8a74",
"I. c #84866c",
"U. c #646a54",
"Y. c #bcbeac",
"T. c #d4d6d4",
"R. c #7c7264",
"E. c #ccc2bc",
"W. c #7c7664",
"Q. c #74765c",
"!. c #d4d6cc",
"~. c #e4dacc",
"^. c #cccabc",
"/. c #b4aa9c",
"(. c #c4c2ac",
"). c #d4dacc",
"_. c #74766c",
"`. c #aca294",
"'. c #948e7c",
"]. c #b4baac",
"[. c #948a74",
"{. c #9c9684",
"}. c #7c7e74",
"|. c #6c6e64",
" X c #9ca29c",
".X c #bcb2bc",
"XX c #8c826c",
"oX c #847e64",
"OX c #847a7c",
"+X c #847e6c",
"@X c #6c6654",
"#X c #9c968c",
"$X c #ccd2cc",
"%X c #747674",
"&X c #7c827c",
"*X c #8c8274",
"=X c #c4c2cc",
"-X c #c4cac4",
";X c #d4d2d4",
":X c #c4babc",
">X c #aca29c",
",X c #cccad4",
"<X c #ccc6cc",
"1X c #a4aaa4",
"2X c #d4cecc",
"3X c #c4c6cc",
"4X c #dcdadc",
"5X c #747274",
"6X c #8c928c",
"7X c #d4d6dc",
"8X c #646664",
"9X c #d4dad4",
"0X c #7c7a7c",
"qX c #bcbac4",
"wX c #dcd6dc",
/* pixels */
"  .     X o O O o + @ # # $ % & % & * = * = - ; : > > , < < > : 1 ",
"2 3   + + # + o 4 5 * 6 7 4 8 % 9 o 0 q 7 % w = e : r , - t - e , ",
"  X y y   y $ $ u o u q i p a o s d f g h $ j = = > < < k , : , , ",
"y y y 3 o + l z * x 4 c v b u n m l M N s 0 1 B 7 < , > > > > , < ",
"V 2 y + w = > C * v g z Z Z g s p A x N S f 9 h w D = = > ; > < < ",
"2 2   F = G z M $ H b A J Z v A A A K L n 7 P I U 1 Y T < : , t R ",
"  + + F w % E s W Z E Q J Z J b Q Z N A ! ~ ^ o : / ( F ) _ < 1 ` ",
"F F w w = = ~ J A s J J J Q m J H ' s Z ' N 9 / P ( / e < R < 1 1 ",
"+ w = - : ] [ E J E { E ! } M * | C z  .5 ..X.o.^ o.1 D o o ` 1 _ ",
"3   V K Q v O.+.@.#.v W $.4 % 6 q | - ] %.c &.*.Y =.-.;.;.*.> :.%.",
"; u -  ...m >.E #.N ,.d $.$ - - <.4 1.2.3.4.5.6.7.5.8.9.0.q.q.%.0 ",
"T 4 8 8 w.Z e.r.@.t.r ; q $.y.8 u.3.i.q.p.-.a.s.7.d.f.g.q.h.j.1.%.",
"k.l.9 z.x.s c.@.v.& * & 8 :.- b.g.j.j.n.m.M.7.M.&.5.n.. N.9.=.B._ ",
"k.,.V.C.b z.Z.c.t.& @ u 8 A.W ..S.8.D.M.m.7.F.s.G.n.=.&.z.C.. ] %.",
"H.q 8 - x Q i J.[ & M K.q ..F.L.8.P.D.a.I.S.U.Y Y.p.=.z 4.i.G 8 T.",
": 4 @ g s R.v J.$ E.E.c  .W.z.L.5.6.M.M.Q.;...G.%.g.*.o f.q + q.!.",
"3 9 p Q ~ ..R.R.| ~.^./.8.s.F.w.(.g.I.L.S.a.u.2.).b.=.G.~ x._.+ _ ",
"F d $ w.s.R.s `.(./.'.....9.L.0.G.5...N.d.].1.i.!.<.V o Y   < 0 D ",
": 8 8 A.o.! F.[.S P.[.{.6.s...W 0.}.|._.f.3.B.3.3.w G.w  XG - D U ",
".X$ S ~ s ! P.XXoXXXP.F.9.R.8.~ x._.*.# < D %.!.q <.@ o.x V   < ) ",
"= OXp K 0.F.+XXXP.F.R.@XC.z.#Xs./ O > D $X_ !.0 w . V %X&X/   , ) ",
"[   : K.] *X+XF.F.W.H s #X% | u :.1 1 1 =X-Xf _ o + % + u -X, U ;X",
"k.:X8 - s.Q *XL A K 0./.:.f 6 1 R < t 1 D ;X, ] =.V +   = _ ) T.U ",
"; , # Z Q *X5 g *X} >X- q 6 :., u t ) $X,X1 <.+ X.&XV.^ P X ) ) <X",
"$.6 $ V # f z W V.S X.S >X3.8 0 j j T., 1X+ + + B.F G < G D 2XU 3X",
"k : q < :.3._.s 0.&.s.=.o.=.=.&.f.<.. =.# <. Xx.= F / :.4XT.;X;XT.",
"q , > 4.= % |.. ] =.-.G.d.f.n.w.<.j.B.<.d.f.w 5X  6X5X= _ ) T.;X7X",
"> , > : k.w f.f 1.}...w =.-.. f.V =.b.=.}.=.% / , _ G ) ;XD ;X$X7X",
"k > , , e q < 3.o 8Xy 2.X.x.> # P 6X] X.~ > . ^ R h.D 4X;X_ 7X;Xy.",
"> : > , t 1 > q # X.:.1 P i -Xy v y 6 I P 2X= y > ) _ D ;X0 T.T.9X",
"> > : , < 1 t 1 3X, 3X> X.X 1 2 0X= -XX I $XT.1 ) ;X0 7Xh.7X4X;X4X",
"> : > , < 1 , 1 ,X< r t qX;XU : k ,XwX_ R 7XU ;X$X7XT.4X4X_ 4XT.9X",
"> r > > > > 1 t ,X, t wXU 1 3X=X) U ,X7X9X<XU T.D 2X;Xh.h.0 7XT.4X"
};

/* XPM */
static char *undo_cap_up_xpm[] = {
/* columns rows colors chars-per-pixel */
"33 33 88 1",
"  c #888888",
". c #778888",
"X c #889988",
"o c #888899",
"O c #998899",
"+ c #889999",
"@ c Gray60",
"# c #9999aa",
"$ c #99aa99",
"% c #aaaaaa",
"& c #99aaaa",
"* c #aabbaa",
"= c #888877",
"- c #9d838f",
"; c #9f997e",
": c #aa9998",
"> c #aa99aa",
", c #aaaa94",
"< c #bbccbb",
"1 c #e9dde4",
"2 c #eeeeee",
"3 c #aaaabb",
"4 c #ddccd8",
"5 c Gray100",
"6 c #887799",
"7 c #111111",
"8 c #110011",
"9 c #444444",
"0 c #44444e",
"q c #444d3c",
"w c #555555",
"e c #445558",
"r c Gray80",
"t c #666688",
"y c #444466",
"u c #111122",
"i c #000011",
"p c #667777",
"a c #dddddd",
"s c #f3d7d9",
"d c #443366",
"f c #1a2218",
"g c Gray0",
"h c #887788",
"j c #778877",
"k c #ccddc9",
"l c #aa99bb",
"z c #444c86",
"x c #213343",
"c c Gray20",
"v c Gray40",
"b c #62775e",
"n c #776677",
"m c #bbaabb",
"M c #ccbbcc",
"N c #313955",
"B c #110000",
"V c #555566",
"C c #666677",
"Z c #250d19",
"A c #a3b6c3",
"S c #1b1a43",
"D c #222233",
"F c #bbbbbb",
"G c #777777",
"H c #001111",
"J c #c8d9c5",
"K c #9c6e6f",
"L c #223333",
"P c #d9eee0",
"I c #bbbbcc",
"U c #fff6f6",
"Y c #ccbbbb",
"T c #554355",
"R c #333344",
"E c #9988aa",
"W c #334444",
"Q c #222222",
"! c #777788",
"~ c #555577",
"^ c #001100",
"/ c #332244",
"( c #332233",
") c #cdcdcb",
"_ c #bbcccc",
"` c #bbaaaa",
"' c #665566",
"] c #babba9",
/* pixels */
" . X XoXOXO+@+@@@@#$#$#$%$%&%&%*%",
"=- - - OXO;O;O@@@:@:$:$>$>,%,%%%%",
"oXoXoXOXO+@+@@@@#$>$#$>$>&%<121%3",
"   - OXO;O;O@@@:@>$:$>$>,4513678%",
" XoX99999999990q0q0qwqwer2tyyuipO",
" - O94a4a4a4asasasasasa15oydfgwhj",
"oXOX9k@+@@@@#$>$#$>$>&r5lyzxgcvbn",
" OXO94;O@@@:@>$:$>$>,m5MydNB7vvn ",
"OXO+9k@@@@#$#$#$%$%&%21yyyu7Vvv %",
"XO;O94@@@:@:$:$>$>,%<5CdyZgVvv=O,",
"O+@+9k@@#$>$#$>$>&%A5AzySgDjvp@&F",
";O;O94@:@>$:$>$>,%%1adyNguchGO,mF",
"@+@@9k#$#$#$%$%&%&M5tydH7wcX &%FF",
";O@@9sr2JK$>$>,%,m5mydu8qwc>,>FFF",
"@@@@@5a+yLh$>&%%%P1yzxgLwv9r%FFFI",
"@@@mU4ydyDbO,%%%<5CdNi7vvnw4FFFYF",
"@@#kryzyyyu.@&%A5Azy7HVvG wPFFI<I",
"@:@4VdydydDT=@%1adyDgTvv=Ow1FYFY<",
"#$>$R&zyzyN7G M5tydgDvvp@%wPI<I<I",
"@>$: 4ydydyZ9O5myd78vvG %Fw1FYFYF",
"#$#$waEyyyzxcP1yyDgWvv @FFVPI<I<M",
"$:$>q4rdydyde5tdNBQvvn@%FYw1<Y<M<",
"#$>$TPM!zyzyz~zyu^VvG %FI<VPI<M<M",
"$>$>w1%rydydydy/g(vv %FYFYw1FM<M)",
"%$%&wP%atyzyyyd^uvvG@%I<I<VPM<r_r",
"$>,%w1%`FdydydD8wvG %`FY<Yw1<M)r)",
">&%%wGwwFtzyzNg7Qc9wVwVwVw'PM_r_r",
",%%%%1a123ydNu^h O)4a1a1a1P1)M)Mr",
"%&%*%*3*m igg^Rwv 3*I<I<M<r_r_rrr",
",%%%%`%m*>,hGvvv :FY<Y<M<M)r)rrrr",
"%%%%3*m*mA%+ GG o*I<I<M<M_r_rrrrr",
"%%%`%m*m]m]>%@@:%`FYFM<M)M)Mrrr4r",
"%*3*m*mAFAFFF%3*I<I<M<r_r_rrrkrkr"
};

/* XPM */
static char *help_xpm[] = {
/* columns rows colors chars-per-pixel */
"33 33 56 1",
"  c #889988",
". c #888899",
"X c #998899",
"o c #889999",
"O c Gray60",
"+ c #99aa99",
"@ c #9999aa",
"# c #aa99aa",
"$ c #99aaaa",
"% c #aaaaaa",
"& c #9d838f",
"* c #9f997e",
"= c #aa9998",
"- c #aaaa94",
"; c #bbaaaa",
": c #aaaabb",
"> c #aabbaa",
", c #667777",
"< c #555577",
"1 c #44444e",
"2 c #554355",
"3 c #778888",
"4 c #445558",
"5 c #222233",
"6 c #111122",
"7 c #332255",
"8 c #333355",
"9 c #443366",
"0 c #332244",
"q c #444488",
"w c #555566",
"e c #777788",
"r c #42608d",
"t c #dddddd",
"y c #d9eee0",
"u c #eeddee",
"i c #bbaabb",
"p c #ddccdd",
"a c #ddbbcc",
"s c #bbbbbb",
"d c #8888aa",
"f c #bbccbb",
"g c Gray80",
"h c #222244",
"j c #666688",
"k c #aabbbb",
"l c #665566",
"z c #aa99bb",
"x c #eeeeee",
"c c #ecf8fb",
"v c #bbbbaa",
"b c #887788",
"n c #776677",
"m c #bbbbcc",
"M c #fff6f6",
"N c #9988aa",
/* pixels */
" . X XoOoOoOoO+O+@+#+@+#+#$%$%%%%",
"& X X*X*X*O*=OOO=O#+=+#+#-#-#%%%;",
" X XoOoOOOO@OOO@+#+@+#+#$%$%%%%:>",
"X X*X*XOOOOOOO=O#+=+#+#-#-#%%%;%%",
" XoOoOoOoO+O,<121<,#+#$%$%%%%:>%>",
"X*X*X*O*=345657898704 #-#%%%;%;>;",
"oOoOOOO@1559qqqqqqqqq9w%%%%:>:>:>",
"X*XOOOe068qqqrtyurqqqqq<.%;%%%;%i",
"oOoOoe559qqqqptasdqqqqqq<@>%>:>i>",
"X*O*=069qqqqqyafgfhqqqqqqj;>;%i>i",
"OOO@w69qqqqqqpfaf.5qqqqqqq@:>i>ik",
"OOOO68qqqqqqqr@fdhhqqqqqqq<ki>i>i",
"oO+w6qqqqqqqqqqh6hqqqqqlqqqz>i>s>",
"=OO07qqqqqqxxyxcxxqqqqqqqqqdavi>i",
"OOO69qqqqqrq5ggagp5qqqqlq<q<gs>sk",
"OOb5qqqqqqqqqxggpt6qqqqqqqlqg>ivi",
"=Onhqqqqqqqqqxpttt6qqqqqlqqrm>svs",
"+#3hqqqqqqqqqMtttt5lq<qlqlqlgikss",
"#+=5qqqqqqqqqcttuy5qqqlqlrlrg>iss",
"+@+5qqqqqqqqqMtttu5lqlqlqlqntssss",
"=+#4qqqqqqqqqcuyuy6qlqqrlrlkgsssv",
"+#+X8qqqqqqqqMtuyu5lqlqlql<pfssmf",
"#+#-4qqqqqqqqcuyxx5qlrlrlrNg:svsv",
"+#$%39qqqqqlqMyuxx5lqlql<lgasmfmf",
"#-#-#3qqqqqcMcxxxccclrlrlfpkvsvfv",
"$%$%%%eqqqql555555555l<<spsmfmfmf",
"#-#%%%;$qqqqqqlqlrlrlr<fpfvsvsvsa",
"$%%%%:>%>@qlqlqlqlql<:tpsmfmfmfaf",
"#%%%;%;>;%mkddjrjddkggasvsvfvsafa",
"%%%:>:>:>i>isvfatagasssmfmfmfafaf",
"%%;%%%;%i>i>i>ivivisssvsvsvsafafa",
"%:>%>:>i>i>s>skskssssmfmfmfafafgf",
";%;>;%i>ivi>ivsvssssvsvfvsafafafa"
};

/* XPM */
static char *disk_cap_up_xpm[] = {
/* columns rows colors chars-per-pixel */
"33 33 166 2",
"   c #7c7c7c",
".  c Gray49",
"X  c Gray",
"o  c #808080",
"O  c Gray51",
"+  c #838383",
"@  c #848484",
"#  c Gray52",
"$  c #868686",
"%  c Gray53",
"&  c #888888",
"*  c Gray54",
"=  c #8b8b8b",
"-  c Gray55",
";  c #8d8d8d",
":  c #8e8e8e",
">  c Gray56",
",  c #909090",
"<  c Gray57",
"1  c #939393",
"2  c #959595",
"3  c Gray59",
"4  c #979797",
"5  c #989898",
"6  c #9a9a9a",
"7  c Gray61",
"8  c #9d9d9d",
"9  c Gray62",
"0  c #9f9f9f",
"q  c Gray63",
"w  c #818181",
"e  c Gray58",
"r  c #9b9b9b",
"t  c #a2a2a2",
"y  c Gray50",
"u  c Gray0",
"i  c #a0a0a0",
"p  c Gray64",
"a  c #efefef",
"s  c #a4a4a4",
"d  c #00519e",
"f  c #002061",
"g  c #003061",
"h  c #a5a5a5",
"j  c #898989",
"k  c #003051",
"l  c Gray65",
"z  c #005196",
"x  c #a7a7a7",
"c  c #a9a9a9",
"v  c Gray66",
"b  c Gray67",
"n  c #414171",
"m  c #305171",
"M  c #acacac",
"N  c #aaaaaa",
"B  c Gray68",
"V  c #000086",
"C  c #718271",
"Z  c #aeaeae",
"A  c #0000be",
"S  c #0010ef",
"D  c #1010ef",
"F  c #001041",
"G  c #867171",
"H  c Gray69",
"J  c #2010ef",
"K  c #3020ef",
"L  c #101030",
"P  c #dfdfcf",
"I  c #dfefdf",
"U  c #efdfef",
"Y  c #afafaf",
"T  c #000030",
"R  c #1020ef",
"E  c #2010ae",
"W  c #514141",
"Q  c #717161",
"!  c #869286",
"~  c Gray81",
"^  c #b2b2b2",
"/  c #929292",
"(  c #2020ef",
")  c #2030ef",
"_  c #102010",
"`  c #414141",
"'  c Gray19",
"]  c #616151",
"[  c #516151",
"{  c #b1b1b1",
"}  c #3030ef",
"|  c #5141ef",
" . c #4151ef",
".. c #001000",
"X. c #001010",
"o. c #96a2ef",
"O. c #105120",
"+. c #104120",
"@. c #dfdfdf",
"#. c #b4b4b4",
"$. c #5151ef",
"%. c #6171ef",
"&. c #7182ef",
"*. c #9e92ef",
"=. c #aeaeef",
"-. c #bebebe",
";. c #96929e",
":. c #cfdfcf",
">. c Gray71",
",. c #6161ef",
"<. c #7161ef",
"1. c #8671ef",
"2. c #9682ef",
"3. c #9692ef",
"4. c #aebeef",
"5. c #cfbeef",
"6. c #9ea296",
"7. c #717171",
"8. c #aeae9e",
"9. c #dfcfcf",
"0. c Gray70",
"q. c #b6b6b6",
"w. c #aea2ef",
"e. c #bebeef",
"r. c #cfcfef",
"t. c #dfcfef",
"y. c #9ea29e",
"u. c #b7b7b7",
"i. c #5151ae",
"p. c #beaeef",
"a. c #cfdfef",
"s. c #dfefef",
"d. c #203020",
"f. c #9eae9e",
"g. c #b9b9b9",
"h. c Gray60",
"j. c #9ea2ef",
"k. c #9eaeef",
"l. c #becfef",
"z. c #dfdfef",
"x. c #302030",
"c. c #414151",
"v. c #9ea2ae",
"b. c Gray72",
"n. c #aea2ae",
"m. c #bbbbbb",
"M. c #96a296",
"N. c #617161",
"B. c #304130",
"V. c #202030",
"C. c #bcbcbc",
"Z. c #514151",
"A. c #303020",
"S. c Gray73",
"D. c Gray74",
"F. c #868286",
"G. c #867186",
"H. c #413030",
"J. c #415141",
"K. c Gray75",
"L. c #c0c0c0",
"P. c Gray76",
"I. c #c3c3c3",
"U. c #c1c1c1",
"Y. c Gray77",
"T. c #c5c5c5",
/* pixels */
"  . X o o O + @ # $ % & * = - ; : > , < 1 1 2 3 4 5 6 6 7 8 9 0 q ",
". X o w O + @ # $ & & * = - ; > > < < 1 e 2 3 5 5 6 r 7 8 9 0 q t ",
"X y o O O @ # $ u u u u u u u u u u u u u u u u u 6 7 7 9 0 i q p ",
"o o O + @ # $ % u a a a a a a a a a a a a a a a u u 8 9 0 q q p s ",
"w O + @ # $ & & u a a a a a d a d d d d d f g a u a u 0 q t p s h ",
"O O @ # $ % & j u a a a a a a a a a a a a a k a u a a u q p p h l ",
"+ @ # $ % & * = u a a a a a d d z g g g g k g a u u u u u s h l x ",
"@ # $ & & * = - u a a a a a a a a a a a a a a a a a a a u h l x c ",
"# $ % & j = - ; u a a a a a a a a a a a a a a a a a a a u l x v c ",
"$ % & * = - ; : u a a a a a a a a a a a a a a a a a a a u u v c b ",
"& & * = - u > > u a a a a a a a a n m m m n n n m m m a u u c b M ",
"& j = - ; u u u u a a a a a a a a a a a a a a a a a a a u u N M B ",
"* = - ; : > u u V u C a a a a a a a a a a a a a a a a a u u M B Z ",
"= - ; > > < u u u A S D F u u u u u u u u a u u G u a a u u B Z H ",
"- ; : > , < u u u u D J K L P I U a a a a a a a a a a a u u Z Y H ",
"; : > < < 1 e u T R J E W Q ! Z ~ u a a a a a a a a a a u u Y H ^ ",
": > , < / 1 2 u D ( ) _ ` u ' u ] u a u G u a [ a a a a u u H { ^ ",
"> , < 1 1 u R ( } |  .u ..X._ u o.u O.+.@.I a a a a a a u u { ^ #.",
"< < 1 e 2 3 u u | $.%.&.u u *.=.=.u -.;.-.:.a a a a a a u u ^ #.>.",
"< / 1 2 3 4 u u $.,.<.1.2.3.=.4.5.u 6.7.8.9.a a a a a a u u 0.#.q.",
"1 1 2 3 4 5 u u u u 2.*.w.=.e.r.t.u ....y.u [ [ [ u a a u u #.q.u.",
"e 2 3 5 5 6 u u u u i.w.p.e.a.s.a u d.` f.9.a a a a a a u u q.u.g.",
"2 3 4 5 h.6 7 7 u j.k.4.l.r.z.a a u x.c.v.:.a a a a a a u u u.b.g.",
"3 4 5 6 6 7 u 3.j.=.4.l.z.U a a a u x.c.n.~ a a a a a a u u b.g.m.",
"5 5 6 r 7 8 u u u Z M.N.B.' x.V.d.d.V.c.v.:.a a a a a a u u g.m.C.",
"5 h.6 7 7 9 u u u ! 7.Z.u u A.u ' u ' u u 9.[ u u a a a u u S.m.D.",
"6 6 7 8 9 0 u u u F.G.G x.u 7.u H.x.H.u J.u u [ a a a a u u m.D.-.",
"r 7 8 9 0 q u u u ~ 9.~ 9.~ ~ ~ ~ 9.~ :.@.U a a a a a a u u D.-.K.",
"7 7 9 0 i q p u u u u u u u u u u u u u u u u u u u u u u u D.K.L.",
"8 9 0 q q p s h l x u u u u u u u u u u u u u u u u u u u u K.L.P.",
"9 0 q t p s h l x c c b M B Z H H ^ ^ #.>.q.u.g.g.m.C.D.-.K.L.P.I.",
"0 i q p p h l x v c N M B Z Y H { ^ 0.#.q.u.b.g.S.m.D.D.K.L.U.P.Y.",
"q q p s h l x v c b M B Z Y H ^ ^ #.#.q.u.b.g.m.m.D.-.K.L.P.P.Y.T."
};

static char *SuitcaseIcons[] = {
"32 32 252 2",
"   c #120b0d",
".  c #1d120f",
"X  c #17120d",
"o  c #191412",
"O  c #1d1214",
"+  c #1d1513",
"@  c #1c1813",
"#  c #1b1c18",
"$  c #090305",
"%  c #000926",
"&  c #001334",
"*  c #14293b",
"=  c #221513",
"-  c #231c16",
";  c #211f1c",
":  c #2a251e",
">  c #2b2322",
",  c #302623",
"<  c #32262d",
"1  c #342b2b",
"2  c #352a29",
"3  c #3e2f32",
"4  c #322c30",
"5  c #3c312b",
"6  c #35312a",
"7  c #3e3131",
"8  c #3f3036",
"9  c #3e3139",
"0  c #323e3c",
"q  c #000c4c",
"w  c #000e53",
"e  c #061c40",
"r  c #001458",
"t  c #18045e",
"y  c #001563",
"u  c #001c75",
"i  c #011f7d",
"p  c #1b3940",
"a  c #132756",
"s  c #012773",
"d  c #0b306e",
"f  c #122969",
"g  c #122973",
"h  c #16337f",
"j  c #253543",
"k  c #37505a",
"l  c #334a59",
"z  c #365269",
"x  c #42332e",
"c  c #4c392f",
"v  c #433334",
"b  c #473738",
"n  c #4e3439",
"m  c #4d3b36",
"M  c #4e3c39",
"N  c #403a38",
"B  c #543d35",
"V  c #533b39",
"C  c #583d38",
"Z  c #5b3d36",
"A  c #533f42",
"S  c #4d413b",
"D  c #53423d",
"F  c #5f4239",
"G  c #5a4137",
"H  c #424243",
"J  c #564740",
"K  c #5b4742",
"L  c #5e5851",
"P  c #404968",
"I  c #4e5d73",
"U  c #4a646d",
"Y  c #4d6a7b",
"T  c #634846",
"R  c #674a48",
"E  c #6b4f51",
"W  c #734c47",
"Q  c #754e45",
"!  c #744e49",
"~  c #745147",
"^  c #765149",
"/  c #78544d",
"(  c #765b5a",
")  c #7e5d56",
"_  c #7d5b54",
"`  c #7f5c58",
"'  c #765553",
"]  c #6d675f",
"[  c #76635a",
"{  c #7d6159",
"}  c #6e6769",
"|  c #6f6867",
" . c #6c6563",
".. c #716964",
"X. c #786660",
"o. c #786966",
"O. c #76706b",
"+. c #787975",
"@. c #022f91",
"#. c #173d8d",
"$. c #1f3891",
"%. c #203986",
"&. c #1646a0",
"*. c #2b4897",
"=. c #2d519c",
"-. c #304797",
";. c #3e509f",
":. c #234fa2",
">. c #354fa7",
",. c #3358bc",
"<. c #3d60a6",
"1. c #3a6bbb",
"2. c #506b80",
"3. c #58639a",
"4. c #547884",
"5. c #587a9f",
"6. c #4a7684",
"7. c #4362ad",
"8. c #4e67a9",
"9. c #496bb6",
"0. c #5e6fb0",
"q. c #5678a8",
"w. c #5d74b1",
"e. c #5777b6",
"r. c #777d84",
"t. c #616dae",
"y. c #606eb2",
"u. c #607ea2",
"i. c #6978ab",
"p. c #7071a7",
"a. c #5876c2",
"s. c #6478c7",
"d. c #7c8078",
"f. c #598298",
"g. c #5f87a8",
"h. c #618089",
"j. c #69889e",
"k. c #698995",
"l. c #7e8583",
"z. c #758e9c",
"x. c #6887a6",
"c. c #6995ae",
"v. c #788ea3",
"b. c #7291a6",
"n. c #7783ce",
"m. c #7b86d3",
"M. c #7a9dfb",
"N. c #7389e5",
"B. c #815b5a",
"V. c #805f57",
"C. c #826058",
"Z. c #81625a",
"A. c #87655d",
"S. c #84655c",
"D. c #89675f",
"F. c #88695f",
"G. c #926d5f",
"H. c #876764",
"J. c #886760",
"K. c #8c6761",
"L. c #8d6a61",
"P. c #8a6a61",
"I. c #82746d",
"U. c #847679",
"Y. c #897973",
"T. c #916762",
"R. c #946d60",
"E. c #946b6a",
"W. c #977768",
"Q. c #937b72",
"!. c #9a7d75",
"~. c #8077ab",
"^. c #9b7ab1",
"/. c #8d857e",
"(. c #9d8179",
"). c #ac8972",
"_. c #efa478",
"`. c #8c8c8e",
"'. c #89848a",
"]. c #868991",
"[. c #8c8c92",
"{. c #898694",
"}. c #8e948e",
"|. c #958c8d",
" X c #968c90",
".X c #949493",
"XX c #94919a",
"oX c #9a9f97",
"OX c #869497",
"+X c #838abb",
"@X c #8b9ca8",
"#X c #9a9ba4",
"$X c #9ca7ae",
"%X c #a38887",
"&X c #a49189",
"*X c #a29c95",
"=X c #aa9e9a",
"-X c #b38784",
";X c #a19fa6",
":X c #bba08e",
">X c #a8a3a5",
",X c #a2a8b4",
"<X c #bba4a0",
"1X c #bebebe",
"2X c Gray75",
"3X c Gray74",
"4X c #b7b8b7",
"5X c #8990c9",
"6X c #8690d7",
"7X c #a69fdd",
"8X c #a8accd",
"9X c #a1a9d8",
"0X c #a0b3c9",
"qX c #b2b9c6",
"wX c #b6baca",
"eX c #b8bbc5",
"rX c #b5bcd1",
"tX c #bfc1c2",
"yX c #b9c1db",
"uX c #c1978d",
"iX c #c99f94",
"pX c #c9b89e",
"aX c #d6a994",
"sX c #c0beb8",
"dX c #e0a784",
"fX c #e0bda5",
"gX c #d0c1bf",
"hX c Gray76",
"jX c #c2c3c3",
"kX c #c0c1c1",
"lX c #c5c6c6",
"zX c #cfcac4",
"xX c #cdcece",
"cX c #c9cccc",
"vX c #c7c8c7",
"bX c #ced1d1",
"nX c #d4c7c9",
"mX c #d4cac6",
"MX c #d0cfcf",
"NX c #d4cac9",
"BX c #dccecd",
"VX c #dacccc",
"CX c #d0c6c5",
"ZX c #d0cfd0",
"AX c #d6d8d9",
"SX c #e3dee3",
"DX c #e6e1e7",
"FX c #eee7e9",
"GX c #eee9e8",
"HX c #eae4e8",
"JX c #f0e9eb",
"KX c None",
"KXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKX",
"KXKXKXKXKXKXKXKXKXKXKXvXDXFXGXGXFXFXGXGXJXsXlXKXKXKXKXKXKXKXKXKX",
"KXKXKXKXKXKXKXKXKXKXbXsXb : , , : > : : 1 - `.KXKXKXKXKXKXKXKXKX",
"KXKXKXKXCXO. ...} L >XU.$ < , , < , , > m A @ O. .] | | ] } .. .",
"KXKXKXzXE.R T T E / <X+.o P.( ( ( ( ( ' H.D o T.B.E T T ' E.x X ",
"KXKXBXQ.Q.S.X.X.S.Q.%XQ.[ P.[ X.) o.[ [ I.F.[ (.W.I.[ { Y.m ; o ",
"KXDXmXgXnXVXBXBXBXnXCXNXBXBXBXBXBXBXBXBXVXBXBXNXmXVXBXSX|.  1 o ",
"KXSX^ W W ~ ! ! ~ W ~ ~ W ~ ! ! ~ W ! ! W ~ ! ! ~ W ^ / < > 1 @ ",
"KXDXC.) Z.Z.Z.V.) ) ) ) ) ) ) ) ) ) ) ) ) ) C.Z.Z.Z.Z.A.v : 6 . ",
"KXDXC.) B.Z._ V.G.G.G.G.G.R.R.R.R.T.R.R.T.W.A._ Z.B.Z.A.v , 5 + ",
"KXDXC.) C.Z./ mXyXqXrXrXwXwXqXqXwXwXwXqXqXcX^.c F.{ Z.A.9 , 6 @ ",
"KXDXC.) C.Z.^ zX@.s i u u y y y r w w q q y t B L.{ Z.A.7 < x O ",
"KXDXC.) B.Z.! mX&.p.~.*.$.%.-.7.h g g f f d % F P.B.Z.A.v , 7 + ",
"KXDXC.) Z.Z.~ mX,.,.7.>.t.y.-.=.=.=.#.w.*.#.& F P.Z.Z.A.v , x @ ",
"KXDXC.) B.Z.Q CXN.6Xn.9.5X9X7.9.9.0.>.8X;.:.e G L.` Z.A.7 1 v O ",
"KXDXC.) B.Z.Q NXM.6X7Xm.i.a.s.+Xe.w.8.e.7.1.a Z L.` Z.A.9 1 v @ ",
"KXDXC.) Z.Z.^ mXi.3.3.P : I 0.s.a.e.7.7.<.9.a Z P.Z.Z.A.7 2 b + ",
"KXDXC.) B.Z.! CXz l k z I U Y u.g.u.5.f.6.q.p Z P.B.Z.A.7 2 b + ",
"KXDXC.) C.Z.^ mXc.x.b.x.v.b.j.k.h.2.Y 4.4.6.* C L.{ Z.A.9 5 m - ",
"KXDXC.) C.Z.Q NX0X,X,X$XoX;XXX#XoX].'.OXz.j.j C L.{ Z.A.7 5 m = ",
"KXDXC.) B.Z.W nX@Xr.[..X|.`.XX.X}.`.|.[.].@X0 V L.B.Z.A.8 6 S - ",
"KXDXC.) Z.Z.^ mXr.| d.d.U.I./.*X*X.XoXoX.X>XH V L.Z.Z.A.8 5 S - ",
"KXDXC.) B.Z.! nX{.+.U.U.Y.!.%X%X&X-X=X=X:XpXS m L.` Z.A.7 7 D = ",
"KXDXC.) B.Z.! BX`.Q.W.!.W.).uXiXaX_.dXaXaXfXG M L.` Z.A.9 7 D - ",
"KXDXC.) Z.Z._  XK S G J S C D B D S B D M K # V P.Z.Z.A.3 5 K - ",
"KXDXC.) B.Z.B.C b n n M n M m n M n n m n M V ' A.B.Z.A.3 7 J = ",
"KXDXC.) Z.Z.Z.D.L.L.L.L.L.L.L.L.L.L.L.L.L.L.L.A.Z.C.Z.A.9 v x H ",
"KXJXK.A.D.J.D.D.J.A.D.A.D.J.A.D.J.A.D.A.D.J.D.D.J.D.K.L.v v N >X",
"KX#X. X O . o = . O = o O . o = . O = o O . o = . O = @   4 KXKX",
"KX`.+.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.l.r.4XKXKX",
"KXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKX",
"KXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKXKX"
};

static char *SuitcaseIconsOpen[] = {
"32 32 256 2",
"   c Gray0",
".  c #000100",
"X  c #000101",
"o  c #020502",
"O  c #09030f",
"+  c #060a09",
"@  c #050512",
"#  c #060a10",
"$  c #080510",
"%  c #090b12",
"&  c #1c1714",
"*  c #000c39",
"=  c #0d1e2b",
"-  c #0b1633",
";  c #1e1b25",
":  c #151f3c",
">  c #1e2c19",
",  c #1e212e",
"<  c #1c2a37",
"1  c #20150f",
"2  c #221614",
"3  c #231b19",
"4  c #221b14",
"5  c #291d26",
"6  c #2b231d",
"7  c #262119",
"8  c #262322",
"9  c #25222e",
"0  c #2c2623",
"q  c #2d2328",
"w  c #252634",
"e  c #252e35",
"r  c #372325",
"t  c #3b2526",
"y  c #3e2728",
"u  c #362b29",
"i  c #3b2c31",
"p  c #342936",
"a  c #3a3338",
"s  c #001351",
"d  c #001d5a",
"f  c #111e4f",
"g  c #001a67",
"h  c #183449",
"j  c #03236b",
"k  c #062876",
"l  c #0c3072",
"z  c #132d74",
"x  c #19367e",
"c  c #3d2d40",
"v  c #373543",
"b  c #263d4b",
"n  c #213664",
"m  c #243972",
"M  c #29424b",
"N  c #2c4253",
"B  c #3d414b",
"V  c #394645",
"C  c #344958",
"Z  c #284a7c",
"A  c #442d2c",
"S  c #412d27",
"D  c #452d32",
"F  c #45312c",
"G  c #423738",
"H  c #483737",
"J  c #513a3a",
"K  c #443c43",
"L  c #453c4a",
"P  c #4d413a",
"I  c #53443e",
"U  c #46484b",
"Y  c #4c4d5c",
"T  c #464758",
"R  c #564343",
"E  c #5a4b4a",
"W  c #594747",
"Q  c #554653",
"!  c #574a52",
"~  c #54475a",
"^  c #5d544b",
"/  c #5d5147",
"(  c #5b5655",
")  c #5a5954",
"_  c #5e5958",
"`  c #5b5959",
"'  c #585553",
"]  c #474b67",
"[  c #4e5563",
"{  c #5c4961",
"}  c #535163",
"|  c #585968",
" . c #5c5970",
".. c #42647d",
"X. c #654d4c",
"o. c #64544b",
"O. c #615544",
"+. c #6b5452",
"@. c #6d5b53",
"#. c #645d58",
"$. c #744f45",
"%. c #77544c",
"&. c #78594f",
"*. c #725b51",
"=. c #735c5b",
"-. c #7d5c52",
";. c #7b5d59",
":. c #785f60",
">. c #6a645e",
",. c #7c625b",
"<. c #666163",
"1. c #7c6b61",
"2. c #766f69",
"3. c #796e7f",
"4. c #7a706c",
"5. c #797777",
"6. c #122e80",
"7. c #183a86",
"8. c #082983",
"9. c #213b8e",
"0. c #1c4a9d",
"q. c #1649b0",
"w. c #28448d",
"e. c #274997",
"r. c #344b95",
"t. c #3658a9",
"y. c #3f5dbe",
"u. c #3b639e",
"i. c #3a67aa",
"p. c #3d64b7",
"a. c #46599d",
"s. c #436f8d",
"d. c #45669a",
"f. c #54799f",
"g. c #4371ac",
"h. c #5767a6",
"j. c #5d6fb1",
"k. c #547fa3",
"l. c #5475b5",
"z. c #646d8f",
"x. c #65699b",
"c. c #757e85",
"v. c #686ca5",
"b. c #6870a8",
"n. c #6476b7",
"m. c #7e7cad",
"M. c #786bb4",
"N. c #4173c5",
"B. c #5877c5",
"V. c #637ec4",
"C. c #52888f",
"Z. c #58879c",
"A. c #5681a4",
"S. c #5593a1",
"D. c #6a8089",
"F. c #618b9e",
"G. c #749095",
"H. c #638ba7",
"J. c #6b86b8",
"K. c #6a92a7",
"L. c #6183d7",
"P. c #7f88c8",
"I. c #7487c6",
"U. c #7181db",
"Y. c #805d4f",
"T. c #825d52",
"R. c #836055",
"E. c #85655c",
"W. c #836362",
"Q. c #846b66",
"!. c #8b6273",
"~. c #8c7773",
"^. c #a7765d",
"/. c #a67e68",
"(. c #80538d",
"). c #887b86",
"_. c #87837e",
"`. c #9c867c",
"'. c #a38176",
"]. c #8b868c",
"[. c #8c9799",
"{. c #9a8888",
"}. c #998a95",
"|. c #998b99",
" X c #938698",
".X c #91928b",
"XX c #9a969a",
"oX c #8f9faa",
"OX c #938bae",
"+X c #909da4",
"@X c #94a19f",
"#X c #93a8ae",
"$X c #a48b8d",
"%X c #a99a99",
"&X c #b19499",
"*X c #b19996",
"=X c #b19d92",
"-X c #b19c99",
";X c #a8a090",
":X c #b9a99e",
">X c #baa698",
",X c #bfb59c",
"<X c #ada6a7",
"1X c #aea9a3",
"2X c #aea4aa",
"3X c #b2acac",
"4X c #b9aaa4",
"5X c #bfa4a2",
"6X c #bebebe",
"7X c Gray75",
"8X c Gray74",
"9X c #bab9ba",
"0X c #b7b5b4",
"qX c #848ed8",
"wX c #8491c1",
"eX c #9399d3",
"rX c #8998e3",
"tX c #abb0de",
"yX c #a5a4e2",
"uX c #b3b0e1",
"iX c #bdc0c0",
"pX c #c5b19d",
"aX c #c6aba9",
"sX c #c5aea6",
"dX c #c4b1a3",
"fX c #c5b3a9",
"gX c #c3bbba",
"hX c #d8bebc",
"jX c #d7bbb9",
"kX c #c0bfc0",
"lX c #c2bbd0",
"zX c #c5bbe3",
"xX c #dcc1bf",
"cX c #e0c3be",
"vX c Gray76",
"bX c #c3c3c3",
"nX c #c0c1c1",
"mX c #c5c5c6",
"MX c #cccdcd",
"NX c Gray78",
"BX c #d3ccc9",
"VX c #d9cfc9",
"CX c #d4d3ce",
"ZX c #d5d5d6",
"AX c #cdc6ef",
"SX c #d8cefb",
"DX c #d6d1f0",
"FX c #e7d9db",
"GX c #e5dfe8",
"HX c #eee7e8",
"JX c #eee9e8",
"KX c #e7e8e2",
"LX c #f0e9eb",
"PX c #f2f1eb",
"IX c #fffffa",
"UX c None",
"UXUXUXUXUXUXUXUXUXUXUXUXUXUXUXUXUXUXUXUXUXUXUXUXUXUXUXUXUXUXUXUX",
"UXUXUXUXUXUXUXUXUXUXUX3XFXHXJXJXHXHXJXJXLXgXmXUXUXUXUXUXUXUXUXUX",
"UXUXUXUXUXUXUXUXUXUXmX3XH 6 0 0 6 q 6 6 i 3 ].UXUXUXUXUXUXUXUXUX",
"UXUXUXUXgX0X].#.( E %X4.  3 2 2 2 1 2 & S D o >._ ^ _ _ ) <.>.XX",
"UXUXUXZXVXfXaXaXaX5XFX0X~.cXhXhXhXhXhXjXxX%X5.jXaXaXaXaXaX`.H u ",
"UXUXUXKXdX2.) ` ) ) ' ) _ ) ) ( ' ) ' ) ` _ #.` ) ` ' ' 4.VX0 7 ",
"UXUXUXJXO.    X % # O # $ $ # O # # O # $ $ # O # # O #   3XG 8 ",
"UXUXUXPX*.  o B Y T T T T T T Y T T T T T T ] | } | | | w 1XG 8 ",
"UXUXUXPX@.  . v  X X}.}.}.}.|.|.|.|.|.|.|.|.).T T T Y } 5 <XH 7 ",
"UXUXUXPX@.  . L DXh.j.b.v.v.x.x.x.x.x.x.x.b.] K :.Y Y [ ; <XH 8 ",
"UXUXUXPX*.    U tX7.w.k 8.j k z g d s s s d * 3.zX .U } , 1XI & ",
"UXUXUXPX+.  . K uXh.m.r.e.w.r.a.7.x 6.x z 7.f * j @ ~ } ; 2XR & ",
"UXUXUXPX*.    K AXy.p.t.wXeXt.t.i.t.e.wXr.0.h - l : 2XB 9 1XJ & ",
"UXUXUXPX*.    K SXqXeXB.I.P.g.j.l.n.h.eXd.t.n - z - [ p w 1XI & ",
"UXUXUXPX+.  . K SXrXrXI.z.V.U.wXl.l.h.g.p.N.Z : Z = b v 9 2XI & ",
"UXUXUXPX*.    U lXN C h > C a.l.l.l.g.i.u.i.m V Z.e M a w 1XI & ",
"UXUXUXIX=.    L AXs.f.f.K.K.F.K.K.H.Z.F.C.S.C N A.< M c 9 <XR & ",
"mX8X5.>.D 3 & i <.v U V L U B K V a a a a V e i U p M v w <XR & ",
"ZX{.$.%.;.E.E.R.&.-.T.T.-.Y.T.T.-.T.T.T.T.T.R.R.R.E.7 9 w 1XW 4 ",
"BX*.$.%.%.%.%.%.%.%.%.%.%.%.%.%.%.%.%.%.%.%.%.%.&.R.r % ; 2XE 2 ",
"BX$X*X*X&X=X*X*X=X&X*X*X&X=X*X*X=X&X*X*X&X=X*X*X>X1.q 8 , 1XE 4 ",
"BX-X4X4X4X:X:XdXpXdXdXdXdXdXdXdXdXfXdXdX4X:X4X4XfX1.7 i X 3XE 4 ",
"NX`.*.,.,.E.).T ~ ~ ~ ! Q Q ! Q ! ! Q Q 2.!.;.,.E.W.p G   3Xo.2 ",
"MXNX;.,.1.E.OXq.e.e.e.7.9.w.x k k j j g d.(.=.Q.W.W.i a + 0Xo.4 ",
"UXGXQ.*.,.&.!.!.rXyXqXa.h.L.B.P.n.J.I.t.0.M.J ,.,.Q.W F 2 5.X.0 ",
"UXZX%X/ +.+.O.%XJ.k.f...z.J.H.J.H.k.A.Z.A.#Xp X.@.=.W 6 i X u i ",
"UXUXCX@.o.X./ *.9X#XoX+X#X@X[.[.].c.G.G.D.G. .r +.#.o.5 i + 0 XX",
"UXUXNX4.P W / R _.XX).{.`.`.}.$X$X$X%X%X>X,XUXc I ^ X.F q 5 3XUX",
"UXUXZX3XJ R R J =.).:.Q.W.R.E.!.~.E.^./.'.'.;X{ J R W P 0 u UXUX",
"UXUXUXCXH y A A S t t t y y t t r r r r r r r S A A A F 4 2 UXUX",
"UXUXUXMX.X' _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ #.U XXUXUX",
"UXUXUXUXUXUXUXUXUXUXUXUXUXUXUXUXUXUXUXUXUXUXUXUXUXUXUXUXUXUXUXUX"
};

/* XPM */
static char *so_xpm[] = {
"15 15 53 1",
" 	c None",
"!	c #C6C6C6",
"#	c #1C1C1C",
"$	c #4D4D4D",
"%	c #AEAEAE",
"&	c #616161",
"/	c #0C0C0C",
"(	c #181818",
")	c #353535",
"=	c #EFEFEF",
"+	c #EBEBEB",
"*	c #757575",
"-	c #F3F3F3",
"[	c #D2D2D2",
"]	c #313131",
"{	c #141414",
"}	c #595959",
"<	c #8E8E8E",
">	c #CACACA",
",	c #E3E3E3",
".	c #E7E7E7",
"|	c #D7D7D7",
"@	c #2D2D2D",
"~	c #101010",
"'	c #454545",
"?	c #DFDFDF",
"0	c #C2C2C2",
"1	c #A2A2A2",
"2	c #6D6D6D",
"3	c #9A9A9A",
"4	c #242424",
"5	c #DBDBDB",
"6	c #CECECE",
"7	c #BABABA",
"8	c #BEBEBE",
"9	c #797979",
"A	c #929292",
"B	c #282828",
"C	c #3D3D3D",
"D	c #7D7D7D",
"E	c #202020",
"F	c #8A8A8A",
"G	c #B2B2B2",
"H	c #969696",
"I	c #B6B6B6",
"J	c #9E9E9E",
"K	c #5D5D5D",
"L	c #868686",
"M	c #555555",
"N	c #A6A6A6",
"O	c #656565",
"P	c #515151",
"Q	c #414141",
"               ",
"   !#$%&/()    ",
"  =+*%-[]{($}  ",
" <>,.,|.@]#/~' ",
"!=,-,?0!123{/4 ",
"5=5[60[78%33(} ",
"97[[0]'011AB/C*",
" [!0D'EFGH2()/)",
"66!IJ$BK1DFK})(",
">>GGJH{L<*2}M)(",
" <FJH10NO&&()((",
"  FFL29*KK)///P",
"  9922}}P$Q)/  ",
"   *(@PMQQ$Q/  ",
"     QQ@//J    "
};

/* XPM */
static char *dir[] = {
"16 15 32 1",
" 	c None",
"!	c #7D7D65",
"#	c #9E9E92",
"$	c #654D18",
"%	c #92866D",
"&	c #9A7124",
"/	c #AE9A71",
"(	c #BEBEA6",
")	c #7D6941",
"=	c #D7AE79",
"+	c #B28E59",
"*	c #695120",
"-	c #CA9E5D",
"[	c #FFFFCA",
"]	c #FFFFE7",
"{	c #AA966D",
"}	c #FFCE9A",
"<	c #CAB686",
">	c #BA9661",
",	c #AAA296",
".	c #8A6D39",
"|	c #9E7D49",
"@	c #79795D",
"~	c #826531",
"'	c #DFDFC6",
"?	c #797559",
"0	c #756D49",
"1	c #9E9E86",
"2	c #71653D",
"3	c #6D5D31",
"4	c #716941",
"5	c #8E7951",
"   !#  $%  %    ",
"&/ !(!)=+$%+*%  ",
"$-&/[](!{=+==+* ",
")=}-&<[](!{===* ",
"%+}}}-&<[](!{=>*",
",.}}}}}-&<[](!|)",
" $}}}}}}}-&<]@~%",
" )=}}}}}}}}&'?* ",
" %+}}}}}}}}&(0) ",
" ,.}}}}}}}}&12% ",
"  $+}}}}}}}&!3  ",
"   %$+}}}}}&4)  ",
"     %$+}}}&3%  ",
"       %$+}&*   ",
"         %$$5   "
};

/* XPM */
static char * folder[] = {
"16 16 8 1",
" 	c None",
".	c #909000",
"+	c #000000",
"@	c #EFE8EF",
"#	c #FFF8CF",
"$	c #FFF890",
"%	c #CFC860",
"&	c #FFC890",
"                ",
"  .....+        ",
" .@##$$.+       ",
".%%%%%%%......  ",
".###########$%+ ",
".#$$$$$$$$$$&%+ ",
".#$$$$$$$&$&$%+ ",
".#$$$$$$$$&$&%+ ",
".#$$$$$&$&$&$%+ ",
".#$$$$$$&$&$&%+ ",
".#$$$&$&$&$&&%+ ",
".#&$&$&$&$&&&%+ ",
".%%%%%%%%%%%%%+ ",
" ++++++++++++++ ",
"                ",
"                "};

/* XPM */
static char * ofolder[] = {
"16 16 12 1",
" 	c None",
".	c #808080",
"+	c #E0E0D0",
"@	c #4F484F",
"#	c #909000",
"$	c #FFF8EF",
"%	c #CFC860",
"&	c #003090",
"*	c #7F7800",
"=	c #FFC890",
"-	c #FFF890",
";	c #2F3000",
"        .       ",
"       .+@      ",
"   ###.$$+@     ",
"  #%%.$$$$+@    ",
"  #%.$$$&$$+@** ",
"  #.+++&+&+++@* ",
"############++@ ",
"#$$$$$$$$$=%#++@",
"#$-------=-=#+; ",
" #---=--=-==%#; ",
" #-----=-=-==#; ",
" #-=--=-=-=-=#; ",
"  #=-=-=-=-==#; ",
"  ############; ",
"   ;;;;;;;;;;;  ",
"                "};


/* XPM */
static char * keyboard[] = {
/* width height num_colors chars_per_pixel */
"36 31 6 1",
/* colors */
" 	s None	c None",
".	c black",
"X	c yellow",
"o	c white",
"O	c SlateGray",
"+	c #c0c0c0",
/* pixels */
"                                    ",
"                                    ",
"                      .             ",
"                     .X.            ",
"                      ..            ",
"                        ...         ",
"                           .        ",
"                           .        ",
"       .. .. .. .. .. ..   .        ",
"     .. .. .. .. .. .. ....         ",
"    .                               ",
"    .                               ",
"   ..............................   ",
"  .oooooooooooooooooooooooooooooO.  ",
"  .oOOOOOOOOOOOOOOOOOOOOOOOOOOOOO.  ",
"  .oOo+.o+.o+.o+.o+.o+.o+.o+.o+.O.  ",
"  .oO++.++.++.++.++.++.++.++.++.O.  ",
"  .oO...........................O.  ",
"  .oOooo+.o+.o+.o+.o+.o+.o+.o++.O.  ",
"  .oO++++.++.++.++.++.++.++.+++.O.  ",
"  .oO...........................O.  ",
"  .oOoo.o+.o+.o+.o+.o+.o+.oooo+.O.  ",
"  .oO++.++.++.++.++.++.++.+++++.O.  ",
"  .oO...........................O.  ",
"  .oOooo+.o+.oooooooooo+.o+.oo+.O.  ",
"  .oO++++.++.+++++++++++.++.+++.O.  ",
"  .oO...........................O.  ",
"  .OOOOOOOOOOOOOOOOOOOOOOOOOOOOOO.  ",
"   ..............................   ",
"                                    ",
"                                    ",
};

/* XPM */
static char *document_xpm[] = {
"16 15 10 1",
" 	c None",
"!	c #616161",
"#	c #414141",
"$	c #FFFFFF",
"%	c #000000",
"&	c #202020",
"/	c #C2C2C2",
"(	c #A2A2A2",
")	c #828282",
"=	c #DFDFDF",
" !!!!!!!!!!!!!# ",
" !$$$$$$$$$$$$% ",
" !$$$$$$$$$$$$% ",
" !$$$$$$$$$$$$% ",
" !$$$$$$$$$$$$% ",
" !$$$$$$$$$$$$% ",
" !$$$$$$$$$$$$% ",
" !$$$$$$$$$$$$% ",
" !$$$$$$$$$$$$% ",
" !$$$$$$$$$$$$% ",
" !$$$$$$$$$!!!& ",
" !$$$$$$$$$!$/# ",
" !$$$$$$$$()/#( ",
" !$$$$$$=/!/#)  ",
" #%%%%%%%%&#(   "
};

/* XPM */
static char * gnustep[] = {
"16 16 134 2",
"  	c None",
". 	c #555555",
"+ 	c #646466",
"@ 	c #737374",
"# 	c #58585A",
"$ 	c #454547",
"% 	c #323233",
"& 	c #151516",
"* 	c #959596",
"= 	c #8C8C8C",
"- 	c #6B6B6B",
"; 	c #525252",
"> 	c #3E3E3E",
", 	c #2B2B2B",
"' 	c #181818",
") 	c #050505",
"! 	c #000000",
"~ 	c #979798",
"{ 	c #898989",
"] 	c #696969",
"^ 	c #545454",
"/ 	c #424242",
"( 	c #303030",
"_ 	c #1E1E1E",
": 	c #0C0C0C",
"< 	c #020202",
"[ 	c #363636",
"} 	c #404040",
"| 	c #2E2E2E",
"1 	c #999999",
"2 	c #8D8D8D",
"3 	c #6F6F6F",
"4 	c #5C5C5C",
"5 	c #4A4A4A",
"6 	c #383838",
"7 	c #272727",
"8 	c #151515",
"9 	c #040404",
"0 	c #0F0F0F",
"a 	c #E9E9E9",
"b 	c #F9F9F9",
"c 	c #AFAFB0",
"d 	c #959595",
"e 	c #797979",
"f 	c #656565",
"g 	c #535353",
"h 	c #414141",
"i 	c #2F2F2F",
"j 	c #1D1D1D",
"k 	c #0B0B0B",
"l 	c #E7E7E7",
"m 	c #E6E6E6",
"n 	c #C1C1C1",
"o 	c #666667",
"p 	c #7F7F80",
"q 	c #878787",
"r 	c #6E6E6E",
"s 	c #262626",
"t 	c #141414",
"u 	c #DEDEDE",
"v 	c #D6D6D6",
"w 	c #BABABA",
"x 	c #101010",
"y 	c #888888",
"z 	c #7B7B7B",
"A 	c #646464",
"B 	c #282828",
"C 	c #090909",
"D 	c #D2D2D2",
"E 	c #C7C7C7",
"F 	c #AEAEAE",
"G 	c #7E7E7E",
"H 	c #717171",
"I 	c #5B5B5B",
"J 	c #494949",
"K 	c #161616",
"L 	c #242424",
"M 	c #202020",
"N 	c #3A3A3A",
"O 	c #D9D9D9",
"P 	c #A1A1A1",
"Q 	c #7F7F7F",
"R 	c #777777",
"S 	c #676767",
"T 	c #3F3F3F",
"U 	c #505050",
"V 	c #EDEDED",
"W 	c #EEEEEE",
"X 	c #ECECEC",
"Y 	c #CBCBCB",
"Z 	c #A6A6A6",
"` 	c #929292",
" .	c #484848",
"..	c #FCFCFC",
"+.	c #F2F2F2",
"@.	c #E2E2E2",
"#.	c #D1D1D1",
"$.	c #BFBFBF",
"%.	c #A8A8A8",
"&.	c #969696",
"*.	c #818181",
"=.	c #565656",
"-.	c #2C2C2C",
";.	c #FBFBFB",
">.	c #CECECE",
",.	c #BDBDBD",
"'.	c #ABABAB",
").	c #9A9A9A",
"!.	c #6C6C6C",
"~.	c #313131",
"{.	c #191919",
"].	c #4F4F4F",
"^.	c #F5F5F5",
"/.	c #D4D4D4",
"(.	c #C0C0C0",
"_.	c #AFAFAF",
":.	c #9D9D9D",
"<.	c #757575",
"[.	c #454545",
"}.	c #070707",
"|.	c #333333",
"1.	c #5F5F5F",
"2.	c #5D5D5D",
"3.	c #EFEFEF",
"4.	c #C5C5C5",
"5.	c #B2B2B2",
"6.	c #A0A0A0",
"7.	c #707070",
"8.	c #434343",
"9.	c #464646",
"0.	c #C8C8C8",
"a.	c #8E8E8E",
"b.	c #343434",
"c.	c #232323",
"          + @ # $ % &           ",
"      * = - ; > , ' ) ! )       ",
"    ~ { ] ^ / ( _ : < [ } |     ",
"  1 2 3 4 5 6 7 8 9 0 a b c _   ",
"  d e f g h i j k ! 0 l m n o   ",
"p q r 4 5 6 s t 9 ! 0 u v w q x ",
"y z A ; } B ' C ! ! 0 D E F 2 ( ",
"G H I J | K B L M M N O w P Q i ",
"R S ; T L U V W X l l Y Z ` r L ",
". 4  .[ j . ..+.@.#.$.%.&.*.=.k ",
"  U > -.K g ;.@.>.,.'.).y !.i   ",
"  ~.| {.: ].^./.(._.:.= <.[.    ",
"    |.1.2.P 3.4.5.6.2 7.8.|     ",
"      9.6.0.5.:.a.z 2.i         ",
"          {.b.[ ~.c.            ",
"                                "};

/* XPM */
static char *conf_xpm[] = {
"16 15 81 1",
" 	c None",
"!	c #616161",
"#	c #414141",
"$	c #FFFFFF",
"%	c #000000",
"&	c #EBEBD7",
"/	c #1C1C0C",
"(	c #393920",
")	c #3D3D24",
"=	c #31311C",
"+	c #9E9E9A",
"*	c #EFEBB2",
"-	c #656539",
"[	c #DFDF8E",
"]	c #656141",
"{	c #141408",
"}	c #5D594D",
"<	c #A2A29E",
">	c #A6A269",
",	c #F7F3BA",
".	c #EFEBA6",
"|	c #EBE396",
"@	c #8A8651",
"~	c #35351C",
"'	c #101008",
"?	c #9A9A92",
"0	c #DBD78E",
"1	c #F3EFB2",
"2	c #EBE79E",
"3	c #DFDB8E",
"4	c #DBD27D",
"5	c #CECA71",
"6	c #CAC671",
"7	c #615D35",
"8	c #969692",
"9	c #D7CE7D",
"A	c #DFDB8A",
"B	c #828245",
"C	c #414124",
"D	c #BAB661",
"E	c #B6AE55",
"F	c #5D5931",
"G	c #717169",
"H	c #D7D7AE",
"I	c #D7D27D",
"J	c #71713D",
"K	c #2D2D18",
"L	c #9A964D",
"M	c #96964D",
"N	c #595935",
"O	c #202010",
"P	c #3D3D20",
"Q	c #C6C269",
"R	c #BEB661",
"S	c #AAA251",
"T	c #18180C",
"U	c #8E8E4D",
"V	c #797949",
"W	c #6D6D41",
"X	c #51512D",
"Y	c #828275",
"Z	c #A6A251",
"a	c #A29E59",
"b	c #7D7D45",
"c	c #656139",
"d	c #494928",
"e	c #242410",
"f	c #9A9A96",
"g	c #757545",
"h	c #717145",
"i	c #69693D",
"j	c #5D5D35",
"k	c #514D2D",
"l	c #202020",
"m	c #D2D2CA",
"n	c #4D4D2D",
"o	c #414131",
"p	c #C2C2C2",
"q	c #A2A2A2",
"r	c #828282",
"s	c #DFDFDF",
" !!!!!!!!!!!!!# ",
" !$$$$$$$$$$$$% ",
" !$$$&/()=+$$$% ",
" !$$&*-[]{}<$$% ",
" !$$>,.|@~/'?$% ",
" !$01234567{8$% ",
" !$&9ABCDEF'G$% ",
" !$HI5JKLMNOP$% ",
" !$HQRSTUVWXY$% ",
" !$&HZLabcdef$% ",
" !$$&ghijk~!!!l ",
" !$$$m+nCo$!$p# ",
" !$$$$$$$$qrp#q ",
" !$$$$$$sp!p#r  ",
" #%%%%%%%%l#q   "
};

/*******************************************************************************

			       public code
  
*******************************************************************************/

void
init_pixmaps (void)
/*
 *  Initialize builtin pixmaps.
 *
 *  No return value.
 *
 *  Side effects:
 *	global pixmap array 'p_array' is allocated and filled with all
 *	available pixmaps
 */
{
   char **pmap[] = {info_xpm, warning_xpm, kill_xpm, question_xpm,
		    SuitcaseIconsOpen, SuitcaseIcons,
		    disk_cap_up_xpm, help_xpm, latex_xpm, folder_cap_up_xpm,
		    undo_cap_up_xpm, ofolder, folder, so_xpm,
		    keyboard, document_xpm, gnustep,
		    dir, conf_xpm};
   unsigned n;
   
   p_array = Calloc (P_LAST, sizeof (pixmap_t));

   for (n = 0; n < P_LAST; n++)
   {
      p_array [n].pixmap = gdk_pixmap_create_from_xpm_d (main_window->window,
							 &p_array [n].mask,
							 NULL, pmap [n]);
      gdk_pixmap_ref (p_array [n].pixmap);
      gdk_bitmap_ref (p_array [n].mask);
   }
}
