
#include "wizard_page2Data.h"
#include "wizard_manager.h"

#include <qglobal.h>
#include <qtextview.h>
#include <qlabel.h>
#include <qstylesheet.h>

#if QT_VERSION >= 300
#include <qapplication.h>
#endif

class PrivateStyleSheet : public QStyleSheet
{
public:
	PrivateStyleSheet(QObject * parent=0, const char * name=0) 
		: QStyleSheet(parent,name) {
	}

	~PrivateStyleSheet() {}

	virtual void error( const QString & error_mess ) const {
		qDebug("%s", error_mess.latin1());
	}
};

/* 
 *  Constructs a WizardPage2 which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 */
WizardPage2::WizardPage2( QWidget* parent,  const char* name, WFlags fl )
    : WizardPage2Data( parent, name, fl )
{
	wizard_manager = new WizardManager();

	connect(wizard_manager, SIGNAL(message(const QString&)),
            this, SLOT(append_line(const QString&)) );

	connect(wizard_manager,SIGNAL(result(const QString&)),
            resultado_final, SLOT(setText(const QString&)) );

	log_view->setStyleSheet( new PrivateStyleSheet(this,"mystylesheet") );
	log_view->setTextFormat( Qt::RichText );
	log_view->setText( "" );
}

/*  
 *  Destroys the object and frees any allocated resources
 */
WizardPage2::~WizardPage2()
{
    delete wizard_manager;
}

/* 
 * public slot
 */
void WizardPage2::perform_tests()
{
#if QT_VERSION >= 300
	qDebug("Borrando");
	//log_view->clear();
	log_view->setText( "" );
	//qApp->processEvents();
#else
	log_view->setText( "" );
#endif

	diccionario = wizard_manager->examine( getFile() );

	if (diccionario!=0) emit dictionary_available();
}

void WizardPage2::append_line(const QString& linea) {
	qDebug("append_line: '%s'", linea.latin1());
	qDebug("antes append: '%s'", log_view->text().latin1() );
	//log_view->append(linea);
	log_view->setText( log_view->text() + linea );
}

#include "wizard_page2.moc.cpp"

#include "wizard_page2Data.cpp"
#include "wizard_page2Data.moc.cpp"

