/* processexitaction.cc
 * This file belongs to Worker, a file manager for UN*X/X11.
 * Copyright (C) 2010 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "processexitaction.hh"
#include "fileviewer.hh"
#include "worker.h"

ProcessExitAction::ProcessExitAction( bool show_file,
                                      const std::string &tmp_name,
                                      Worker *worker ) : m_show_file( show_file ),
                                                         m_tmp_name( tmp_name ),
                                                         m_worker( worker )
{
}

void ProcessExitAction::callback()
{
    if ( m_show_file == true &&
         ! m_tmp_name.empty() &&
         m_worker != NULL ) {
        std::list<std::string> l;
        l.push_back( m_tmp_name );
        
        FileViewer fv;
        m_worker->setWaitCursor();
        fv.view( l );
        m_worker->unsetWaitCursor();
    }

    if ( ! m_tmp_name.empty() ) {
        worker_unlink( m_tmp_name.c_str() );
    }
}
